/* crypto/store/str_err.c */
/* ====================================================================
 * Copyright (c) 1999-2003 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

/* NOTE: this file was auto generated by the mkerr.pl script: any changes
 * made to it will be overwritten when the script next updates this file,
 * only reason strings will be preserved.
 */

#include <stdio.h>
#include <openssl/err.h>
#include <openssl/store.h>

/* BEGIN ERROR CODES */
#ifndef OPENSSL_NO_ERR
static ERR_STRING_DATA STORE_str_functs[]=
	{
{ERR_PACK(0,STORE_F_CTRL,0),	"CTRL"},
{ERR_PACK(0,STORE_F_MEM_DELETE,0),	"MEM_DELETE"},
{ERR_PACK(0,STORE_F_MEM_GENERATE,0),	"MEM_GENERATE"},
{ERR_PACK(0,STORE_F_MEM_LIST_NEXT,0),	"MEM_LIST_NEXT"},
{ERR_PACK(0,STORE_F_MEM_LIST_START,0),	"MEM_LIST_START"},
{ERR_PACK(0,STORE_F_MEM_STORE,0),	"MEM_STORE"},
{ERR_PACK(0,STORE_F_STORE_ARBITRARY,0),	"STORE_ARBITRARY"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_GET0_CSTR,0),	"STORE_ATTR_INFO_get0_cstr"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_GET0_DN,0),	"STORE_ATTR_INFO_get0_dn"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_GET0_NUMBER,0),	"STORE_ATTR_INFO_get0_number"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_GET0_SHA1STR,0),	"STORE_ATTR_INFO_get0_sha1str"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_MODIFY_CSTR,0),	"STORE_ATTR_INFO_modify_cstr"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_MODIFY_DN,0),	"STORE_ATTR_INFO_modify_dn"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_MODIFY_NUMBER,0),	"STORE_ATTR_INFO_modify_number"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_MODIFY_SHA1STR,0),	"STORE_ATTR_INFO_modify_sha1str"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_SET_CSTR,0),	"STORE_ATTR_INFO_set_cstr"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_SET_DN,0),	"STORE_ATTR_INFO_set_dn"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_SET_NUMBER,0),	"STORE_ATTR_INFO_set_number"},
{ERR_PACK(0,STORE_F_STORE_ATTR_INFO_SET_SHA1STR,0),	"STORE_ATTR_INFO_set_sha1str"},
{ERR_PACK(0,STORE_F_STORE_CERTIFICATE,0),	"STORE_CERTIFICATE"},
{ERR_PACK(0,STORE_F_STORE_CRL,0),	"STORE_CRL"},
{ERR_PACK(0,STORE_F_STORE_CTRL,0),	"STORE_ctrl"},
{ERR_PACK(0,STORE_F_STORE_DELETE_ARBITRARY,0),	"STORE_delete_arbitrary"},
{ERR_PACK(0,STORE_F_STORE_DELETE_CERTIFICATE,0),	"STORE_delete_certificate"},
{ERR_PACK(0,STORE_F_STORE_DELETE_CRL,0),	"STORE_delete_crl"},
{ERR_PACK(0,STORE_F_STORE_DELETE_NUMBER,0),	"STORE_delete_number"},
{ERR_PACK(0,STORE_F_STORE_DELETE_PRIVATE_KEY,0),	"STORE_delete_private_key"},
{ERR_PACK(0,STORE_F_STORE_DELETE_PUBLIC_KEY,0),	"STORE_delete_public_key"},
{ERR_PACK(0,STORE_F_STORE_GENERATE_CRL,0),	"STORE_generate_crl"},
{ERR_PACK(0,STORE_F_STORE_GENERATE_KEY,0),	"STORE_generate_key"},
{ERR_PACK(0,STORE_F_STORE_GET_ARBITRARY,0),	"STORE_get_arbitrary"},
{ERR_PACK(0,STORE_F_STORE_GET_CERTIFICATE,0),	"STORE_get_certificate"},
{ERR_PACK(0,STORE_F_STORE_GET_CRL,0),	"STORE_get_crl"},
{ERR_PACK(0,STORE_F_STORE_GET_NUMBER,0),	"STORE_get_number"},
{ERR_PACK(0,STORE_F_STORE_GET_PRIVATE_KEY,0),	"STORE_get_private_key"},
{ERR_PACK(0,STORE_F_STORE_GET_PUBLIC_KEY,0),	"STORE_get_public_key"},
{ERR_PACK(0,STORE_F_STORE_LIST_CERTIFICATE_END,0),	"STORE_list_certificate_end"},
{ERR_PACK(0,STORE_F_STORE_LIST_CERTIFICATE_ENDP,0),	"STORE_list_certificate_endp"},
{ERR_PACK(0,STORE_F_STORE_LIST_CERTIFICATE_NEXT,0),	"STORE_list_certificate_next"},
{ERR_PACK(0,STORE_F_STORE_LIST_CERTIFICATE_START,0),	"STORE_list_certificate_start"},
{ERR_PACK(0,STORE_F_STORE_LIST_CRL_END,0),	"STORE_list_crl_end"},
{ERR_PACK(0,STORE_F_STORE_LIST_CRL_ENDP,0),	"STORE_list_crl_endp"},
{ERR_PACK(0,STORE_F_STORE_LIST_CRL_NEXT,0),	"STORE_list_crl_next"},
{ERR_PACK(0,STORE_F_STORE_LIST_CRL_START,0),	"STORE_list_crl_start"},
{ERR_PACK(0,STORE_F_STORE_LIST_PRIVATE_KEY_END,0),	"STORE_list_private_key_end"},
{ERR_PACK(0,STORE_F_STORE_LIST_PRIVATE_KEY_ENDP,0),	"STORE_list_private_key_endp"},
{ERR_PACK(0,STORE_F_STORE_LIST_PRIVATE_KEY_NEXT,0),	"STORE_list_private_key_next"},
{ERR_PACK(0,STORE_F_STORE_LIST_PRIVATE_KEY_START,0),	"STORE_list_private_key_start"},
{ERR_PACK(0,STORE_F_STORE_LIST_PUBLIC_KEY_END,0),	"STORE_list_public_key_end"},
{ERR_PACK(0,STORE_F_STORE_LIST_PUBLIC_KEY_ENDP,0),	"STORE_list_public_key_endp"},
{ERR_PACK(0,STORE_F_STORE_LIST_PUBLIC_KEY_NEXT,0),	"STORE_list_public_key_next"},
{ERR_PACK(0,STORE_F_STORE_LIST_PUBLIC_KEY_START,0),	"STORE_list_public_key_start"},
{ERR_PACK(0,STORE_F_STORE_MODIFY_ARBITRARY,0),	"STORE_modify_arbitrary"},
{ERR_PACK(0,STORE_F_STORE_MODIFY_CERTIFICATE,0),	"STORE_modify_certificate"},
{ERR_PACK(0,STORE_F_STORE_MODIFY_CRL,0),	"STORE_modify_crl"},
{ERR_PACK(0,STORE_F_STORE_MODIFY_NUMBER,0),	"STORE_modify_number"},
{ERR_PACK(0,STORE_F_STORE_MODIFY_PRIVATE_KEY,0),	"STORE_modify_private_key"},
{ERR_PACK(0,STORE_F_STORE_MODIFY_PUBLIC_KEY,0),	"STORE_modify_public_key"},
{ERR_PACK(0,STORE_F_STORE_NEW_ENGINE,0),	"STORE_new_engine"},
{ERR_PACK(0,STORE_F_STORE_NEW_METHOD,0),	"STORE_new_method"},
{ERR_PACK(0,STORE_F_STORE_NUMBER,0),	"STORE_NUMBER"},
{ERR_PACK(0,STORE_F_STORE_PARSE_ATTRS_END,0),	"STORE_parse_attrs_end"},
{ERR_PACK(0,STORE_F_STORE_PARSE_ATTRS_NEXT,0),	"STORE_parse_attrs_next"},
{ERR_PACK(0,STORE_F_STORE_PRIVATE_KEY,0),	"STORE_PRIVATE_KEY"},
{ERR_PACK(0,STORE_F_STORE_PUBLIC_KEY,0),	"STORE_PUBLIC_KEY"},
{ERR_PACK(0,STORE_F_STORE_REVOKE_CERTIFICATE,0),	"STORE_revoke_certificate"},
{ERR_PACK(0,STORE_F_STORE_REVOKE_PRIVATE_KEY,0),	"STORE_revoke_private_key"},
{ERR_PACK(0,STORE_F_STORE_REVOKE_PUBLIC_KEY,0),	"STORE_revoke_public_key"},
{0,NULL}
	};

static ERR_STRING_DATA STORE_str_reasons[]=
	{
{STORE_R_ALREADY_HAS_A_VALUE             ,"already has a value"},
{STORE_R_FAILED_DELETING_ARBITRARY       ,"failed deleting arbitrary"},
{STORE_R_FAILED_DELETING_CERTIFICATE     ,"failed deleting certificate"},
{STORE_R_FAILED_DELETING_KEY             ,"failed deleting key"},
{STORE_R_FAILED_DELETING_NUMBER          ,"failed deleting number"},
{STORE_R_FAILED_GENERATING_CRL           ,"failed generating crl"},
{STORE_R_FAILED_GENERATING_KEY           ,"failed generating key"},
{STORE_R_FAILED_GETTING_ARBITRARY        ,"failed getting arbitrary"},
{STORE_R_FAILED_GETTING_CERTIFICATE      ,"failed getting certificate"},
{STORE_R_FAILED_GETTING_KEY              ,"failed getting key"},
{STORE_R_FAILED_GETTING_NUMBER           ,"failed getting number"},
{STORE_R_FAILED_LISTING_CERTIFICATES     ,"failed listing certificates"},
{STORE_R_FAILED_LISTING_KEYS             ,"failed listing keys"},
{STORE_R_FAILED_MODIFYING_ARBITRARY      ,"failed modifying arbitrary"},
{STORE_R_FAILED_MODIFYING_CERTIFICATE    ,"failed modifying certificate"},
{STORE_R_FAILED_MODIFYING_CRL            ,"failed modifying crl"},
{STORE_R_FAILED_MODIFYING_NUMBER         ,"failed modifying number"},
{STORE_R_FAILED_MODIFYING_PRIVATE_KEY    ,"failed modifying private key"},
{STORE_R_FAILED_MODIFYING_PUBLIC_KEY     ,"failed modifying public key"},
{STORE_R_FAILED_REVOKING_CERTIFICATE     ,"failed revoking certificate"},
{STORE_R_FAILED_REVOKING_KEY             ,"failed revoking key"},
{STORE_R_FAILED_STORING_ARBITRARY        ,"failed storing arbitrary"},
{STORE_R_FAILED_STORING_CERTIFICATE      ,"failed storing certificate"},
{STORE_R_FAILED_STORING_KEY              ,"failed storing key"},
{STORE_R_FAILED_STORING_NUMBER           ,"failed storing number"},
{STORE_R_NOT_IMPLEMENTED                 ,"not implemented"},
{STORE_R_NO_CONTROL_FUNCTION             ,"no control function"},
{STORE_R_NO_DELETE_ARBITRARY_FUNCTION    ,"no delete arbitrary function"},
{STORE_R_NO_DELETE_NUMBER_FUNCTION       ,"no delete number function"},
{STORE_R_NO_DELETE_OBJECT_FUNCTION       ,"no delete object function"},
{STORE_R_NO_GENERATE_CRL_FUNCTION        ,"no generate crl function"},
{STORE_R_NO_GENERATE_OBJECT_FUNCTION     ,"no generate object function"},
{STORE_R_NO_GET_OBJECT_ARBITRARY_FUNCTION,"no get object arbitrary function"},
{STORE_R_NO_GET_OBJECT_FUNCTION          ,"no get object function"},
{STORE_R_NO_GET_OBJECT_NUMBER_FUNCTION   ,"no get object number function"},
{STORE_R_NO_LIST_OBJECT_ENDP_FUNCTION    ,"no list object endp function"},
{STORE_R_NO_LIST_OBJECT_END_FUNCTION     ,"no list object end function"},
{STORE_R_NO_LIST_OBJECT_NEXT_FUNCTION    ,"no list object next function"},
{STORE_R_NO_LIST_OBJECT_START_FUNCTION   ,"no list object start function"},
{STORE_R_NO_MODIFY_OBJECT_FUNCTION       ,"no modify object function"},
{STORE_R_NO_REVOKE_OBJECT_FUNCTION       ,"no revoke object function"},
{STORE_R_NO_STORE                        ,"no store"},
{STORE_R_NO_STORE_OBJECT_ARBITRARY_FUNCTION,"no store object arbitrary function"},
{STORE_R_NO_STORE_OBJECT_FUNCTION        ,"no store object function"},
{STORE_R_NO_STORE_OBJECT_NUMBER_FUNCTION ,"no store object number function"},
{STORE_R_NO_VALUE                        ,"no value"},
{0,NULL}
	};

#endif

void ERR_load_STORE_strings(void)
	{
	static int init=1;

	if (init)
		{
		init=0;
#ifndef OPENSSL_NO_ERR
		ERR_load_strings(ERR_LIB_STORE,STORE_str_functs);
		ERR_load_strings(ERR_LIB_STORE,STORE_str_reasons);
#endif

		}
	}
