// ====================================================================
// Written by Andy Polyakov <appro@fy.chalmers.se> for the OpenSSL
// project. Rights for redistribution and usage in source and binary
// forms are granted according to the OpenSSL license.
// ====================================================================
//
// What's wrong with compiler generated code? Compiler never uses
// variable 'shr' which is pairable with 'extr'/'dep' instructions.
// Then it uses 'zxt' which is an I-type, but can be replaced with
// 'and' which in turn can be assigned to M-port [there're double as
// much M-ports as there're I-ports on Itanium 2]. By sacrificing few
// registers for small constants (255, 24 and 16) to be used with
// 'shr' and 'and' instructions I can achieve better ILP, Intruction
// Level Parallelism, and performance. This code outperforms GCC 3.3
// generated code by over factor of 2 (two), GCC 3.4 - by 70% and
// HP C - by 40%. Measured best-case scenario, i.e. aligned
// big-endian input, ECB timing on Itanium 2 is (18 + 13*rounds)
// ticks per block, or 9.25 CPU cycles per byte for 128 bit key.

.ident	"aes-ia64.S, version 1.1"
.ident	"IA-64 ISA artwork by Andy Polyakov <appro@fy.chalmers.se>"
.explicit
.text

rk0=r8;     rk1=r9;

pfssave=r2;
lcsave=r10;
prsave=r3;
maskff=r11;
twenty4=r14;
sixteen=r15;

te00=r16;   te11=r17;   te22=r18;   te33=r19;
te01=r20;   te12=r21;   te23=r22;   te30=r23;
te02=r24;   te13=r25;   te20=r26;   te31=r27;
te03=r28;   te10=r29;   te21=r30;   te32=r31;

// these are rotating...
t0=r32;     s0=r33;
t1=r34;     s1=r35;
t2=r36;     s2=r37;
t3=r38;     s3=r39;

te0=r40;    te1=r41;    te2=r42;    te3=r43;

#if defined(_HPUX_SOURCE) && !defined(_LP64)
# define ADDP	addp4
# define KSZ	4
# define LDKEY	ld4
#else
# define ADDP	add
#endif

// This implies that AES_KEY comprises 32-bit key schedule elements
// even on LP64 platforms.
#ifndef	KSZ
# define KSZ	4
# define LDKEY	ld4
#endif

.proc	_ia64_AES_encrypt#
// Input:	rk0-rk1
//		te0
//		te3	as AES_KEY->rounds!!!
//		s0-s3
//		maskff,twenty4,sixteen
// Output:	r16,r20,r24,r28 as s0-s3
// Clobber:	r16-r31,rk0-rk1,r32-r43
.align	32
_ia64_AES_encrypt:
	.prologue
	.altrp	b6
	.body
{ .mmi;	alloc	r16=ar.pfs,12,0,0,8
	LDKEY	t0=[rk0],2*KSZ
	mov	pr.rot=1<<16	}
{ .mmi;	LDKEY	t1=[rk1],2*KSZ
	add	te1=1024,te0
	add	te3=-3,te3	};;
{ .mib;	LDKEY	t2=[rk0],2*KSZ
	mov	ar.ec=3		}
{ .mib;	LDKEY	t3=[rk1],2*KSZ
	add	te2=2048,te0
	brp.loop.imp	.Le_top,.Le_end-16	};;

{ .mmi;	xor	s0=s0,t0
	xor	s1=s1,t1
	mov	ar.lc=te3	}
{ .mmi;	xor	s2=s2,t2
	xor	s3=s3,t3
	add	te3=3072,te0	};;

.align	32
.Le_top:
{ .mmi;	(p0)	LDKEY	t0=[rk0],2*KSZ		// 0/0:rk[0]
	(p0)	and	te33=s3,maskff		// 0/0:s3&0xff
	(p0)	extr.u	te22=s2,8,8	}	// 0/0:s2>>8&0xff
{ .mmi; (p0)	LDKEY	t1=[rk1],2*KSZ		// 0/1:rk[1]
	(p0)	and	te30=s0,maskff		// 0/1:s0&0xff
	(p0)	shr.u	te00=s0,twenty4	};;	// 0/0:s0>>24
{ .mmi;	(p0)	LDKEY	t2=[rk0],2*KSZ		// 1/2:rk[2]
	(p0)	shladd	te33=te33,2,te3		// 1/0:te0+s0>>24
	(p0)	extr.u	te23=s3,8,8	}	// 1/1:s3>>8&0xff
{ .mmi;	(p0)	LDKEY	t3=[rk1],2*KSZ		// 1/3:rk[3]
	(p0)	shladd	te30=te30,2,te3		// 1/1:te3+s0
	(p0)	shr.u	te01=s1,twenty4	};;	// 1/1:s1>>24
{ .mmi;	(p0)	ld4	te33=[te33]		// 2/0:te3[s3&0xff]
	(p0)	shladd	te22=te22,2,te2		// 2/0:te2+s2>>8&0xff
	(p0)	extr.u	te20=s0,8,8	}	// 2/2:s0>>8&0xff
{ .mmi;	(p0)	ld4	te30=[te30]		// 2/1:te3[s0]
	(p0)	shladd	te23=te23,2,te2		// 2/1:te2+s3>>8
	(p0)	shr.u	te02=s2,twenty4	};;	// 2/2:s2>>24
{ .mmi;	(p0)	ld4	te22=[te22]		// 3/0:te2[s2>>8]
	(p0)	shladd	te20=te20,2,te2		// 3/2:te2+s0>>8
	(p0)	extr.u	te21=s1,8,8	}	// 3/3:s1>>8&0xff
{ .mmi;	(p0)	ld4	te23=[te23]		// 3/1:te2[s3>>8]
	(p0)	shladd	te00=te00,2,te0		// 3/0:te0+s0>>24
	(p0)	shr.u	te03=s3,twenty4	};;	// 3/3:s3>>24
{ .mmi;	(p0)	ld4	te20=[te20]		// 4/2:te2[s0>>8]
	(p0)	shladd	te21=te21,2,te2		// 4/3:te3+s2
	(p0)	extr.u	te11=s1,16,8	}	// 4/0:s1>>16&0xff
{ .mmi;	(p0)	ld4	te00=[te00]		// 4/0:te0[s0>>24]
	(p0)	shladd	te01=te01,2,te0		// 4/1:te0+s1>>24
	(p0)	shr.u	te13=s3,sixteen	};;	// 4/2:s3>>16
{ .mmi;	(p0)	ld4	te21=[te21]		// 5/3:te2[s1>>8]
	(p0)	shladd	te11=te11,2,te1		// 5/0:te1+s1>>16
	(p0)	extr.u	te12=s2,16,8	}	// 5/1:s2>>16&0xff
{ .mmi;	(p0)	ld4	te01=[te01]		// 5/1:te0[s1>>24]
	(p0)	shladd	te02=te02,2,te0		// 5/2:te0+s2>>24
	(p0)	and	te31=s1,maskff	};;	// 5/2:s1&0xff

{ .mmi;	(p0)	ld4	te11=[te11]		// 6/0:te1[s1>>16]
	(p0)	shladd	te12=te12,2,te1		// 6/1:te1+s2>>16
	(p0)	extr.u	te10=s0,16,8	}	// 6/3:s0>>16&0xff
{ .mmi;	(p0)	ld4	te02=[te02]		// 6/2:te0[s2>>24]
	(p0)	shladd	te03=te03,2,te0		// 6/3:te1+s0>>16
	(p0)	and	te32=s2,maskff	};;	// 6/3:s2&0xff
{ .mmi;	(p0)	ld4	te12=[te12]		// 7/1:te1[s2>>16]
	(p0)	shladd	te31=te31,2,te3		// 7/2:te3+s1&0xff
	(p0)	and	te13=te13,maskff}	// 7/2:s3>>16&0xff
{ .mmi;	(p0)	ld4	te03=[te03]		// 7/3:te0[s3>>24]
	(p0)	shladd	te32=te32,2,te3		// 7/3:te3+s2
	(p0)	xor	t0=t0,te33	};;	// 7/0:
{ .mmi;	(p0)	ld4	te31=[te31]		// 8/2:te3[s1]
	(p0)	shladd	te13=te13,2,te1		// 8/2:te1+s3>>16
	(p0)	xor	t0=t0,te22	}	// 8/0:
{ .mmi;	(p0)	ld4	te32=[te32]		// 8/3:te3[s2]
	(p0)	shladd	te10=te10,2,te1		// 8/3:te1+s0>>16
	(p0)	xor	t1=t1,te30	};;	// 8/1:
{ .mmi;	(p0)	ld4	te13=[te13]		// 9/2:te1[s3>>16]
	(p0)	xor	t0=t0,te00		// 9/0:
	(p0)	xor	t1=t1,te23	}	// 9/1:		
{ .mmi;	(p0)	ld4	te10=[te10]		// 9/3:te1[s0>>16]
	(p0)	xor	t2=t2,te20		// 9/2:
	(p0)	xor	t3=t3,te21	};;	// 9/3:
{ .mmi;	(p0)	xor	t0=t0,te11		// 10/0:done!
	(p0)	xor	t1=t1,te01		// 10/1:
	(p0)	xor	t2=t2,te02	}	// 10/2:
{ .mmi;	(p0)	xor	t3=t3,te03		// 10/3:
	(p16)	cmp.eq	p0,p17=r0,r0 	};;	// 10/clear (p17)
{ .mmi;	(p0)	xor	t1=t1,te12		// 11/1:done!
	(p0)	xor	t2=t2,te31		// 11/2:
	(p0)	xor	t3=t3,te32	}	// 11/3:
{ .mmi;	(p17)	add	te0=4096,te0		// 11/	
	(p17)	add	te1=4096,te1	};;	// 11/
{ .mib;	(p0)	xor	t2=t2,te13		// 12/2:done!
	(p0)	xor	t3=t3,te10	}	// 12/3:done!
{ .mib;	(p17)	add	te2=4096,te2		// 12/
	(p17)	add	te3=4096,te3		// 12/
	br.ctop.sptk	.Le_top		};;
.Le_end:
{ .mib;	mov	r16=s0
	mov	r20=s1			}
{ .mib;	mov	r24=s2
	mov	r28=s3
	br.ret.sptk	b6		};;
.endp	_ia64_AES_encrypt#

// void AES_encrypt (const void *in,void *out,const AES_KEY *key);
.global	AES_encrypt#
.proc	AES_encrypt#
.align	32
.skip	16
AES_encrypt:
	.prologue
	.save	ar.pfs,pfssave
{ .mmi;	alloc	pfssave=ar.pfs,3,0,12,0
	and	out0=3,in0
	mov	r3=ip			}
{ .mmi;	ADDP	in0=0,in0
	ADDP	out11=KSZ*60,in2		// &AES_KEY->rounds
	.save	ar.lc,lcsave
	mov	lcsave=ar.lc		};;

{ .mmi;	ld4	out11=[out11]			// AES_KEY->rounds
	add	out8=(AES_Te#-AES_encrypt#),r3	// Te0
	.save	pr,prsave
	mov	prsave=pr		}

	.body
#if defined(_HPUX_SOURCE)	// HPUX is big-endian, cut 15+15 cycles...
{ .mib; cmp.ne	p6,p0=out0,r0
	add	out0=4,in0
(p6)	br.dpnt.many	.Le_i_unaligned	};;

{ .mmi;	ld4	out1=[in0],8		// s0
	and	out9=3,in1
	mov	twenty4=24		}
{ .mmi;	ld4	out3=[out0],8		// s1
	ADDP	rk0=0,in2
	mov	sixteen=16		};;
{ .mmi;	ld4	out5=[in0]		// s2
	cmp.ne	p6,p0=out9,r0
	mov	maskff=0xff		}
{ .mmb;	ld4	out7=[out0]		// s3
	ADDP	rk1=KSZ,in2
	br.call.sptk.many	b6=_ia64_AES_encrypt	};;

{ .mib;	ADDP	in0=4,in1
	ADDP	in1=0,in1
(p6)	br.spnt	.Le_o_unaligned		};;

{ .mii;	mov	ar.pfs=psfsave
	mov	ar.lc=lcsave		}
{ .mmi;	st4	[in1]=r16,8		// s0
	st4	[in0]=r20,8		// s1
	mov	pr=prsave,0x1ffff	};;
{ .mmb;	st4	[in1]=r24		// s2
	st4	[in0]=r28		// s3
	br.ret.sptk.many	b0	};;
#endif

.align	32
.Le_i_unaligned:
{ .mmi;	add	out0=1,in0
	add	out2=2,in0
	add	out4=3,in0	};;
{ .mmi;	ld1	r16=[in0],4
	ld1	r17=[out0],4	}//;;
{ .mmi;	ld1	r18=[out2],4
	ld1	out1=[out4],4	};;	// s0
{ .mmi;	ld1	r20=[in0],4
	ld1	r21=[out0],4	}//;;
{ .mmi;	ld1	r22=[out2],4
	ld1	out3=[out4],4	};;	// s1
{ .mmi;	ld1	r24=[in0],4
	ld1	r25=[out0],4	}//;;
{ .mmi;	ld1	r26=[out2],4
	ld1	out5=[out4],4	};;	// s2
{ .mmi;	ld1	r28=[in0]
	ld1	r29=[out0]	}//;;
{ .mmi;	ld1	r30=[out2]
	ld1	out7=[out4]	};;	// s3

{ .mii;
	dep	out1=r16,out1,24,8	//;;
	dep	out3=r20,out3,24,8	}//;;
{ .mii;	ADDP	rk0=0,in2
	dep	out5=r24,out5,24,8	//;;
	dep	out7=r28,out7,24,8	};;
{ .mii;	ADDP	rk1=KSZ,in2
	dep	out1=r17,out1,16,8	//;;
	dep	out3=r21,out3,16,8	}//;;
{ .mii;	mov	twenty4=24
	dep	out5=r25,out5,16,8	//;;
	dep	out7=r29,out7,16,8	};;
{ .mii;	mov	sixteen=16
	dep	out1=r18,out1,8,8	//;;
	dep	out3=r22,out3,8,8	}//;;
{ .mii;	mov	maskff=0xff
	dep	out5=r26,out5,8,8	//;;
	dep	out7=r30,out7,8,8	};;

{ .mib;	br.call.sptk.many	b6=_ia64_AES_encrypt	};;

.Le_o_unaligned:
{ .mii;	ADDP	out0=0,in1
	extr.u	r17=r16,8,8			// s0
	shr.u	r19=r16,twenty4		}//;;
{ .mii;	ADDP	out1=1,in1
	extr.u	r18=r16,16,8
	shr.u	r23=r20,twenty4		}//;;	// s1
{ .mii;	ADDP	out2=2,in1
	extr.u	r21=r20,8,8
	shr.u	r22=r20,sixteen	}//;;
{ .mii;	ADDP	out3=3,in1
	extr.u	r25=r24,8,8			// s2
	shr.u	r27=r24,twenty4		};;
{ .mii;	st1	[out3]=r16,4
	extr.u	r26=r24,16,8
	shr.u	r31=r28,twenty4	}//;;	// s3
{ .mii;	st1	[out2]=r17,4
	extr.u	r29=r28,8,8
	shr.u	r30=r28,sixteen		}//;;

{ .mmi;	st1	[out1]=r18,4
	st1	[out0]=r19,4		};;
{ .mmi;	st1	[out3]=r20,4
	st1	[out2]=r21,4		}//;;
{ .mmi;	st1	[out1]=r22,4
	st1	[out0]=r23,4		};;
{ .mmi;	st1	[out3]=r24,4
	st1	[out2]=r25,4
	mov	pr=prsave,0x1ffff	}//;;
{ .mmi;	st1	[out1]=r26,4
	st1	[out0]=r27,4
	mov	ar.pfs=pfssave		};;
{ .mmi;	st1	[out3]=r28
	st1	[out2]=r29
	mov	ar.lc=lcsave		}//;;
{ .mmb;	st1	[out1]=r30
	st1	[out0]=r31
	br.ret.sptk.many	b0	};;
.endp	AES_encrypt#

// *AES_decrypt are autogenerated by the following script:
#if 0
#!/usr/bin/env perl
print "// *AES_decrypt are autogenerated by the following script:\n#if 0\n";
open(PROG,'<'.$0); while(<PROG>) { print; } close(PROG);
print "#endif\n";
while(<>) {
	$process=1	if (/\.proc\s+_ia64_AES_encrypt/);
	next		if (!$process);

	#s/te00=s0/td00=s0/;	s/te00/td00/g;
	s/te11=s1/td13=s3/;	s/te11/td13/g;
	#s/te22=s2/td22=s2/;	s/te22/td22/g;
	s/te33=s3/td31=s1/;	s/te33/td31/g;

	#s/te01=s1/td01=s1/;	s/te01/td01/g;
	s/te12=s2/td10=s0/;	s/te12/td10/g;
	#s/te23=s3/td23=s3/;	s/te23/td23/g;
	s/te30=s0/td32=s2/;	s/te30/td32/g;

	#s/te02=s2/td02=s2/;	s/te02/td02/g;
	s/te13=s3/td11=s1/;	s/te13/td11/g;
	#s/te20=s0/td20=s0/;	s/te20/td20/g;
	s/te31=s1/td33=s3/;	s/te31/td33/g;

	#s/te03=s3/td03=s3/;	s/te03/td03/g;
	s/te10=s0/td12=s2/;	s/te10/td12/g;
	#s/te21=s1/td21=s1/;	s/te21/td21/g;
	s/te32=s2/td30=s0/;	s/te32/td30/g;

	s/td/te/g;

	s/AES_encrypt/AES_decrypt/g;
	s/\.Le_/.Ld_/g;
	s/AES_Te#/AES_Td#/g;

	print;

	exit		if (/\.endp\s+AES_decrypt/);
}
#endif
.proc	_ia64_AES_decrypt#
// Input:	rk0-rk1
//		te0
//		te3	as AES_KEY->rounds!!!
//		s0-s3
//		maskff,twenty4,sixteen
// Output:	r16,r20,r24,r28 as s0-s3
// Clobber:	r16-r31,rk0-rk1,r32-r43
.align	32
_ia64_AES_decrypt:
	.prologue
	.altrp	b6
	.body
{ .mmi;	alloc	r16=ar.pfs,12,0,0,8
	LDKEY	t0=[rk0],2*KSZ
	mov	pr.rot=1<<16	}
{ .mmi;	LDKEY	t1=[rk1],2*KSZ
	add	te1=1024,te0
	add	te3=-3,te3	};;
{ .mib;	LDKEY	t2=[rk0],2*KSZ
	mov	ar.ec=3		}
{ .mib;	LDKEY	t3=[rk1],2*KSZ
	add	te2=2048,te0
	brp.loop.imp	.Ld_top,.Ld_end-16	};;

{ .mmi;	xor	s0=s0,t0
	xor	s1=s1,t1
	mov	ar.lc=te3	}
{ .mmi;	xor	s2=s2,t2
	xor	s3=s3,t3
	add	te3=3072,te0	};;

.align	32
.Ld_top:
{ .mmi;	(p0)	LDKEY	t0=[rk0],2*KSZ		// 0/0:rk[0]
	(p0)	and	te31=s1,maskff		// 0/0:s3&0xff
	(p0)	extr.u	te22=s2,8,8	}	// 0/0:s2>>8&0xff
{ .mmi; (p0)	LDKEY	t1=[rk1],2*KSZ		// 0/1:rk[1]
	(p0)	and	te32=s2,maskff		// 0/1:s0&0xff
	(p0)	shr.u	te00=s0,twenty4	};;	// 0/0:s0>>24
{ .mmi;	(p0)	LDKEY	t2=[rk0],2*KSZ		// 1/2:rk[2]
	(p0)	shladd	te31=te31,2,te3		// 1/0:te0+s0>>24
	(p0)	extr.u	te23=s3,8,8	}	// 1/1:s3>>8&0xff
{ .mmi;	(p0)	LDKEY	t3=[rk1],2*KSZ		// 1/3:rk[3]
	(p0)	shladd	te32=te32,2,te3		// 1/1:te3+s0
	(p0)	shr.u	te01=s1,twenty4	};;	// 1/1:s1>>24
{ .mmi;	(p0)	ld4	te31=[te31]		// 2/0:te3[s3&0xff]
	(p0)	shladd	te22=te22,2,te2		// 2/0:te2+s2>>8&0xff
	(p0)	extr.u	te20=s0,8,8	}	// 2/2:s0>>8&0xff
{ .mmi;	(p0)	ld4	te32=[te32]		// 2/1:te3[s0]
	(p0)	shladd	te23=te23,2,te2		// 2/1:te2+s3>>8
	(p0)	shr.u	te02=s2,twenty4	};;	// 2/2:s2>>24
{ .mmi;	(p0)	ld4	te22=[te22]		// 3/0:te2[s2>>8]
	(p0)	shladd	te20=te20,2,te2		// 3/2:te2+s0>>8
	(p0)	extr.u	te21=s1,8,8	}	// 3/3:s1>>8&0xff
{ .mmi;	(p0)	ld4	te23=[te23]		// 3/1:te2[s3>>8]
	(p0)	shladd	te00=te00,2,te0		// 3/0:te0+s0>>24
	(p0)	shr.u	te03=s3,twenty4	};;	// 3/3:s3>>24
{ .mmi;	(p0)	ld4	te20=[te20]		// 4/2:te2[s0>>8]
	(p0)	shladd	te21=te21,2,te2		// 4/3:te3+s2
	(p0)	extr.u	te13=s3,16,8	}	// 4/0:s1>>16&0xff
{ .mmi;	(p0)	ld4	te00=[te00]		// 4/0:te0[s0>>24]
	(p0)	shladd	te01=te01,2,te0		// 4/1:te0+s1>>24
	(p0)	shr.u	te11=s1,sixteen	};;	// 4/2:s3>>16
{ .mmi;	(p0)	ld4	te21=[te21]		// 5/3:te2[s1>>8]
	(p0)	shladd	te13=te13,2,te1		// 5/0:te1+s1>>16
	(p0)	extr.u	te10=s0,16,8	}	// 5/1:s2>>16&0xff
{ .mmi;	(p0)	ld4	te01=[te01]		// 5/1:te0[s1>>24]
	(p0)	shladd	te02=te02,2,te0		// 5/2:te0+s2>>24
	(p0)	and	te33=s3,maskff	};;	// 5/2:s1&0xff

{ .mmi;	(p0)	ld4	te13=[te13]		// 6/0:te1[s1>>16]
	(p0)	shladd	te10=te10,2,te1		// 6/1:te1+s2>>16
	(p0)	extr.u	te12=s2,16,8	}	// 6/3:s0>>16&0xff
{ .mmi;	(p0)	ld4	te02=[te02]		// 6/2:te0[s2>>24]
	(p0)	shladd	te03=te03,2,te0		// 6/3:te1+s0>>16
	(p0)	and	te30=s0,maskff	};;	// 6/3:s2&0xff
{ .mmi;	(p0)	ld4	te10=[te10]		// 7/1:te1[s2>>16]
	(p0)	shladd	te33=te33,2,te3		// 7/2:te3+s1&0xff
	(p0)	and	te11=te11,maskff}	// 7/2:s3>>16&0xff
{ .mmi;	(p0)	ld4	te03=[te03]		// 7/3:te0[s3>>24]
	(p0)	shladd	te30=te30,2,te3		// 7/3:te3+s2
	(p0)	xor	t0=t0,te31	};;	// 7/0:
{ .mmi;	(p0)	ld4	te33=[te33]		// 8/2:te3[s1]
	(p0)	shladd	te11=te11,2,te1		// 8/2:te1+s3>>16
	(p0)	xor	t0=t0,te22	}	// 8/0:
{ .mmi;	(p0)	ld4	te30=[te30]		// 8/3:te3[s2]
	(p0)	shladd	te12=te12,2,te1		// 8/3:te1+s0>>16
	(p0)	xor	t1=t1,te32	};;	// 8/1:
{ .mmi;	(p0)	ld4	te11=[te11]		// 9/2:te1[s3>>16]
	(p0)	xor	t0=t0,te00		// 9/0:
	(p0)	xor	t1=t1,te23	}	// 9/1:		
{ .mmi;	(p0)	ld4	te12=[te12]		// 9/3:te1[s0>>16]
	(p0)	xor	t2=t2,te20		// 9/2:
	(p0)	xor	t3=t3,te21	};;	// 9/3:
{ .mmi;	(p0)	xor	t0=t0,te13		// 10/0:done!
	(p0)	xor	t1=t1,te01		// 10/1:
	(p0)	xor	t2=t2,te02	}	// 10/2:
{ .mmi;	(p0)	xor	t3=t3,te03		// 10/3:
	(p16)	cmp.eq	p0,p17=r0,r0 	};;	// 10/clear (p17)
{ .mmi;	(p0)	xor	t1=t1,te10		// 11/1:done!
	(p0)	xor	t2=t2,te33		// 11/2:
	(p0)	xor	t3=t3,te30	}	// 11/3:
{ .mmi;	(p17)	add	te0=4096,te0		// 11/	
	(p17)	add	te1=4096,te1	};;	// 11/
{ .mib;	(p0)	xor	t2=t2,te11		// 12/2:done!
	(p0)	xor	t3=t3,te12	}	// 12/3:done!
{ .mib;	(p17)	add	te2=4096,te2		// 12/
	(p17)	add	te3=4096,te3		// 12/
	br.ctop.sptk	.Ld_top		};;
.Ld_end:
{ .mib;	mov	r16=s0
	mov	r20=s1			}
{ .mib;	mov	r24=s2
	mov	r28=s3
	br.ret.sptk	b6		};;
.endp	_ia64_AES_decrypt#

// void AES_decrypt (const void *in,void *out,const AES_KEY *key);
.global	AES_decrypt#
.proc	AES_decrypt#
.align	32
.skip	16
AES_decrypt:
	.prologue
	.save	ar.pfs,pfssave
{ .mmi;	alloc	pfssave=ar.pfs,3,0,12,0
	and	out0=3,in0
	mov	r3=ip			}
{ .mmi;	ADDP	in0=0,in0
	ADDP	out11=KSZ*60,in2		// &AES_KEY->rounds
	.save	ar.lc,lcsave
	mov	lcsave=ar.lc		};;

{ .mmi;	ld4	out11=[out11]			// AES_KEY->rounds
	add	out8=(AES_Td#-AES_decrypt#),r3	// Td0
	.save	pr,prsave
	mov	prsave=pr		}

	.body
#if defined(_HPUX_SOURCE)	// HPUX is big-endian, cut 15+15 cycles...
{ .mib; cmp.ne	p6,p0=out0,r0
	add	out0=4,in0
(p6)	br.dpnt.many	.Ld_i_unaligned	};;

{ .mmi;	ld4	out1=[in0],8		// s0
	and	out9=3,in1
	mov	twenty4=24		}
{ .mmi;	ld4	out3=[out0],8		// s1
	ADDP	rk0=0,in2
	mov	sixteen=16		};;
{ .mmi;	ld4	out5=[in0]		// s2
	cmp.ne	p6,p0=out9,r0
	mov	maskff=0xff		}
{ .mmb;	ld4	out7=[out0]		// s3
	ADDP	rk1=KSZ,in2
	br.call.sptk.many	b6=_ia64_AES_decrypt	};;

{ .mib;	ADDP	in0=4,in1
	ADDP	in1=0,in1
(p6)	br.spnt	.Ld_o_unaligned		};;

{ .mii;	mov	ar.pfs=pfssave
	mov	ar.lc=lcsave		}
{ .mmi;	st4	[in1]=r16,8		// s0
	st4	[in0]=r20,8		// s1
	mov	pr=prsave,0x1ffff	};;
{ .mmb;	st4	[in1]=r24		// s2
	st4	[in0]=r28		// s3
	br.ret.sptk.many	b0	};;
#endif

.align	32
.Ld_i_unaligned:
{ .mmi;	add	out0=1,in0
	add	out2=2,in0
	add	out4=3,in0	};;
{ .mmi;	ld1	r16=[in0],4
	ld1	r17=[out0],4	}//;;
{ .mmi;	ld1	r18=[out2],4
	ld1	out1=[out4],4	};;	// s0
{ .mmi;	ld1	r20=[in0],4
	ld1	r21=[out0],4	}//;;
{ .mmi;	ld1	r22=[out2],4
	ld1	out3=[out4],4	};;	// s1
{ .mmi;	ld1	r24=[in0],4
	ld1	r25=[out0],4	}//;;
{ .mmi;	ld1	r26=[out2],4
	ld1	out5=[out4],4	};;	// s2
{ .mmi;	ld1	r28=[in0]
	ld1	r29=[out0]	}//;;
{ .mmi;	ld1	r30=[out2]
	ld1	out7=[out4]	};;	// s3

{ .mii;
	dep	out1=r16,out1,24,8	//;;
	dep	out3=r20,out3,24,8	}//;;
{ .mii;	ADDP	rk0=0,in2
	dep	out5=r24,out5,24,8	//;;
	dep	out7=r28,out7,24,8	};;
{ .mii;	ADDP	rk1=KSZ,in2
	dep	out1=r17,out1,16,8	//;;
	dep	out3=r21,out3,16,8	}//;;
{ .mii;	mov	twenty4=24
	dep	out5=r25,out5,16,8	//;;
	dep	out7=r29,out7,16,8	};;
{ .mii;	mov	sixteen=16
	dep	out1=r18,out1,8,8	//;;
	dep	out3=r22,out3,8,8	}//;;
{ .mii;	mov	maskff=0xff
	dep	out5=r26,out5,8,8	//;;
	dep	out7=r30,out7,8,8	};;

{ .mib;	br.call.sptk.many	b6=_ia64_AES_decrypt	};;

.Ld_o_unaligned:
{ .mii;	ADDP	out0=0,in1
	extr.u	r17=r16,8,8			// s0
	shr.u	r19=r16,twenty4		}//;;
{ .mii;	ADDP	out1=1,in1
	extr.u	r18=r16,16,8
	shr.u	r23=r20,twenty4		}//;;	// s1
{ .mii;	ADDP	out2=2,in1
	extr.u	r21=r20,8,8
	shr.u	r22=r20,sixteen	}//;;
{ .mii;	ADDP	out3=3,in1
	extr.u	r25=r24,8,8			// s2
	shr.u	r27=r24,twenty4		};;
{ .mii;	st1	[out3]=r16,4
	extr.u	r26=r24,16,8
	shr.u	r31=r28,twenty4	}//;;	// s3
{ .mii;	st1	[out2]=r17,4
	extr.u	r29=r28,8,8
	shr.u	r30=r28,sixteen		}//;;

{ .mmi;	st1	[out1]=r18,4
	st1	[out0]=r19,4		};;
{ .mmi;	st1	[out3]=r20,4
	st1	[out2]=r21,4		}//;;
{ .mmi;	st1	[out1]=r22,4
	st1	[out0]=r23,4		};;
{ .mmi;	st1	[out3]=r24,4
	st1	[out2]=r25,4
	mov	pr=prsave,0x1ffff	}//;;
{ .mmi;	st1	[out1]=r26,4
	st1	[out0]=r27,4
	mov	ar.pfs=pfssave		};;
{ .mmi;	st1	[out3]=r28
	st1	[out2]=r29
	mov	ar.lc=lcsave		}//;;
{ .mmb;	st1	[out1]=r30
	st1	[out0]=r31
	br.ret.sptk.many	b0	};;
.endp	AES_decrypt#

// leave it in .text segment...
.align	64
.global	AES_Te#
.type	AES_Te#,@object
AES_Te:	data4	0xc66363a5, 0xf87c7c84, 0xee777799, 0xf67b7b8d
	data4	0xfff2f20d, 0xd66b6bbd, 0xde6f6fb1, 0x91c5c554
	data4	0x60303050, 0x02010103, 0xce6767a9, 0x562b2b7d
	data4	0xe7fefe19, 0xb5d7d762, 0x4dababe6, 0xec76769a
	data4	0x8fcaca45, 0x1f82829d, 0x89c9c940, 0xfa7d7d87
	data4	0xeffafa15, 0xb25959eb, 0x8e4747c9, 0xfbf0f00b
	data4	0x41adadec, 0xb3d4d467, 0x5fa2a2fd, 0x45afafea
	data4	0x239c9cbf, 0x53a4a4f7, 0xe4727296, 0x9bc0c05b
	data4	0x75b7b7c2, 0xe1fdfd1c, 0x3d9393ae, 0x4c26266a
	data4	0x6c36365a, 0x7e3f3f41, 0xf5f7f702, 0x83cccc4f
	data4	0x6834345c, 0x51a5a5f4, 0xd1e5e534, 0xf9f1f108
	data4	0xe2717193, 0xabd8d873, 0x62313153, 0x2a15153f
	data4	0x0804040c, 0x95c7c752, 0x46232365, 0x9dc3c35e
	data4	0x30181828, 0x379696a1, 0x0a05050f, 0x2f9a9ab5
	data4	0x0e070709, 0x24121236, 0x1b80809b, 0xdfe2e23d
	data4	0xcdebeb26, 0x4e272769, 0x7fb2b2cd, 0xea75759f
	data4	0x1209091b, 0x1d83839e, 0x582c2c74, 0x341a1a2e
	data4	0x361b1b2d, 0xdc6e6eb2, 0xb45a5aee, 0x5ba0a0fb
	data4	0xa45252f6, 0x763b3b4d, 0xb7d6d661, 0x7db3b3ce
	data4	0x5229297b, 0xdde3e33e, 0x5e2f2f71, 0x13848497
	data4	0xa65353f5, 0xb9d1d168, 0x00000000, 0xc1eded2c
	data4	0x40202060, 0xe3fcfc1f, 0x79b1b1c8, 0xb65b5bed
	data4	0xd46a6abe, 0x8dcbcb46, 0x67bebed9, 0x7239394b
	data4	0x944a4ade, 0x984c4cd4, 0xb05858e8, 0x85cfcf4a
	data4	0xbbd0d06b, 0xc5efef2a, 0x4faaaae5, 0xedfbfb16
	data4	0x864343c5, 0x9a4d4dd7, 0x66333355, 0x11858594
	data4	0x8a4545cf, 0xe9f9f910, 0x04020206, 0xfe7f7f81
	data4	0xa05050f0, 0x783c3c44, 0x259f9fba, 0x4ba8a8e3
	data4	0xa25151f3, 0x5da3a3fe, 0x804040c0, 0x058f8f8a
	data4	0x3f9292ad, 0x219d9dbc, 0x70383848, 0xf1f5f504
	data4	0x63bcbcdf, 0x77b6b6c1, 0xafdada75, 0x42212163
	data4	0x20101030, 0xe5ffff1a, 0xfdf3f30e, 0xbfd2d26d
	data4	0x81cdcd4c, 0x180c0c14, 0x26131335, 0xc3ecec2f
	data4	0xbe5f5fe1, 0x359797a2, 0x884444cc, 0x2e171739
	data4	0x93c4c457, 0x55a7a7f2, 0xfc7e7e82, 0x7a3d3d47
	data4	0xc86464ac, 0xba5d5de7, 0x3219192b, 0xe6737395
	data4	0xc06060a0, 0x19818198, 0x9e4f4fd1, 0xa3dcdc7f
	data4	0x44222266, 0x542a2a7e, 0x3b9090ab, 0x0b888883
	data4	0x8c4646ca, 0xc7eeee29, 0x6bb8b8d3, 0x2814143c
	data4	0xa7dede79, 0xbc5e5ee2, 0x160b0b1d, 0xaddbdb76
	data4	0xdbe0e03b, 0x64323256, 0x743a3a4e, 0x140a0a1e
	data4	0x924949db, 0x0c06060a, 0x4824246c, 0xb85c5ce4
	data4	0x9fc2c25d, 0xbdd3d36e, 0x43acacef, 0xc46262a6
	data4	0x399191a8, 0x319595a4, 0xd3e4e437, 0xf279798b
	data4	0xd5e7e732, 0x8bc8c843, 0x6e373759, 0xda6d6db7
	data4	0x018d8d8c, 0xb1d5d564, 0x9c4e4ed2, 0x49a9a9e0
	data4	0xd86c6cb4, 0xac5656fa, 0xf3f4f407, 0xcfeaea25
	data4	0xca6565af, 0xf47a7a8e, 0x47aeaee9, 0x10080818
	data4	0x6fbabad5, 0xf0787888, 0x4a25256f, 0x5c2e2e72
	data4	0x381c1c24, 0x57a6a6f1, 0x73b4b4c7, 0x97c6c651
	data4	0xcbe8e823, 0xa1dddd7c, 0xe874749c, 0x3e1f1f21
	data4	0x964b4bdd, 0x61bdbddc, 0x0d8b8b86, 0x0f8a8a85
	data4	0xe0707090, 0x7c3e3e42, 0x71b5b5c4, 0xcc6666aa
	data4	0x904848d8, 0x06030305, 0xf7f6f601, 0x1c0e0e12
	data4	0xc26161a3, 0x6a35355f, 0xae5757f9, 0x69b9b9d0
	data4	0x17868691, 0x99c1c158, 0x3a1d1d27, 0x279e9eb9
	data4	0xd9e1e138, 0xebf8f813, 0x2b9898b3, 0x22111133
	data4	0xd26969bb, 0xa9d9d970, 0x078e8e89, 0x339494a7
	data4	0x2d9b9bb6, 0x3c1e1e22, 0x15878792, 0xc9e9e920
	data4	0x87cece49, 0xaa5555ff, 0x50282878, 0xa5dfdf7a
	data4	0x038c8c8f, 0x59a1a1f8, 0x09898980, 0x1a0d0d17
	data4	0x65bfbfda, 0xd7e6e631, 0x844242c6, 0xd06868b8
	data4	0x824141c3, 0x299999b0, 0x5a2d2d77, 0x1e0f0f11
	data4	0x7bb0b0cb, 0xa85454fc, 0x6dbbbbd6, 0x2c16163a
// Te1:
	data4	0xa5c66363, 0x84f87c7c, 0x99ee7777, 0x8df67b7b
	data4	0x0dfff2f2, 0xbdd66b6b, 0xb1de6f6f, 0x5491c5c5
	data4	0x50603030, 0x03020101, 0xa9ce6767, 0x7d562b2b
	data4	0x19e7fefe, 0x62b5d7d7, 0xe64dabab, 0x9aec7676
	data4	0x458fcaca, 0x9d1f8282, 0x4089c9c9, 0x87fa7d7d
	data4	0x15effafa, 0xebb25959, 0xc98e4747, 0x0bfbf0f0
	data4	0xec41adad, 0x67b3d4d4, 0xfd5fa2a2, 0xea45afaf
	data4	0xbf239c9c, 0xf753a4a4, 0x96e47272, 0x5b9bc0c0
	data4	0xc275b7b7, 0x1ce1fdfd, 0xae3d9393, 0x6a4c2626
	data4	0x5a6c3636, 0x417e3f3f, 0x02f5f7f7, 0x4f83cccc
	data4	0x5c683434, 0xf451a5a5, 0x34d1e5e5, 0x08f9f1f1
	data4	0x93e27171, 0x73abd8d8, 0x53623131, 0x3f2a1515
	data4	0x0c080404, 0x5295c7c7, 0x65462323, 0x5e9dc3c3
	data4	0x28301818, 0xa1379696, 0x0f0a0505, 0xb52f9a9a
	data4	0x090e0707, 0x36241212, 0x9b1b8080, 0x3ddfe2e2
	data4	0x26cdebeb, 0x694e2727, 0xcd7fb2b2, 0x9fea7575
	data4	0x1b120909, 0x9e1d8383, 0x74582c2c, 0x2e341a1a
	data4	0x2d361b1b, 0xb2dc6e6e, 0xeeb45a5a, 0xfb5ba0a0
	data4	0xf6a45252, 0x4d763b3b, 0x61b7d6d6, 0xce7db3b3
	data4	0x7b522929, 0x3edde3e3, 0x715e2f2f, 0x97138484
	data4	0xf5a65353, 0x68b9d1d1, 0x00000000, 0x2cc1eded
	data4	0x60402020, 0x1fe3fcfc, 0xc879b1b1, 0xedb65b5b
	data4	0xbed46a6a, 0x468dcbcb, 0xd967bebe, 0x4b723939
	data4	0xde944a4a, 0xd4984c4c, 0xe8b05858, 0x4a85cfcf
	data4	0x6bbbd0d0, 0x2ac5efef, 0xe54faaaa, 0x16edfbfb
	data4	0xc5864343, 0xd79a4d4d, 0x55663333, 0x94118585
	data4	0xcf8a4545, 0x10e9f9f9, 0x06040202, 0x81fe7f7f
	data4	0xf0a05050, 0x44783c3c, 0xba259f9f, 0xe34ba8a8
	data4	0xf3a25151, 0xfe5da3a3, 0xc0804040, 0x8a058f8f
	data4	0xad3f9292, 0xbc219d9d, 0x48703838, 0x04f1f5f5
	data4	0xdf63bcbc, 0xc177b6b6, 0x75afdada, 0x63422121
	data4	0x30201010, 0x1ae5ffff, 0x0efdf3f3, 0x6dbfd2d2
	data4	0x4c81cdcd, 0x14180c0c, 0x35261313, 0x2fc3ecec
	data4	0xe1be5f5f, 0xa2359797, 0xcc884444, 0x392e1717
	data4	0x5793c4c4, 0xf255a7a7, 0x82fc7e7e, 0x477a3d3d
	data4	0xacc86464, 0xe7ba5d5d, 0x2b321919, 0x95e67373
	data4	0xa0c06060, 0x98198181, 0xd19e4f4f, 0x7fa3dcdc
	data4	0x66442222, 0x7e542a2a, 0xab3b9090, 0x830b8888
	data4	0xca8c4646, 0x29c7eeee, 0xd36bb8b8, 0x3c281414
	data4	0x79a7dede, 0xe2bc5e5e, 0x1d160b0b, 0x76addbdb
	data4	0x3bdbe0e0, 0x56643232, 0x4e743a3a, 0x1e140a0a
	data4	0xdb924949, 0x0a0c0606, 0x6c482424, 0xe4b85c5c
	data4	0x5d9fc2c2, 0x6ebdd3d3, 0xef43acac, 0xa6c46262
	data4	0xa8399191, 0xa4319595, 0x37d3e4e4, 0x8bf27979
	data4	0x32d5e7e7, 0x438bc8c8, 0x596e3737, 0xb7da6d6d
	data4	0x8c018d8d, 0x64b1d5d5, 0xd29c4e4e, 0xe049a9a9
	data4	0xb4d86c6c, 0xfaac5656, 0x07f3f4f4, 0x25cfeaea
	data4	0xafca6565, 0x8ef47a7a, 0xe947aeae, 0x18100808
	data4	0xd56fbaba, 0x88f07878, 0x6f4a2525, 0x725c2e2e
	data4	0x24381c1c, 0xf157a6a6, 0xc773b4b4, 0x5197c6c6
	data4	0x23cbe8e8, 0x7ca1dddd, 0x9ce87474, 0x213e1f1f
	data4	0xdd964b4b, 0xdc61bdbd, 0x860d8b8b, 0x850f8a8a
	data4	0x90e07070, 0x427c3e3e, 0xc471b5b5, 0xaacc6666
	data4	0xd8904848, 0x05060303, 0x01f7f6f6, 0x121c0e0e
	data4	0xa3c26161, 0x5f6a3535, 0xf9ae5757, 0xd069b9b9
	data4	0x91178686, 0x5899c1c1, 0x273a1d1d, 0xb9279e9e
	data4	0x38d9e1e1, 0x13ebf8f8, 0xb32b9898, 0x33221111
	data4	0xbbd26969, 0x70a9d9d9, 0x89078e8e, 0xa7339494
	data4	0xb62d9b9b, 0x223c1e1e, 0x92158787, 0x20c9e9e9
	data4	0x4987cece, 0xffaa5555, 0x78502828, 0x7aa5dfdf
	data4	0x8f038c8c, 0xf859a1a1, 0x80098989, 0x171a0d0d
	data4	0xda65bfbf, 0x31d7e6e6, 0xc6844242, 0xb8d06868
	data4	0xc3824141, 0xb0299999, 0x775a2d2d, 0x111e0f0f
	data4	0xcb7bb0b0, 0xfca85454, 0xd66dbbbb, 0x3a2c1616
// Te2:
	data4	0x63a5c663, 0x7c84f87c, 0x7799ee77, 0x7b8df67b
	data4	0xf20dfff2, 0x6bbdd66b, 0x6fb1de6f, 0xc55491c5
	data4	0x30506030, 0x01030201, 0x67a9ce67, 0x2b7d562b
	data4	0xfe19e7fe, 0xd762b5d7, 0xabe64dab, 0x769aec76
	data4	0xca458fca, 0x829d1f82, 0xc94089c9, 0x7d87fa7d
	data4	0xfa15effa, 0x59ebb259, 0x47c98e47, 0xf00bfbf0
	data4	0xadec41ad, 0xd467b3d4, 0xa2fd5fa2, 0xafea45af
	data4	0x9cbf239c, 0xa4f753a4, 0x7296e472, 0xc05b9bc0
	data4	0xb7c275b7, 0xfd1ce1fd, 0x93ae3d93, 0x266a4c26
	data4	0x365a6c36, 0x3f417e3f, 0xf702f5f7, 0xcc4f83cc
	data4	0x345c6834, 0xa5f451a5, 0xe534d1e5, 0xf108f9f1
	data4	0x7193e271, 0xd873abd8, 0x31536231, 0x153f2a15
	data4	0x040c0804, 0xc75295c7, 0x23654623, 0xc35e9dc3
	data4	0x18283018, 0x96a13796, 0x050f0a05, 0x9ab52f9a
	data4	0x07090e07, 0x12362412, 0x809b1b80, 0xe23ddfe2
	data4	0xeb26cdeb, 0x27694e27, 0xb2cd7fb2, 0x759fea75
	data4	0x091b1209, 0x839e1d83, 0x2c74582c, 0x1a2e341a
	data4	0x1b2d361b, 0x6eb2dc6e, 0x5aeeb45a, 0xa0fb5ba0
	data4	0x52f6a452, 0x3b4d763b, 0xd661b7d6, 0xb3ce7db3
	data4	0x297b5229, 0xe33edde3, 0x2f715e2f, 0x84971384
	data4	0x53f5a653, 0xd168b9d1, 0x00000000, 0xed2cc1ed
	data4	0x20604020, 0xfc1fe3fc, 0xb1c879b1, 0x5bedb65b
	data4	0x6abed46a, 0xcb468dcb, 0xbed967be, 0x394b7239
	data4	0x4ade944a, 0x4cd4984c, 0x58e8b058, 0xcf4a85cf
	data4	0xd06bbbd0, 0xef2ac5ef, 0xaae54faa, 0xfb16edfb
	data4	0x43c58643, 0x4dd79a4d, 0x33556633, 0x85941185
	data4	0x45cf8a45, 0xf910e9f9, 0x02060402, 0x7f81fe7f
	data4	0x50f0a050, 0x3c44783c, 0x9fba259f, 0xa8e34ba8
	data4	0x51f3a251, 0xa3fe5da3, 0x40c08040, 0x8f8a058f
	data4	0x92ad3f92, 0x9dbc219d, 0x38487038, 0xf504f1f5
	data4	0xbcdf63bc, 0xb6c177b6, 0xda75afda, 0x21634221
	data4	0x10302010, 0xff1ae5ff, 0xf30efdf3, 0xd26dbfd2
	data4	0xcd4c81cd, 0x0c14180c, 0x13352613, 0xec2fc3ec
	data4	0x5fe1be5f, 0x97a23597, 0x44cc8844, 0x17392e17
	data4	0xc45793c4, 0xa7f255a7, 0x7e82fc7e, 0x3d477a3d
	data4	0x64acc864, 0x5de7ba5d, 0x192b3219, 0x7395e673
	data4	0x60a0c060, 0x81981981, 0x4fd19e4f, 0xdc7fa3dc
	data4	0x22664422, 0x2a7e542a, 0x90ab3b90, 0x88830b88
	data4	0x46ca8c46, 0xee29c7ee, 0xb8d36bb8, 0x143c2814
	data4	0xde79a7de, 0x5ee2bc5e, 0x0b1d160b, 0xdb76addb
	data4	0xe03bdbe0, 0x32566432, 0x3a4e743a, 0x0a1e140a
	data4	0x49db9249, 0x060a0c06, 0x246c4824, 0x5ce4b85c
	data4	0xc25d9fc2, 0xd36ebdd3, 0xacef43ac, 0x62a6c462
	data4	0x91a83991, 0x95a43195, 0xe437d3e4, 0x798bf279
	data4	0xe732d5e7, 0xc8438bc8, 0x37596e37, 0x6db7da6d
	data4	0x8d8c018d, 0xd564b1d5, 0x4ed29c4e, 0xa9e049a9
	data4	0x6cb4d86c, 0x56faac56, 0xf407f3f4, 0xea25cfea
	data4	0x65afca65, 0x7a8ef47a, 0xaee947ae, 0x08181008
	data4	0xbad56fba, 0x7888f078, 0x256f4a25, 0x2e725c2e
	data4	0x1c24381c, 0xa6f157a6, 0xb4c773b4, 0xc65197c6
	data4	0xe823cbe8, 0xdd7ca1dd, 0x749ce874, 0x1f213e1f
	data4	0x4bdd964b, 0xbddc61bd, 0x8b860d8b, 0x8a850f8a
	data4	0x7090e070, 0x3e427c3e, 0xb5c471b5, 0x66aacc66
	data4	0x48d89048, 0x03050603, 0xf601f7f6, 0x0e121c0e
	data4	0x61a3c261, 0x355f6a35, 0x57f9ae57, 0xb9d069b9
	data4	0x86911786, 0xc15899c1, 0x1d273a1d, 0x9eb9279e
	data4	0xe138d9e1, 0xf813ebf8, 0x98b32b98, 0x11332211
	data4	0x69bbd269, 0xd970a9d9, 0x8e89078e, 0x94a73394
	data4	0x9bb62d9b, 0x1e223c1e, 0x87921587, 0xe920c9e9
	data4	0xce4987ce, 0x55ffaa55, 0x28785028, 0xdf7aa5df
	data4	0x8c8f038c, 0xa1f859a1, 0x89800989, 0x0d171a0d
	data4	0xbfda65bf, 0xe631d7e6, 0x42c68442, 0x68b8d068
	data4	0x41c38241, 0x99b02999, 0x2d775a2d, 0x0f111e0f
	data4	0xb0cb7bb0, 0x54fca854, 0xbbd66dbb, 0x163a2c16
// Te3:
	data4	0x6363a5c6, 0x7c7c84f8, 0x777799ee, 0x7b7b8df6
	data4	0xf2f20dff, 0x6b6bbdd6, 0x6f6fb1de, 0xc5c55491
	data4	0x30305060, 0x01010302, 0x6767a9ce, 0x2b2b7d56
	data4	0xfefe19e7, 0xd7d762b5, 0xababe64d, 0x76769aec
	data4	0xcaca458f, 0x82829d1f, 0xc9c94089, 0x7d7d87fa
	data4	0xfafa15ef, 0x5959ebb2, 0x4747c98e, 0xf0f00bfb
	data4	0xadadec41, 0xd4d467b3, 0xa2a2fd5f, 0xafafea45
	data4	0x9c9cbf23, 0xa4a4f753, 0x727296e4, 0xc0c05b9b
	data4	0xb7b7c275, 0xfdfd1ce1, 0x9393ae3d, 0x26266a4c
	data4	0x36365a6c, 0x3f3f417e, 0xf7f702f5, 0xcccc4f83
	data4	0x34345c68, 0xa5a5f451, 0xe5e534d1, 0xf1f108f9
	data4	0x717193e2, 0xd8d873ab, 0x31315362, 0x15153f2a
	data4	0x04040c08, 0xc7c75295, 0x23236546, 0xc3c35e9d
	data4	0x18182830, 0x9696a137, 0x05050f0a, 0x9a9ab52f
	data4	0x0707090e, 0x12123624, 0x80809b1b, 0xe2e23ddf
	data4	0xebeb26cd, 0x2727694e, 0xb2b2cd7f, 0x75759fea
	data4	0x09091b12, 0x83839e1d, 0x2c2c7458, 0x1a1a2e34
	data4	0x1b1b2d36, 0x6e6eb2dc, 0x5a5aeeb4, 0xa0a0fb5b
	data4	0x5252f6a4, 0x3b3b4d76, 0xd6d661b7, 0xb3b3ce7d
	data4	0x29297b52, 0xe3e33edd, 0x2f2f715e, 0x84849713
	data4	0x5353f5a6, 0xd1d168b9, 0x00000000, 0xeded2cc1
	data4	0x20206040, 0xfcfc1fe3, 0xb1b1c879, 0x5b5bedb6
	data4	0x6a6abed4, 0xcbcb468d, 0xbebed967, 0x39394b72
	data4	0x4a4ade94, 0x4c4cd498, 0x5858e8b0, 0xcfcf4a85
	data4	0xd0d06bbb, 0xefef2ac5, 0xaaaae54f, 0xfbfb16ed
	data4	0x4343c586, 0x4d4dd79a, 0x33335566, 0x85859411
	data4	0x4545cf8a, 0xf9f910e9, 0x02020604, 0x7f7f81fe
	data4	0x5050f0a0, 0x3c3c4478, 0x9f9fba25, 0xa8a8e34b
	data4	0x5151f3a2, 0xa3a3fe5d, 0x4040c080, 0x8f8f8a05
	data4	0x9292ad3f, 0x9d9dbc21, 0x38384870, 0xf5f504f1
	data4	0xbcbcdf63, 0xb6b6c177, 0xdada75af, 0x21216342
	data4	0x10103020, 0xffff1ae5, 0xf3f30efd, 0xd2d26dbf
	data4	0xcdcd4c81, 0x0c0c1418, 0x13133526, 0xecec2fc3
	data4	0x5f5fe1be, 0x9797a235, 0x4444cc88, 0x1717392e
	data4	0xc4c45793, 0xa7a7f255, 0x7e7e82fc, 0x3d3d477a
	data4	0x6464acc8, 0x5d5de7ba, 0x19192b32, 0x737395e6
	data4	0x6060a0c0, 0x81819819, 0x4f4fd19e, 0xdcdc7fa3
	data4	0x22226644, 0x2a2a7e54, 0x9090ab3b, 0x8888830b
	data4	0x4646ca8c, 0xeeee29c7, 0xb8b8d36b, 0x14143c28
	data4	0xdede79a7, 0x5e5ee2bc, 0x0b0b1d16, 0xdbdb76ad
	data4	0xe0e03bdb, 0x32325664, 0x3a3a4e74, 0x0a0a1e14
	data4	0x4949db92, 0x06060a0c, 0x24246c48, 0x5c5ce4b8
	data4	0xc2c25d9f, 0xd3d36ebd, 0xacacef43, 0x6262a6c4
	data4	0x9191a839, 0x9595a431, 0xe4e437d3, 0x79798bf2
	data4	0xe7e732d5, 0xc8c8438b, 0x3737596e, 0x6d6db7da
	data4	0x8d8d8c01, 0xd5d564b1, 0x4e4ed29c, 0xa9a9e049
	data4	0x6c6cb4d8, 0x5656faac, 0xf4f407f3, 0xeaea25cf
	data4	0x6565afca, 0x7a7a8ef4, 0xaeaee947, 0x08081810
	data4	0xbabad56f, 0x787888f0, 0x25256f4a, 0x2e2e725c
	data4	0x1c1c2438, 0xa6a6f157, 0xb4b4c773, 0xc6c65197
	data4	0xe8e823cb, 0xdddd7ca1, 0x74749ce8, 0x1f1f213e
	data4	0x4b4bdd96, 0xbdbddc61, 0x8b8b860d, 0x8a8a850f
	data4	0x707090e0, 0x3e3e427c, 0xb5b5c471, 0x6666aacc
	data4	0x4848d890, 0x03030506, 0xf6f601f7, 0x0e0e121c
	data4	0x6161a3c2, 0x35355f6a, 0x5757f9ae, 0xb9b9d069
	data4	0x86869117, 0xc1c15899, 0x1d1d273a, 0x9e9eb927
	data4	0xe1e138d9, 0xf8f813eb, 0x9898b32b, 0x11113322
	data4	0x6969bbd2, 0xd9d970a9, 0x8e8e8907, 0x9494a733
	data4	0x9b9bb62d, 0x1e1e223c, 0x87879215, 0xe9e920c9
	data4	0xcece4987, 0x5555ffaa, 0x28287850, 0xdfdf7aa5
	data4	0x8c8c8f03, 0xa1a1f859, 0x89898009, 0x0d0d171a
	data4	0xbfbfda65, 0xe6e631d7, 0x4242c684, 0x6868b8d0
	data4	0x4141c382, 0x9999b029, 0x2d2d775a, 0x0f0f111e
	data4	0xb0b0cb7b, 0x5454fca8, 0xbbbbd66d, 0x16163a2c
// Te4:
	data4	0x63000000, 0x7c000000, 0x77000000, 0x7b000000
	data4	0xf2000000, 0x6b000000, 0x6f000000, 0xc5000000
	data4	0x30000000, 0x01000000, 0x67000000, 0x2b000000
	data4	0xfe000000, 0xd7000000, 0xab000000, 0x76000000
	data4	0xca000000, 0x82000000, 0xc9000000, 0x7d000000
	data4	0xfa000000, 0x59000000, 0x47000000, 0xf0000000
	data4	0xad000000, 0xd4000000, 0xa2000000, 0xaf000000
	data4	0x9c000000, 0xa4000000, 0x72000000, 0xc0000000
	data4	0xb7000000, 0xfd000000, 0x93000000, 0x26000000
	data4	0x36000000, 0x3f000000, 0xf7000000, 0xcc000000
	data4	0x34000000, 0xa5000000, 0xe5000000, 0xf1000000
	data4	0x71000000, 0xd8000000, 0x31000000, 0x15000000
	data4	0x04000000, 0xc7000000, 0x23000000, 0xc3000000
	data4	0x18000000, 0x96000000, 0x05000000, 0x9a000000
	data4	0x07000000, 0x12000000, 0x80000000, 0xe2000000
	data4	0xeb000000, 0x27000000, 0xb2000000, 0x75000000
	data4	0x09000000, 0x83000000, 0x2c000000, 0x1a000000
	data4	0x1b000000, 0x6e000000, 0x5a000000, 0xa0000000
	data4	0x52000000, 0x3b000000, 0xd6000000, 0xb3000000
	data4	0x29000000, 0xe3000000, 0x2f000000, 0x84000000
	data4	0x53000000, 0xd1000000, 0x00000000, 0xed000000
	data4	0x20000000, 0xfc000000, 0xb1000000, 0x5b000000
	data4	0x6a000000, 0xcb000000, 0xbe000000, 0x39000000
	data4	0x4a000000, 0x4c000000, 0x58000000, 0xcf000000
	data4	0xd0000000, 0xef000000, 0xaa000000, 0xfb000000
	data4	0x43000000, 0x4d000000, 0x33000000, 0x85000000
	data4	0x45000000, 0xf9000000, 0x02000000, 0x7f000000
	data4	0x50000000, 0x3c000000, 0x9f000000, 0xa8000000
	data4	0x51000000, 0xa3000000, 0x40000000, 0x8f000000
	data4	0x92000000, 0x9d000000, 0x38000000, 0xf5000000
	data4	0xbc000000, 0xb6000000, 0xda000000, 0x21000000
	data4	0x10000000, 0xff000000, 0xf3000000, 0xd2000000
	data4	0xcd000000, 0x0c000000, 0x13000000, 0xec000000
	data4	0x5f000000, 0x97000000, 0x44000000, 0x17000000
	data4	0xc4000000, 0xa7000000, 0x7e000000, 0x3d000000
	data4	0x64000000, 0x5d000000, 0x19000000, 0x73000000
	data4	0x60000000, 0x81000000, 0x4f000000, 0xdc000000
	data4	0x22000000, 0x2a000000, 0x90000000, 0x88000000
	data4	0x46000000, 0xee000000, 0xb8000000, 0x14000000
	data4	0xde000000, 0x5e000000, 0x0b000000, 0xdb000000
	data4	0xe0000000, 0x32000000, 0x3a000000, 0x0a000000
	data4	0x49000000, 0x06000000, 0x24000000, 0x5c000000
	data4	0xc2000000, 0xd3000000, 0xac000000, 0x62000000
	data4	0x91000000, 0x95000000, 0xe4000000, 0x79000000
	data4	0xe7000000, 0xc8000000, 0x37000000, 0x6d000000
	data4	0x8d000000, 0xd5000000, 0x4e000000, 0xa9000000
	data4	0x6c000000, 0x56000000, 0xf4000000, 0xea000000
	data4	0x65000000, 0x7a000000, 0xae000000, 0x08000000
	data4	0xba000000, 0x78000000, 0x25000000, 0x2e000000
	data4	0x1c000000, 0xa6000000, 0xb4000000, 0xc6000000
	data4	0xe8000000, 0xdd000000, 0x74000000, 0x1f000000
	data4	0x4b000000, 0xbd000000, 0x8b000000, 0x8a000000
	data4	0x70000000, 0x3e000000, 0xb5000000, 0x66000000
	data4	0x48000000, 0x03000000, 0xf6000000, 0x0e000000
	data4	0x61000000, 0x35000000, 0x57000000, 0xb9000000
	data4	0x86000000, 0xc1000000, 0x1d000000, 0x9e000000
	data4	0xe1000000, 0xf8000000, 0x98000000, 0x11000000
	data4	0x69000000, 0xd9000000, 0x8e000000, 0x94000000
	data4	0x9b000000, 0x1e000000, 0x87000000, 0xe9000000
	data4	0xce000000, 0x55000000, 0x28000000, 0xdf000000
	data4	0x8c000000, 0xa1000000, 0x89000000, 0x0d000000
	data4	0xbf000000, 0xe6000000, 0x42000000, 0x68000000
	data4	0x41000000, 0x99000000, 0x2d000000, 0x0f000000
	data4	0xb0000000, 0x54000000, 0xbb000000, 0x16000000
// Te5:
	data4	0x00630000, 0x007c0000, 0x00770000, 0x007b0000
	data4	0x00f20000, 0x006b0000, 0x006f0000, 0x00c50000
	data4	0x00300000, 0x00010000, 0x00670000, 0x002b0000
	data4	0x00fe0000, 0x00d70000, 0x00ab0000, 0x00760000
	data4	0x00ca0000, 0x00820000, 0x00c90000, 0x007d0000
	data4	0x00fa0000, 0x00590000, 0x00470000, 0x00f00000
	data4	0x00ad0000, 0x00d40000, 0x00a20000, 0x00af0000
	data4	0x009c0000, 0x00a40000, 0x00720000, 0x00c00000
	data4	0x00b70000, 0x00fd0000, 0x00930000, 0x00260000
	data4	0x00360000, 0x003f0000, 0x00f70000, 0x00cc0000
	data4	0x00340000, 0x00a50000, 0x00e50000, 0x00f10000
	data4	0x00710000, 0x00d80000, 0x00310000, 0x00150000
	data4	0x00040000, 0x00c70000, 0x00230000, 0x00c30000
	data4	0x00180000, 0x00960000, 0x00050000, 0x009a0000
	data4	0x00070000, 0x00120000, 0x00800000, 0x00e20000
	data4	0x00eb0000, 0x00270000, 0x00b20000, 0x00750000
	data4	0x00090000, 0x00830000, 0x002c0000, 0x001a0000
	data4	0x001b0000, 0x006e0000, 0x005a0000, 0x00a00000
	data4	0x00520000, 0x003b0000, 0x00d60000, 0x00b30000
	data4	0x00290000, 0x00e30000, 0x002f0000, 0x00840000
	data4	0x00530000, 0x00d10000, 0x00000000, 0x00ed0000
	data4	0x00200000, 0x00fc0000, 0x00b10000, 0x005b0000
	data4	0x006a0000, 0x00cb0000, 0x00be0000, 0x00390000
	data4	0x004a0000, 0x004c0000, 0x00580000, 0x00cf0000
	data4	0x00d00000, 0x00ef0000, 0x00aa0000, 0x00fb0000
	data4	0x00430000, 0x004d0000, 0x00330000, 0x00850000
	data4	0x00450000, 0x00f90000, 0x00020000, 0x007f0000
	data4	0x00500000, 0x003c0000, 0x009f0000, 0x00a80000
	data4	0x00510000, 0x00a30000, 0x00400000, 0x008f0000
	data4	0x00920000, 0x009d0000, 0x00380000, 0x00f50000
	data4	0x00bc0000, 0x00b60000, 0x00da0000, 0x00210000
	data4	0x00100000, 0x00ff0000, 0x00f30000, 0x00d20000
	data4	0x00cd0000, 0x000c0000, 0x00130000, 0x00ec0000
	data4	0x005f0000, 0x00970000, 0x00440000, 0x00170000
	data4	0x00c40000, 0x00a70000, 0x007e0000, 0x003d0000
	data4	0x00640000, 0x005d0000, 0x00190000, 0x00730000
	data4	0x00600000, 0x00810000, 0x004f0000, 0x00dc0000
	data4	0x00220000, 0x002a0000, 0x00900000, 0x00880000
	data4	0x00460000, 0x00ee0000, 0x00b80000, 0x00140000
	data4	0x00de0000, 0x005e0000, 0x000b0000, 0x00db0000
	data4	0x00e00000, 0x00320000, 0x003a0000, 0x000a0000
	data4	0x00490000, 0x00060000, 0x00240000, 0x005c0000
	data4	0x00c20000, 0x00d30000, 0x00ac0000, 0x00620000
	data4	0x00910000, 0x00950000, 0x00e40000, 0x00790000
	data4	0x00e70000, 0x00c80000, 0x00370000, 0x006d0000
	data4	0x008d0000, 0x00d50000, 0x004e0000, 0x00a90000
	data4	0x006c0000, 0x00560000, 0x00f40000, 0x00ea0000
	data4	0x00650000, 0x007a0000, 0x00ae0000, 0x00080000
	data4	0x00ba0000, 0x00780000, 0x00250000, 0x002e0000
	data4	0x001c0000, 0x00a60000, 0x00b40000, 0x00c60000
	data4	0x00e80000, 0x00dd0000, 0x00740000, 0x001f0000
	data4	0x004b0000, 0x00bd0000, 0x008b0000, 0x008a0000
	data4	0x00700000, 0x003e0000, 0x00b50000, 0x00660000
	data4	0x00480000, 0x00030000, 0x00f60000, 0x000e0000
	data4	0x00610000, 0x00350000, 0x00570000, 0x00b90000
	data4	0x00860000, 0x00c10000, 0x001d0000, 0x009e0000
	data4	0x00e10000, 0x00f80000, 0x00980000, 0x00110000
	data4	0x00690000, 0x00d90000, 0x008e0000, 0x00940000
	data4	0x009b0000, 0x001e0000, 0x00870000, 0x00e90000
	data4	0x00ce0000, 0x00550000, 0x00280000, 0x00df0000
	data4	0x008c0000, 0x00a10000, 0x00890000, 0x000d0000
	data4	0x00bf0000, 0x00e60000, 0x00420000, 0x00680000
	data4	0x00410000, 0x00990000, 0x002d0000, 0x000f0000
	data4	0x00b00000, 0x00540000, 0x00bb0000, 0x00160000
// Te6:
	data4	0x00006300, 0x00007c00, 0x00007700, 0x00007b00
	data4	0x0000f200, 0x00006b00, 0x00006f00, 0x0000c500
	data4	0x00003000, 0x00000100, 0x00006700, 0x00002b00
	data4	0x0000fe00, 0x0000d700, 0x0000ab00, 0x00007600
	data4	0x0000ca00, 0x00008200, 0x0000c900, 0x00007d00
	data4	0x0000fa00, 0x00005900, 0x00004700, 0x0000f000
	data4	0x0000ad00, 0x0000d400, 0x0000a200, 0x0000af00
	data4	0x00009c00, 0x0000a400, 0x00007200, 0x0000c000
	data4	0x0000b700, 0x0000fd00, 0x00009300, 0x00002600
	data4	0x00003600, 0x00003f00, 0x0000f700, 0x0000cc00
	data4	0x00003400, 0x0000a500, 0x0000e500, 0x0000f100
	data4	0x00007100, 0x0000d800, 0x00003100, 0x00001500
	data4	0x00000400, 0x0000c700, 0x00002300, 0x0000c300
	data4	0x00001800, 0x00009600, 0x00000500, 0x00009a00
	data4	0x00000700, 0x00001200, 0x00008000, 0x0000e200
	data4	0x0000eb00, 0x00002700, 0x0000b200, 0x00007500
	data4	0x00000900, 0x00008300, 0x00002c00, 0x00001a00
	data4	0x00001b00, 0x00006e00, 0x00005a00, 0x0000a000
	data4	0x00005200, 0x00003b00, 0x0000d600, 0x0000b300
	data4	0x00002900, 0x0000e300, 0x00002f00, 0x00008400
	data4	0x00005300, 0x0000d100, 0x00000000, 0x0000ed00
	data4	0x00002000, 0x0000fc00, 0x0000b100, 0x00005b00
	data4	0x00006a00, 0x0000cb00, 0x0000be00, 0x00003900
	data4	0x00004a00, 0x00004c00, 0x00005800, 0x0000cf00
	data4	0x0000d000, 0x0000ef00, 0x0000aa00, 0x0000fb00
	data4	0x00004300, 0x00004d00, 0x00003300, 0x00008500
	data4	0x00004500, 0x0000f900, 0x00000200, 0x00007f00
	data4	0x00005000, 0x00003c00, 0x00009f00, 0x0000a800
	data4	0x00005100, 0x0000a300, 0x00004000, 0x00008f00
	data4	0x00009200, 0x00009d00, 0x00003800, 0x0000f500
	data4	0x0000bc00, 0x0000b600, 0x0000da00, 0x00002100
	data4	0x00001000, 0x0000ff00, 0x0000f300, 0x0000d200
	data4	0x0000cd00, 0x00000c00, 0x00001300, 0x0000ec00
	data4	0x00005f00, 0x00009700, 0x00004400, 0x00001700
	data4	0x0000c400, 0x0000a700, 0x00007e00, 0x00003d00
	data4	0x00006400, 0x00005d00, 0x00001900, 0x00007300
	data4	0x00006000, 0x00008100, 0x00004f00, 0x0000dc00
	data4	0x00002200, 0x00002a00, 0x00009000, 0x00008800
	data4	0x00004600, 0x0000ee00, 0x0000b800, 0x00001400
	data4	0x0000de00, 0x00005e00, 0x00000b00, 0x0000db00
	data4	0x0000e000, 0x00003200, 0x00003a00, 0x00000a00
	data4	0x00004900, 0x00000600, 0x00002400, 0x00005c00
	data4	0x0000c200, 0x0000d300, 0x0000ac00, 0x00006200
	data4	0x00009100, 0x00009500, 0x0000e400, 0x00007900
	data4	0x0000e700, 0x0000c800, 0x00003700, 0x00006d00
	data4	0x00008d00, 0x0000d500, 0x00004e00, 0x0000a900
	data4	0x00006c00, 0x00005600, 0x0000f400, 0x0000ea00
	data4	0x00006500, 0x00007a00, 0x0000ae00, 0x00000800
	data4	0x0000ba00, 0x00007800, 0x00002500, 0x00002e00
	data4	0x00001c00, 0x0000a600, 0x0000b400, 0x0000c600
	data4	0x0000e800, 0x0000dd00, 0x00007400, 0x00001f00
	data4	0x00004b00, 0x0000bd00, 0x00008b00, 0x00008a00
	data4	0x00007000, 0x00003e00, 0x0000b500, 0x00006600
	data4	0x00004800, 0x00000300, 0x0000f600, 0x00000e00
	data4	0x00006100, 0x00003500, 0x00005700, 0x0000b900
	data4	0x00008600, 0x0000c100, 0x00001d00, 0x00009e00
	data4	0x0000e100, 0x0000f800, 0x00009800, 0x00001100
	data4	0x00006900, 0x0000d900, 0x00008e00, 0x00009400
	data4	0x00009b00, 0x00001e00, 0x00008700, 0x0000e900
	data4	0x0000ce00, 0x00005500, 0x00002800, 0x0000df00
	data4	0x00008c00, 0x0000a100, 0x00008900, 0x00000d00
	data4	0x0000bf00, 0x0000e600, 0x00004200, 0x00006800
	data4	0x00004100, 0x00009900, 0x00002d00, 0x00000f00
	data4	0x0000b000, 0x00005400, 0x0000bb00, 0x00001600
// Te7:
	data4	0x00000063, 0x0000007c, 0x00000077, 0x0000007b
	data4	0x000000f2, 0x0000006b, 0x0000006f, 0x000000c5
	data4	0x00000030, 0x00000001, 0x00000067, 0x0000002b
	data4	0x000000fe, 0x000000d7, 0x000000ab, 0x00000076
	data4	0x000000ca, 0x00000082, 0x000000c9, 0x0000007d
	data4	0x000000fa, 0x00000059, 0x00000047, 0x000000f0
	data4	0x000000ad, 0x000000d4, 0x000000a2, 0x000000af
	data4	0x0000009c, 0x000000a4, 0x00000072, 0x000000c0
	data4	0x000000b7, 0x000000fd, 0x00000093, 0x00000026
	data4	0x00000036, 0x0000003f, 0x000000f7, 0x000000cc
	data4	0x00000034, 0x000000a5, 0x000000e5, 0x000000f1
	data4	0x00000071, 0x000000d8, 0x00000031, 0x00000015
	data4	0x00000004, 0x000000c7, 0x00000023, 0x000000c3
	data4	0x00000018, 0x00000096, 0x00000005, 0x0000009a
	data4	0x00000007, 0x00000012, 0x00000080, 0x000000e2
	data4	0x000000eb, 0x00000027, 0x000000b2, 0x00000075
	data4	0x00000009, 0x00000083, 0x0000002c, 0x0000001a
	data4	0x0000001b, 0x0000006e, 0x0000005a, 0x000000a0
	data4	0x00000052, 0x0000003b, 0x000000d6, 0x000000b3
	data4	0x00000029, 0x000000e3, 0x0000002f, 0x00000084
	data4	0x00000053, 0x000000d1, 0x00000000, 0x000000ed
	data4	0x00000020, 0x000000fc, 0x000000b1, 0x0000005b
	data4	0x0000006a, 0x000000cb, 0x000000be, 0x00000039
	data4	0x0000004a, 0x0000004c, 0x00000058, 0x000000cf
	data4	0x000000d0, 0x000000ef, 0x000000aa, 0x000000fb
	data4	0x00000043, 0x0000004d, 0x00000033, 0x00000085
	data4	0x00000045, 0x000000f9, 0x00000002, 0x0000007f
	data4	0x00000050, 0x0000003c, 0x0000009f, 0x000000a8
	data4	0x00000051, 0x000000a3, 0x00000040, 0x0000008f
	data4	0x00000092, 0x0000009d, 0x00000038, 0x000000f5
	data4	0x000000bc, 0x000000b6, 0x000000da, 0x00000021
	data4	0x00000010, 0x000000ff, 0x000000f3, 0x000000d2
	data4	0x000000cd, 0x0000000c, 0x00000013, 0x000000ec
	data4	0x0000005f, 0x00000097, 0x00000044, 0x00000017
	data4	0x000000c4, 0x000000a7, 0x0000007e, 0x0000003d
	data4	0x00000064, 0x0000005d, 0x00000019, 0x00000073
	data4	0x00000060, 0x00000081, 0x0000004f, 0x000000dc
	data4	0x00000022, 0x0000002a, 0x00000090, 0x00000088
	data4	0x00000046, 0x000000ee, 0x000000b8, 0x00000014
	data4	0x000000de, 0x0000005e, 0x0000000b, 0x000000db
	data4	0x000000e0, 0x00000032, 0x0000003a, 0x0000000a
	data4	0x00000049, 0x00000006, 0x00000024, 0x0000005c
	data4	0x000000c2, 0x000000d3, 0x000000ac, 0x00000062
	data4	0x00000091, 0x00000095, 0x000000e4, 0x00000079
	data4	0x000000e7, 0x000000c8, 0x00000037, 0x0000006d
	data4	0x0000008d, 0x000000d5, 0x0000004e, 0x000000a9
	data4	0x0000006c, 0x00000056, 0x000000f4, 0x000000ea
	data4	0x00000065, 0x0000007a, 0x000000ae, 0x00000008
	data4	0x000000ba, 0x00000078, 0x00000025, 0x0000002e
	data4	0x0000001c, 0x000000a6, 0x000000b4, 0x000000c6
	data4	0x000000e8, 0x000000dd, 0x00000074, 0x0000001f
	data4	0x0000004b, 0x000000bd, 0x0000008b, 0x0000008a
	data4	0x00000070, 0x0000003e, 0x000000b5, 0x00000066
	data4	0x00000048, 0x00000003, 0x000000f6, 0x0000000e
	data4	0x00000061, 0x00000035, 0x00000057, 0x000000b9
	data4	0x00000086, 0x000000c1, 0x0000001d, 0x0000009e
	data4	0x000000e1, 0x000000f8, 0x00000098, 0x00000011
	data4	0x00000069, 0x000000d9, 0x0000008e, 0x00000094
	data4	0x0000009b, 0x0000001e, 0x00000087, 0x000000e9
	data4	0x000000ce, 0x00000055, 0x00000028, 0x000000df
	data4	0x0000008c, 0x000000a1, 0x00000089, 0x0000000d
	data4	0x000000bf, 0x000000e6, 0x00000042, 0x00000068
	data4	0x00000041, 0x00000099, 0x0000002d, 0x0000000f
	data4	0x000000b0, 0x00000054, 0x000000bb, 0x00000016
.size	AES_Te#,8*256*4	// HP-UX assembler fails to ".-AES_Te#"

.align	64
.global	AES_Td#
.type	AES_Td#,@object
AES_Td:	data4	0x51f4a750, 0x7e416553, 0x1a17a4c3, 0x3a275e96
	data4	0x3bab6bcb, 0x1f9d45f1, 0xacfa58ab, 0x4be30393
	data4	0x2030fa55, 0xad766df6, 0x88cc7691, 0xf5024c25
	data4	0x4fe5d7fc, 0xc52acbd7, 0x26354480, 0xb562a38f
	data4	0xdeb15a49, 0x25ba1b67, 0x45ea0e98, 0x5dfec0e1
	data4	0xc32f7502, 0x814cf012, 0x8d4697a3, 0x6bd3f9c6
	data4	0x038f5fe7, 0x15929c95, 0xbf6d7aeb, 0x955259da
	data4	0xd4be832d, 0x587421d3, 0x49e06929, 0x8ec9c844
	data4	0x75c2896a, 0xf48e7978, 0x99583e6b, 0x27b971dd
	data4	0xbee14fb6, 0xf088ad17, 0xc920ac66, 0x7dce3ab4
	data4	0x63df4a18, 0xe51a3182, 0x97513360, 0x62537f45
	data4	0xb16477e0, 0xbb6bae84, 0xfe81a01c, 0xf9082b94
	data4	0x70486858, 0x8f45fd19, 0x94de6c87, 0x527bf8b7
	data4	0xab73d323, 0x724b02e2, 0xe31f8f57, 0x6655ab2a
	data4	0xb2eb2807, 0x2fb5c203, 0x86c57b9a, 0xd33708a5
	data4	0x302887f2, 0x23bfa5b2, 0x02036aba, 0xed16825c
	data4	0x8acf1c2b, 0xa779b492, 0xf307f2f0, 0x4e69e2a1
	data4	0x65daf4cd, 0x0605bed5, 0xd134621f, 0xc4a6fe8a
	data4	0x342e539d, 0xa2f355a0, 0x058ae132, 0xa4f6eb75
	data4	0x0b83ec39, 0x4060efaa, 0x5e719f06, 0xbd6e1051
	data4	0x3e218af9, 0x96dd063d, 0xdd3e05ae, 0x4de6bd46
	data4	0x91548db5, 0x71c45d05, 0x0406d46f, 0x605015ff
	data4	0x1998fb24, 0xd6bde997, 0x894043cc, 0x67d99e77
	data4	0xb0e842bd, 0x07898b88, 0xe7195b38, 0x79c8eedb
	data4	0xa17c0a47, 0x7c420fe9, 0xf8841ec9, 0x00000000
	data4	0x09808683, 0x322bed48, 0x1e1170ac, 0x6c5a724e
	data4	0xfd0efffb, 0x0f853856, 0x3daed51e, 0x362d3927
	data4	0x0a0fd964, 0x685ca621, 0x9b5b54d1, 0x24362e3a
	data4	0x0c0a67b1, 0x9357e70f, 0xb4ee96d2, 0x1b9b919e
	data4	0x80c0c54f, 0x61dc20a2, 0x5a774b69, 0x1c121a16
	data4	0xe293ba0a, 0xc0a02ae5, 0x3c22e043, 0x121b171d
	data4	0x0e090d0b, 0xf28bc7ad, 0x2db6a8b9, 0x141ea9c8
	data4	0x57f11985, 0xaf75074c, 0xee99ddbb, 0xa37f60fd
	data4	0xf701269f, 0x5c72f5bc, 0x44663bc5, 0x5bfb7e34
	data4	0x8b432976, 0xcb23c6dc, 0xb6edfc68, 0xb8e4f163
	data4	0xd731dcca, 0x42638510, 0x13972240, 0x84c61120
	data4	0x854a247d, 0xd2bb3df8, 0xaef93211, 0xc729a16d
	data4	0x1d9e2f4b, 0xdcb230f3, 0x0d8652ec, 0x77c1e3d0
	data4	0x2bb3166c, 0xa970b999, 0x119448fa, 0x47e96422
	data4	0xa8fc8cc4, 0xa0f03f1a, 0x567d2cd8, 0x223390ef
	data4	0x87494ec7, 0xd938d1c1, 0x8ccaa2fe, 0x98d40b36
	data4	0xa6f581cf, 0xa57ade28, 0xdab78e26, 0x3fadbfa4
	data4	0x2c3a9de4, 0x5078920d, 0x6a5fcc9b, 0x547e4662
	data4	0xf68d13c2, 0x90d8b8e8, 0x2e39f75e, 0x82c3aff5
	data4	0x9f5d80be, 0x69d0937c, 0x6fd52da9, 0xcf2512b3
	data4	0xc8ac993b, 0x10187da7, 0xe89c636e, 0xdb3bbb7b
	data4	0xcd267809, 0x6e5918f4, 0xec9ab701, 0x834f9aa8
	data4	0xe6956e65, 0xaaffe67e, 0x21bccf08, 0xef15e8e6
	data4	0xbae79bd9, 0x4a6f36ce, 0xea9f09d4, 0x29b07cd6
	data4	0x31a4b2af, 0x2a3f2331, 0xc6a59430, 0x35a266c0
	data4	0x744ebc37, 0xfc82caa6, 0xe090d0b0, 0x33a7d815
	data4	0xf104984a, 0x41ecdaf7, 0x7fcd500e, 0x1791f62f
	data4	0x764dd68d, 0x43efb04d, 0xccaa4d54, 0xe49604df
	data4	0x9ed1b5e3, 0x4c6a881b, 0xc12c1fb8, 0x4665517f
	data4	0x9d5eea04, 0x018c355d, 0xfa877473, 0xfb0b412e
	data4	0xb3671d5a, 0x92dbd252, 0xe9105633, 0x6dd64713
	data4	0x9ad7618c, 0x37a10c7a, 0x59f8148e, 0xeb133c89
	data4	0xcea927ee, 0xb761c935, 0xe11ce5ed, 0x7a47b13c
	data4	0x9cd2df59, 0x55f2733f, 0x1814ce79, 0x73c737bf
	data4	0x53f7cdea, 0x5ffdaa5b, 0xdf3d6f14, 0x7844db86
	data4	0xcaaff381, 0xb968c43e, 0x3824342c, 0xc2a3405f
	data4	0x161dc372, 0xbce2250c, 0x283c498b, 0xff0d9541
	data4	0x39a80171, 0x080cb3de, 0xd8b4e49c, 0x6456c190
	data4	0x7bcb8461, 0xd532b670, 0x486c5c74, 0xd0b85742
// Td1:
	data4	0x5051f4a7, 0x537e4165, 0xc31a17a4, 0x963a275e
	data4	0xcb3bab6b, 0xf11f9d45, 0xabacfa58, 0x934be303
	data4	0x552030fa, 0xf6ad766d, 0x9188cc76, 0x25f5024c
	data4	0xfc4fe5d7, 0xd7c52acb, 0x80263544, 0x8fb562a3
	data4	0x49deb15a, 0x6725ba1b, 0x9845ea0e, 0xe15dfec0
	data4	0x02c32f75, 0x12814cf0, 0xa38d4697, 0xc66bd3f9
	data4	0xe7038f5f, 0x9515929c, 0xebbf6d7a, 0xda955259
	data4	0x2dd4be83, 0xd3587421, 0x2949e069, 0x448ec9c8
	data4	0x6a75c289, 0x78f48e79, 0x6b99583e, 0xdd27b971
	data4	0xb6bee14f, 0x17f088ad, 0x66c920ac, 0xb47dce3a
	data4	0x1863df4a, 0x82e51a31, 0x60975133, 0x4562537f
	data4	0xe0b16477, 0x84bb6bae, 0x1cfe81a0, 0x94f9082b
	data4	0x58704868, 0x198f45fd, 0x8794de6c, 0xb7527bf8
	data4	0x23ab73d3, 0xe2724b02, 0x57e31f8f, 0x2a6655ab
	data4	0x07b2eb28, 0x032fb5c2, 0x9a86c57b, 0xa5d33708
	data4	0xf2302887, 0xb223bfa5, 0xba02036a, 0x5ced1682
	data4	0x2b8acf1c, 0x92a779b4, 0xf0f307f2, 0xa14e69e2
	data4	0xcd65daf4, 0xd50605be, 0x1fd13462, 0x8ac4a6fe
	data4	0x9d342e53, 0xa0a2f355, 0x32058ae1, 0x75a4f6eb
	data4	0x390b83ec, 0xaa4060ef, 0x065e719f, 0x51bd6e10
	data4	0xf93e218a, 0x3d96dd06, 0xaedd3e05, 0x464de6bd
	data4	0xb591548d, 0x0571c45d, 0x6f0406d4, 0xff605015
	data4	0x241998fb, 0x97d6bde9, 0xcc894043, 0x7767d99e
	data4	0xbdb0e842, 0x8807898b, 0x38e7195b, 0xdb79c8ee
	data4	0x47a17c0a, 0xe97c420f, 0xc9f8841e, 0x00000000
	data4	0x83098086, 0x48322bed, 0xac1e1170, 0x4e6c5a72
	data4	0xfbfd0eff, 0x560f8538, 0x1e3daed5, 0x27362d39
	data4	0x640a0fd9, 0x21685ca6, 0xd19b5b54, 0x3a24362e
	data4	0xb10c0a67, 0x0f9357e7, 0xd2b4ee96, 0x9e1b9b91
	data4	0x4f80c0c5, 0xa261dc20, 0x695a774b, 0x161c121a
	data4	0x0ae293ba, 0xe5c0a02a, 0x433c22e0, 0x1d121b17
	data4	0x0b0e090d, 0xadf28bc7, 0xb92db6a8, 0xc8141ea9
	data4	0x8557f119, 0x4caf7507, 0xbbee99dd, 0xfda37f60
	data4	0x9ff70126, 0xbc5c72f5, 0xc544663b, 0x345bfb7e
	data4	0x768b4329, 0xdccb23c6, 0x68b6edfc, 0x63b8e4f1
	data4	0xcad731dc, 0x10426385, 0x40139722, 0x2084c611
	data4	0x7d854a24, 0xf8d2bb3d, 0x11aef932, 0x6dc729a1
	data4	0x4b1d9e2f, 0xf3dcb230, 0xec0d8652, 0xd077c1e3
	data4	0x6c2bb316, 0x99a970b9, 0xfa119448, 0x2247e964
	data4	0xc4a8fc8c, 0x1aa0f03f, 0xd8567d2c, 0xef223390
	data4	0xc787494e, 0xc1d938d1, 0xfe8ccaa2, 0x3698d40b
	data4	0xcfa6f581, 0x28a57ade, 0x26dab78e, 0xa43fadbf
	data4	0xe42c3a9d, 0x0d507892, 0x9b6a5fcc, 0x62547e46
	data4	0xc2f68d13, 0xe890d8b8, 0x5e2e39f7, 0xf582c3af
	data4	0xbe9f5d80, 0x7c69d093, 0xa96fd52d, 0xb3cf2512
	data4	0x3bc8ac99, 0xa710187d, 0x6ee89c63, 0x7bdb3bbb
	data4	0x09cd2678, 0xf46e5918, 0x01ec9ab7, 0xa8834f9a
	data4	0x65e6956e, 0x7eaaffe6, 0x0821bccf, 0xe6ef15e8
	data4	0xd9bae79b, 0xce4a6f36, 0xd4ea9f09, 0xd629b07c
	data4	0xaf31a4b2, 0x312a3f23, 0x30c6a594, 0xc035a266
	data4	0x37744ebc, 0xa6fc82ca, 0xb0e090d0, 0x1533a7d8
	data4	0x4af10498, 0xf741ecda, 0x0e7fcd50, 0x2f1791f6
	data4	0x8d764dd6, 0x4d43efb0, 0x54ccaa4d, 0xdfe49604
	data4	0xe39ed1b5, 0x1b4c6a88, 0xb8c12c1f, 0x7f466551
	data4	0x049d5eea, 0x5d018c35, 0x73fa8774, 0x2efb0b41
	data4	0x5ab3671d, 0x5292dbd2, 0x33e91056, 0x136dd647
	data4	0x8c9ad761, 0x7a37a10c, 0x8e59f814, 0x89eb133c
	data4	0xeecea927, 0x35b761c9, 0xede11ce5, 0x3c7a47b1
	data4	0x599cd2df, 0x3f55f273, 0x791814ce, 0xbf73c737
	data4	0xea53f7cd, 0x5b5ffdaa, 0x14df3d6f, 0x867844db
	data4	0x81caaff3, 0x3eb968c4, 0x2c382434, 0x5fc2a340
	data4	0x72161dc3, 0x0cbce225, 0x8b283c49, 0x41ff0d95
	data4	0x7139a801, 0xde080cb3, 0x9cd8b4e4, 0x906456c1
	data4	0x617bcb84, 0x70d532b6, 0x74486c5c, 0x42d0b857
// Td2:
	data4	0xa75051f4, 0x65537e41, 0xa4c31a17, 0x5e963a27
	data4	0x6bcb3bab, 0x45f11f9d, 0x58abacfa, 0x03934be3
	data4	0xfa552030, 0x6df6ad76, 0x769188cc, 0x4c25f502
	data4	0xd7fc4fe5, 0xcbd7c52a, 0x44802635, 0xa38fb562
	data4	0x5a49deb1, 0x1b6725ba, 0x0e9845ea, 0xc0e15dfe
	data4	0x7502c32f, 0xf012814c, 0x97a38d46, 0xf9c66bd3
	data4	0x5fe7038f, 0x9c951592, 0x7aebbf6d, 0x59da9552
	data4	0x832dd4be, 0x21d35874, 0x692949e0, 0xc8448ec9
	data4	0x896a75c2, 0x7978f48e, 0x3e6b9958, 0x71dd27b9
	data4	0x4fb6bee1, 0xad17f088, 0xac66c920, 0x3ab47dce
	data4	0x4a1863df, 0x3182e51a, 0x33609751, 0x7f456253
	data4	0x77e0b164, 0xae84bb6b, 0xa01cfe81, 0x2b94f908
	data4	0x68587048, 0xfd198f45, 0x6c8794de, 0xf8b7527b
	data4	0xd323ab73, 0x02e2724b, 0x8f57e31f, 0xab2a6655
	data4	0x2807b2eb, 0xc2032fb5, 0x7b9a86c5, 0x08a5d337
	data4	0x87f23028, 0xa5b223bf, 0x6aba0203, 0x825ced16
	data4	0x1c2b8acf, 0xb492a779, 0xf2f0f307, 0xe2a14e69
	data4	0xf4cd65da, 0xbed50605, 0x621fd134, 0xfe8ac4a6
	data4	0x539d342e, 0x55a0a2f3, 0xe132058a, 0xeb75a4f6
	data4	0xec390b83, 0xefaa4060, 0x9f065e71, 0x1051bd6e
	data4	0x8af93e21, 0x063d96dd, 0x05aedd3e, 0xbd464de6
	data4	0x8db59154, 0x5d0571c4, 0xd46f0406, 0x15ff6050
	data4	0xfb241998, 0xe997d6bd, 0x43cc8940, 0x9e7767d9
	data4	0x42bdb0e8, 0x8b880789, 0x5b38e719, 0xeedb79c8
	data4	0x0a47a17c, 0x0fe97c42, 0x1ec9f884, 0x00000000
	data4	0x86830980, 0xed48322b, 0x70ac1e11, 0x724e6c5a
	data4	0xfffbfd0e, 0x38560f85, 0xd51e3dae, 0x3927362d
	data4	0xd9640a0f, 0xa621685c, 0x54d19b5b, 0x2e3a2436
	data4	0x67b10c0a, 0xe70f9357, 0x96d2b4ee, 0x919e1b9b
	data4	0xc54f80c0, 0x20a261dc, 0x4b695a77, 0x1a161c12
	data4	0xba0ae293, 0x2ae5c0a0, 0xe0433c22, 0x171d121b
	data4	0x0d0b0e09, 0xc7adf28b, 0xa8b92db6, 0xa9c8141e
	data4	0x198557f1, 0x074caf75, 0xddbbee99, 0x60fda37f
	data4	0x269ff701, 0xf5bc5c72, 0x3bc54466, 0x7e345bfb
	data4	0x29768b43, 0xc6dccb23, 0xfc68b6ed, 0xf163b8e4
	data4	0xdccad731, 0x85104263, 0x22401397, 0x112084c6
	data4	0x247d854a, 0x3df8d2bb, 0x3211aef9, 0xa16dc729
	data4	0x2f4b1d9e, 0x30f3dcb2, 0x52ec0d86, 0xe3d077c1
	data4	0x166c2bb3, 0xb999a970, 0x48fa1194, 0x642247e9
	data4	0x8cc4a8fc, 0x3f1aa0f0, 0x2cd8567d, 0x90ef2233
	data4	0x4ec78749, 0xd1c1d938, 0xa2fe8cca, 0x0b3698d4
	data4	0x81cfa6f5, 0xde28a57a, 0x8e26dab7, 0xbfa43fad
	data4	0x9de42c3a, 0x920d5078, 0xcc9b6a5f, 0x4662547e
	data4	0x13c2f68d, 0xb8e890d8, 0xf75e2e39, 0xaff582c3
	data4	0x80be9f5d, 0x937c69d0, 0x2da96fd5, 0x12b3cf25
	data4	0x993bc8ac, 0x7da71018, 0x636ee89c, 0xbb7bdb3b
	data4	0x7809cd26, 0x18f46e59, 0xb701ec9a, 0x9aa8834f
	data4	0x6e65e695, 0xe67eaaff, 0xcf0821bc, 0xe8e6ef15
	data4	0x9bd9bae7, 0x36ce4a6f, 0x09d4ea9f, 0x7cd629b0
	data4	0xb2af31a4, 0x23312a3f, 0x9430c6a5, 0x66c035a2
	data4	0xbc37744e, 0xcaa6fc82, 0xd0b0e090, 0xd81533a7
	data4	0x984af104, 0xdaf741ec, 0x500e7fcd, 0xf62f1791
	data4	0xd68d764d, 0xb04d43ef, 0x4d54ccaa, 0x04dfe496
	data4	0xb5e39ed1, 0x881b4c6a, 0x1fb8c12c, 0x517f4665
	data4	0xea049d5e, 0x355d018c, 0x7473fa87, 0x412efb0b
	data4	0x1d5ab367, 0xd25292db, 0x5633e910, 0x47136dd6
	data4	0x618c9ad7, 0x0c7a37a1, 0x148e59f8, 0x3c89eb13
	data4	0x27eecea9, 0xc935b761, 0xe5ede11c, 0xb13c7a47
	data4	0xdf599cd2, 0x733f55f2, 0xce791814, 0x37bf73c7
	data4	0xcdea53f7, 0xaa5b5ffd, 0x6f14df3d, 0xdb867844
	data4	0xf381caaf, 0xc43eb968, 0x342c3824, 0x405fc2a3
	data4	0xc372161d, 0x250cbce2, 0x498b283c, 0x9541ff0d
	data4	0x017139a8, 0xb3de080c, 0xe49cd8b4, 0xc1906456
	data4	0x84617bcb, 0xb670d532, 0x5c74486c, 0x5742d0b8
// Td3:
	data4	0xf4a75051, 0x4165537e, 0x17a4c31a, 0x275e963a
	data4	0xab6bcb3b, 0x9d45f11f, 0xfa58abac, 0xe303934b
	data4	0x30fa5520, 0x766df6ad, 0xcc769188, 0x024c25f5
	data4	0xe5d7fc4f, 0x2acbd7c5, 0x35448026, 0x62a38fb5
	data4	0xb15a49de, 0xba1b6725, 0xea0e9845, 0xfec0e15d
	data4	0x2f7502c3, 0x4cf01281, 0x4697a38d, 0xd3f9c66b
	data4	0x8f5fe703, 0x929c9515, 0x6d7aebbf, 0x5259da95
	data4	0xbe832dd4, 0x7421d358, 0xe0692949, 0xc9c8448e
	data4	0xc2896a75, 0x8e7978f4, 0x583e6b99, 0xb971dd27
	data4	0xe14fb6be, 0x88ad17f0, 0x20ac66c9, 0xce3ab47d
	data4	0xdf4a1863, 0x1a3182e5, 0x51336097, 0x537f4562
	data4	0x6477e0b1, 0x6bae84bb, 0x81a01cfe, 0x082b94f9
	data4	0x48685870, 0x45fd198f, 0xde6c8794, 0x7bf8b752
	data4	0x73d323ab, 0x4b02e272, 0x1f8f57e3, 0x55ab2a66
	data4	0xeb2807b2, 0xb5c2032f, 0xc57b9a86, 0x3708a5d3
	data4	0x2887f230, 0xbfa5b223, 0x036aba02, 0x16825ced
	data4	0xcf1c2b8a, 0x79b492a7, 0x07f2f0f3, 0x69e2a14e
	data4	0xdaf4cd65, 0x05bed506, 0x34621fd1, 0xa6fe8ac4
	data4	0x2e539d34, 0xf355a0a2, 0x8ae13205, 0xf6eb75a4
	data4	0x83ec390b, 0x60efaa40, 0x719f065e, 0x6e1051bd
	data4	0x218af93e, 0xdd063d96, 0x3e05aedd, 0xe6bd464d
	data4	0x548db591, 0xc45d0571, 0x06d46f04, 0x5015ff60
	data4	0x98fb2419, 0xbde997d6, 0x4043cc89, 0xd99e7767
	data4	0xe842bdb0, 0x898b8807, 0x195b38e7, 0xc8eedb79
	data4	0x7c0a47a1, 0x420fe97c, 0x841ec9f8, 0x00000000
	data4	0x80868309, 0x2bed4832, 0x1170ac1e, 0x5a724e6c
	data4	0x0efffbfd, 0x8538560f, 0xaed51e3d, 0x2d392736
	data4	0x0fd9640a, 0x5ca62168, 0x5b54d19b, 0x362e3a24
	data4	0x0a67b10c, 0x57e70f93, 0xee96d2b4, 0x9b919e1b
	data4	0xc0c54f80, 0xdc20a261, 0x774b695a, 0x121a161c
	data4	0x93ba0ae2, 0xa02ae5c0, 0x22e0433c, 0x1b171d12
	data4	0x090d0b0e, 0x8bc7adf2, 0xb6a8b92d, 0x1ea9c814
	data4	0xf1198557, 0x75074caf, 0x99ddbbee, 0x7f60fda3
	data4	0x01269ff7, 0x72f5bc5c, 0x663bc544, 0xfb7e345b
	data4	0x4329768b, 0x23c6dccb, 0xedfc68b6, 0xe4f163b8
	data4	0x31dccad7, 0x63851042, 0x97224013, 0xc6112084
	data4	0x4a247d85, 0xbb3df8d2, 0xf93211ae, 0x29a16dc7
	data4	0x9e2f4b1d, 0xb230f3dc, 0x8652ec0d, 0xc1e3d077
	data4	0xb3166c2b, 0x70b999a9, 0x9448fa11, 0xe9642247
	data4	0xfc8cc4a8, 0xf03f1aa0, 0x7d2cd856, 0x3390ef22
	data4	0x494ec787, 0x38d1c1d9, 0xcaa2fe8c, 0xd40b3698
	data4	0xf581cfa6, 0x7ade28a5, 0xb78e26da, 0xadbfa43f
	data4	0x3a9de42c, 0x78920d50, 0x5fcc9b6a, 0x7e466254
	data4	0x8d13c2f6, 0xd8b8e890, 0x39f75e2e, 0xc3aff582
	data4	0x5d80be9f, 0xd0937c69, 0xd52da96f, 0x2512b3cf
	data4	0xac993bc8, 0x187da710, 0x9c636ee8, 0x3bbb7bdb
	data4	0x267809cd, 0x5918f46e, 0x9ab701ec, 0x4f9aa883
	data4	0x956e65e6, 0xffe67eaa, 0xbccf0821, 0x15e8e6ef
	data4	0xe79bd9ba, 0x6f36ce4a, 0x9f09d4ea, 0xb07cd629
	data4	0xa4b2af31, 0x3f23312a, 0xa59430c6, 0xa266c035
	data4	0x4ebc3774, 0x82caa6fc, 0x90d0b0e0, 0xa7d81533
	data4	0x04984af1, 0xecdaf741, 0xcd500e7f, 0x91f62f17
	data4	0x4dd68d76, 0xefb04d43, 0xaa4d54cc, 0x9604dfe4
	data4	0xd1b5e39e, 0x6a881b4c, 0x2c1fb8c1, 0x65517f46
	data4	0x5eea049d, 0x8c355d01, 0x877473fa, 0x0b412efb
	data4	0x671d5ab3, 0xdbd25292, 0x105633e9, 0xd647136d
	data4	0xd7618c9a, 0xa10c7a37, 0xf8148e59, 0x133c89eb
	data4	0xa927eece, 0x61c935b7, 0x1ce5ede1, 0x47b13c7a
	data4	0xd2df599c, 0xf2733f55, 0x14ce7918, 0xc737bf73
	data4	0xf7cdea53, 0xfdaa5b5f, 0x3d6f14df, 0x44db8678
	data4	0xaff381ca, 0x68c43eb9, 0x24342c38, 0xa3405fc2
	data4	0x1dc37216, 0xe2250cbc, 0x3c498b28, 0x0d9541ff
	data4	0xa8017139, 0x0cb3de08, 0xb4e49cd8, 0x56c19064
	data4	0xcb84617b, 0x32b670d5, 0x6c5c7448, 0xb85742d0
// Td4:
	data4	0x52000000, 0x09000000, 0x6a000000, 0xd5000000
	data4	0x30000000, 0x36000000, 0xa5000000, 0x38000000
	data4	0xbf000000, 0x40000000, 0xa3000000, 0x9e000000
	data4	0x81000000, 0xf3000000, 0xd7000000, 0xfb000000
	data4	0x7c000000, 0xe3000000, 0x39000000, 0x82000000
	data4	0x9b000000, 0x2f000000, 0xff000000, 0x87000000
	data4	0x34000000, 0x8e000000, 0x43000000, 0x44000000
	data4	0xc4000000, 0xde000000, 0xe9000000, 0xcb000000
	data4	0x54000000, 0x7b000000, 0x94000000, 0x32000000
	data4	0xa6000000, 0xc2000000, 0x23000000, 0x3d000000
	data4	0xee000000, 0x4c000000, 0x95000000, 0x0b000000
	data4	0x42000000, 0xfa000000, 0xc3000000, 0x4e000000
	data4	0x08000000, 0x2e000000, 0xa1000000, 0x66000000
	data4	0x28000000, 0xd9000000, 0x24000000, 0xb2000000
	data4	0x76000000, 0x5b000000, 0xa2000000, 0x49000000
	data4	0x6d000000, 0x8b000000, 0xd1000000, 0x25000000
	data4	0x72000000, 0xf8000000, 0xf6000000, 0x64000000
	data4	0x86000000, 0x68000000, 0x98000000, 0x16000000
	data4	0xd4000000, 0xa4000000, 0x5c000000, 0xcc000000
	data4	0x5d000000, 0x65000000, 0xb6000000, 0x92000000
	data4	0x6c000000, 0x70000000, 0x48000000, 0x50000000
	data4	0xfd000000, 0xed000000, 0xb9000000, 0xda000000
	data4	0x5e000000, 0x15000000, 0x46000000, 0x57000000
	data4	0xa7000000, 0x8d000000, 0x9d000000, 0x84000000
	data4	0x90000000, 0xd8000000, 0xab000000, 0x00000000
	data4	0x8c000000, 0xbc000000, 0xd3000000, 0x0a000000
	data4	0xf7000000, 0xe4000000, 0x58000000, 0x05000000
	data4	0xb8000000, 0xb3000000, 0x45000000, 0x06000000
	data4	0xd0000000, 0x2c000000, 0x1e000000, 0x8f000000
	data4	0xca000000, 0x3f000000, 0x0f000000, 0x02000000
	data4	0xc1000000, 0xaf000000, 0xbd000000, 0x03000000
	data4	0x01000000, 0x13000000, 0x8a000000, 0x6b000000
	data4	0x3a000000, 0x91000000, 0x11000000, 0x41000000
	data4	0x4f000000, 0x67000000, 0xdc000000, 0xea000000
	data4	0x97000000, 0xf2000000, 0xcf000000, 0xce000000
	data4	0xf0000000, 0xb4000000, 0xe6000000, 0x73000000
	data4	0x96000000, 0xac000000, 0x74000000, 0x22000000
	data4	0xe7000000, 0xad000000, 0x35000000, 0x85000000
	data4	0xe2000000, 0xf9000000, 0x37000000, 0xe8000000
	data4	0x1c000000, 0x75000000, 0xdf000000, 0x6e000000
	data4	0x47000000, 0xf1000000, 0x1a000000, 0x71000000
	data4	0x1d000000, 0x29000000, 0xc5000000, 0x89000000
	data4	0x6f000000, 0xb7000000, 0x62000000, 0x0e000000
	data4	0xaa000000, 0x18000000, 0xbe000000, 0x1b000000
	data4	0xfc000000, 0x56000000, 0x3e000000, 0x4b000000
	data4	0xc6000000, 0xd2000000, 0x79000000, 0x20000000
	data4	0x9a000000, 0xdb000000, 0xc0000000, 0xfe000000
	data4	0x78000000, 0xcd000000, 0x5a000000, 0xf4000000
	data4	0x1f000000, 0xdd000000, 0xa8000000, 0x33000000
	data4	0x88000000, 0x07000000, 0xc7000000, 0x31000000
	data4	0xb1000000, 0x12000000, 0x10000000, 0x59000000
	data4	0x27000000, 0x80000000, 0xec000000, 0x5f000000
	data4	0x60000000, 0x51000000, 0x7f000000, 0xa9000000
	data4	0x19000000, 0xb5000000, 0x4a000000, 0x0d000000
	data4	0x2d000000, 0xe5000000, 0x7a000000, 0x9f000000
	data4	0x93000000, 0xc9000000, 0x9c000000, 0xef000000
	data4	0xa0000000, 0xe0000000, 0x3b000000, 0x4d000000
	data4	0xae000000, 0x2a000000, 0xf5000000, 0xb0000000
	data4	0xc8000000, 0xeb000000, 0xbb000000, 0x3c000000
	data4	0x83000000, 0x53000000, 0x99000000, 0x61000000
	data4	0x17000000, 0x2b000000, 0x04000000, 0x7e000000
	data4	0xba000000, 0x77000000, 0xd6000000, 0x26000000
	data4	0xe1000000, 0x69000000, 0x14000000, 0x63000000
	data4	0x55000000, 0x21000000, 0x0c000000, 0x7d000000
// Td5:
	data4	0x00520000, 0x00090000, 0x006a0000, 0x00d50000
	data4	0x00300000, 0x00360000, 0x00a50000, 0x00380000
	data4	0x00bf0000, 0x00400000, 0x00a30000, 0x009e0000
	data4	0x00810000, 0x00f30000, 0x00d70000, 0x00fb0000
	data4	0x007c0000, 0x00e30000, 0x00390000, 0x00820000
	data4	0x009b0000, 0x002f0000, 0x00ff0000, 0x00870000
	data4	0x00340000, 0x008e0000, 0x00430000, 0x00440000
	data4	0x00c40000, 0x00de0000, 0x00e90000, 0x00cb0000
	data4	0x00540000, 0x007b0000, 0x00940000, 0x00320000
	data4	0x00a60000, 0x00c20000, 0x00230000, 0x003d0000
	data4	0x00ee0000, 0x004c0000, 0x00950000, 0x000b0000
	data4	0x00420000, 0x00fa0000, 0x00c30000, 0x004e0000
	data4	0x00080000, 0x002e0000, 0x00a10000, 0x00660000
	data4	0x00280000, 0x00d90000, 0x00240000, 0x00b20000
	data4	0x00760000, 0x005b0000, 0x00a20000, 0x00490000
	data4	0x006d0000, 0x008b0000, 0x00d10000, 0x00250000
	data4	0x00720000, 0x00f80000, 0x00f60000, 0x00640000
	data4	0x00860000, 0x00680000, 0x00980000, 0x00160000
	data4	0x00d40000, 0x00a40000, 0x005c0000, 0x00cc0000
	data4	0x005d0000, 0x00650000, 0x00b60000, 0x00920000
	data4	0x006c0000, 0x00700000, 0x00480000, 0x00500000
	data4	0x00fd0000, 0x00ed0000, 0x00b90000, 0x00da0000
	data4	0x005e0000, 0x00150000, 0x00460000, 0x00570000
	data4	0x00a70000, 0x008d0000, 0x009d0000, 0x00840000
	data4	0x00900000, 0x00d80000, 0x00ab0000, 0x00000000
	data4	0x008c0000, 0x00bc0000, 0x00d30000, 0x000a0000
	data4	0x00f70000, 0x00e40000, 0x00580000, 0x00050000
	data4	0x00b80000, 0x00b30000, 0x00450000, 0x00060000
	data4	0x00d00000, 0x002c0000, 0x001e0000, 0x008f0000
	data4	0x00ca0000, 0x003f0000, 0x000f0000, 0x00020000
	data4	0x00c10000, 0x00af0000, 0x00bd0000, 0x00030000
	data4	0x00010000, 0x00130000, 0x008a0000, 0x006b0000
	data4	0x003a0000, 0x00910000, 0x00110000, 0x00410000
	data4	0x004f0000, 0x00670000, 0x00dc0000, 0x00ea0000
	data4	0x00970000, 0x00f20000, 0x00cf0000, 0x00ce0000
	data4	0x00f00000, 0x00b40000, 0x00e60000, 0x00730000
	data4	0x00960000, 0x00ac0000, 0x00740000, 0x00220000
	data4	0x00e70000, 0x00ad0000, 0x00350000, 0x00850000
	data4	0x00e20000, 0x00f90000, 0x00370000, 0x00e80000
	data4	0x001c0000, 0x00750000, 0x00df0000, 0x006e0000
	data4	0x00470000, 0x00f10000, 0x001a0000, 0x00710000
	data4	0x001d0000, 0x00290000, 0x00c50000, 0x00890000
	data4	0x006f0000, 0x00b70000, 0x00620000, 0x000e0000
	data4	0x00aa0000, 0x00180000, 0x00be0000, 0x001b0000
	data4	0x00fc0000, 0x00560000, 0x003e0000, 0x004b0000
	data4	0x00c60000, 0x00d20000, 0x00790000, 0x00200000
	data4	0x009a0000, 0x00db0000, 0x00c00000, 0x00fe0000
	data4	0x00780000, 0x00cd0000, 0x005a0000, 0x00f40000
	data4	0x001f0000, 0x00dd0000, 0x00a80000, 0x00330000
	data4	0x00880000, 0x00070000, 0x00c70000, 0x00310000
	data4	0x00b10000, 0x00120000, 0x00100000, 0x00590000
	data4	0x00270000, 0x00800000, 0x00ec0000, 0x005f0000
	data4	0x00600000, 0x00510000, 0x007f0000, 0x00a90000
	data4	0x00190000, 0x00b50000, 0x004a0000, 0x000d0000
	data4	0x002d0000, 0x00e50000, 0x007a0000, 0x009f0000
	data4	0x00930000, 0x00c90000, 0x009c0000, 0x00ef0000
	data4	0x00a00000, 0x00e00000, 0x003b0000, 0x004d0000
	data4	0x00ae0000, 0x002a0000, 0x00f50000, 0x00b00000
	data4	0x00c80000, 0x00eb0000, 0x00bb0000, 0x003c0000
	data4	0x00830000, 0x00530000, 0x00990000, 0x00610000
	data4	0x00170000, 0x002b0000, 0x00040000, 0x007e0000
	data4	0x00ba0000, 0x00770000, 0x00d60000, 0x00260000
	data4	0x00e10000, 0x00690000, 0x00140000, 0x00630000
	data4	0x00550000, 0x00210000, 0x000c0000, 0x007d0000
// Td6:
	data4	0x00005200, 0x00000900, 0x00006a00, 0x0000d500
	data4	0x00003000, 0x00003600, 0x0000a500, 0x00003800
	data4	0x0000bf00, 0x00004000, 0x0000a300, 0x00009e00
	data4	0x00008100, 0x0000f300, 0x0000d700, 0x0000fb00
	data4	0x00007c00, 0x0000e300, 0x00003900, 0x00008200
	data4	0x00009b00, 0x00002f00, 0x0000ff00, 0x00008700
	data4	0x00003400, 0x00008e00, 0x00004300, 0x00004400
	data4	0x0000c400, 0x0000de00, 0x0000e900, 0x0000cb00
	data4	0x00005400, 0x00007b00, 0x00009400, 0x00003200
	data4	0x0000a600, 0x0000c200, 0x00002300, 0x00003d00
	data4	0x0000ee00, 0x00004c00, 0x00009500, 0x00000b00
	data4	0x00004200, 0x0000fa00, 0x0000c300, 0x00004e00
	data4	0x00000800, 0x00002e00, 0x0000a100, 0x00006600
	data4	0x00002800, 0x0000d900, 0x00002400, 0x0000b200
	data4	0x00007600, 0x00005b00, 0x0000a200, 0x00004900
	data4	0x00006d00, 0x00008b00, 0x0000d100, 0x00002500
	data4	0x00007200, 0x0000f800, 0x0000f600, 0x00006400
	data4	0x00008600, 0x00006800, 0x00009800, 0x00001600
	data4	0x0000d400, 0x0000a400, 0x00005c00, 0x0000cc00
	data4	0x00005d00, 0x00006500, 0x0000b600, 0x00009200
	data4	0x00006c00, 0x00007000, 0x00004800, 0x00005000
	data4	0x0000fd00, 0x0000ed00, 0x0000b900, 0x0000da00
	data4	0x00005e00, 0x00001500, 0x00004600, 0x00005700
	data4	0x0000a700, 0x00008d00, 0x00009d00, 0x00008400
	data4	0x00009000, 0x0000d800, 0x0000ab00, 0x00000000
	data4	0x00008c00, 0x0000bc00, 0x0000d300, 0x00000a00
	data4	0x0000f700, 0x0000e400, 0x00005800, 0x00000500
	data4	0x0000b800, 0x0000b300, 0x00004500, 0x00000600
	data4	0x0000d000, 0x00002c00, 0x00001e00, 0x00008f00
	data4	0x0000ca00, 0x00003f00, 0x00000f00, 0x00000200
	data4	0x0000c100, 0x0000af00, 0x0000bd00, 0x00000300
	data4	0x00000100, 0x00001300, 0x00008a00, 0x00006b00
	data4	0x00003a00, 0x00009100, 0x00001100, 0x00004100
	data4	0x00004f00, 0x00006700, 0x0000dc00, 0x0000ea00
	data4	0x00009700, 0x0000f200, 0x0000cf00, 0x0000ce00
	data4	0x0000f000, 0x0000b400, 0x0000e600, 0x00007300
	data4	0x00009600, 0x0000ac00, 0x00007400, 0x00002200
	data4	0x0000e700, 0x0000ad00, 0x00003500, 0x00008500
	data4	0x0000e200, 0x0000f900, 0x00003700, 0x0000e800
	data4	0x00001c00, 0x00007500, 0x0000df00, 0x00006e00
	data4	0x00004700, 0x0000f100, 0x00001a00, 0x00007100
	data4	0x00001d00, 0x00002900, 0x0000c500, 0x00008900
	data4	0x00006f00, 0x0000b700, 0x00006200, 0x00000e00
	data4	0x0000aa00, 0x00001800, 0x0000be00, 0x00001b00
	data4	0x0000fc00, 0x00005600, 0x00003e00, 0x00004b00
	data4	0x0000c600, 0x0000d200, 0x00007900, 0x00002000
	data4	0x00009a00, 0x0000db00, 0x0000c000, 0x0000fe00
	data4	0x00007800, 0x0000cd00, 0x00005a00, 0x0000f400
	data4	0x00001f00, 0x0000dd00, 0x0000a800, 0x00003300
	data4	0x00008800, 0x00000700, 0x0000c700, 0x00003100
	data4	0x0000b100, 0x00001200, 0x00001000, 0x00005900
	data4	0x00002700, 0x00008000, 0x0000ec00, 0x00005f00
	data4	0x00006000, 0x00005100, 0x00007f00, 0x0000a900
	data4	0x00001900, 0x0000b500, 0x00004a00, 0x00000d00
	data4	0x00002d00, 0x0000e500, 0x00007a00, 0x00009f00
	data4	0x00009300, 0x0000c900, 0x00009c00, 0x0000ef00
	data4	0x0000a000, 0x0000e000, 0x00003b00, 0x00004d00
	data4	0x0000ae00, 0x00002a00, 0x0000f500, 0x0000b000
	data4	0x0000c800, 0x0000eb00, 0x0000bb00, 0x00003c00
	data4	0x00008300, 0x00005300, 0x00009900, 0x00006100
	data4	0x00001700, 0x00002b00, 0x00000400, 0x00007e00
	data4	0x0000ba00, 0x00007700, 0x0000d600, 0x00002600
	data4	0x0000e100, 0x00006900, 0x00001400, 0x00006300
	data4	0x00005500, 0x00002100, 0x00000c00, 0x00007d00
// Td7:
	data4	0x00000052, 0x00000009, 0x0000006a, 0x000000d5
	data4	0x00000030, 0x00000036, 0x000000a5, 0x00000038
	data4	0x000000bf, 0x00000040, 0x000000a3, 0x0000009e
	data4	0x00000081, 0x000000f3, 0x000000d7, 0x000000fb
	data4	0x0000007c, 0x000000e3, 0x00000039, 0x00000082
	data4	0x0000009b, 0x0000002f, 0x000000ff, 0x00000087
	data4	0x00000034, 0x0000008e, 0x00000043, 0x00000044
	data4	0x000000c4, 0x000000de, 0x000000e9, 0x000000cb
	data4	0x00000054, 0x0000007b, 0x00000094, 0x00000032
	data4	0x000000a6, 0x000000c2, 0x00000023, 0x0000003d
	data4	0x000000ee, 0x0000004c, 0x00000095, 0x0000000b
	data4	0x00000042, 0x000000fa, 0x000000c3, 0x0000004e
	data4	0x00000008, 0x0000002e, 0x000000a1, 0x00000066
	data4	0x00000028, 0x000000d9, 0x00000024, 0x000000b2
	data4	0x00000076, 0x0000005b, 0x000000a2, 0x00000049
	data4	0x0000006d, 0x0000008b, 0x000000d1, 0x00000025
	data4	0x00000072, 0x000000f8, 0x000000f6, 0x00000064
	data4	0x00000086, 0x00000068, 0x00000098, 0x00000016
	data4	0x000000d4, 0x000000a4, 0x0000005c, 0x000000cc
	data4	0x0000005d, 0x00000065, 0x000000b6, 0x00000092
	data4	0x0000006c, 0x00000070, 0x00000048, 0x00000050
	data4	0x000000fd, 0x000000ed, 0x000000b9, 0x000000da
	data4	0x0000005e, 0x00000015, 0x00000046, 0x00000057
	data4	0x000000a7, 0x0000008d, 0x0000009d, 0x00000084
	data4	0x00000090, 0x000000d8, 0x000000ab, 0x00000000
	data4	0x0000008c, 0x000000bc, 0x000000d3, 0x0000000a
	data4	0x000000f7, 0x000000e4, 0x00000058, 0x00000005
	data4	0x000000b8, 0x000000b3, 0x00000045, 0x00000006
	data4	0x000000d0, 0x0000002c, 0x0000001e, 0x0000008f
	data4	0x000000ca, 0x0000003f, 0x0000000f, 0x00000002
	data4	0x000000c1, 0x000000af, 0x000000bd, 0x00000003
	data4	0x00000001, 0x00000013, 0x0000008a, 0x0000006b
	data4	0x0000003a, 0x00000091, 0x00000011, 0x00000041
	data4	0x0000004f, 0x00000067, 0x000000dc, 0x000000ea
	data4	0x00000097, 0x000000f2, 0x000000cf, 0x000000ce
	data4	0x000000f0, 0x000000b4, 0x000000e6, 0x00000073
	data4	0x00000096, 0x000000ac, 0x00000074, 0x00000022
	data4	0x000000e7, 0x000000ad, 0x00000035, 0x00000085
	data4	0x000000e2, 0x000000f9, 0x00000037, 0x000000e8
	data4	0x0000001c, 0x00000075, 0x000000df, 0x0000006e
	data4	0x00000047, 0x000000f1, 0x0000001a, 0x00000071
	data4	0x0000001d, 0x00000029, 0x000000c5, 0x00000089
	data4	0x0000006f, 0x000000b7, 0x00000062, 0x0000000e
	data4	0x000000aa, 0x00000018, 0x000000be, 0x0000001b
	data4	0x000000fc, 0x00000056, 0x0000003e, 0x0000004b
	data4	0x000000c6, 0x000000d2, 0x00000079, 0x00000020
	data4	0x0000009a, 0x000000db, 0x000000c0, 0x000000fe
	data4	0x00000078, 0x000000cd, 0x0000005a, 0x000000f4
	data4	0x0000001f, 0x000000dd, 0x000000a8, 0x00000033
	data4	0x00000088, 0x00000007, 0x000000c7, 0x00000031
	data4	0x000000b1, 0x00000012, 0x00000010, 0x00000059
	data4	0x00000027, 0x00000080, 0x000000ec, 0x0000005f
	data4	0x00000060, 0x00000051, 0x0000007f, 0x000000a9
	data4	0x00000019, 0x000000b5, 0x0000004a, 0x0000000d
	data4	0x0000002d, 0x000000e5, 0x0000007a, 0x0000009f
	data4	0x00000093, 0x000000c9, 0x0000009c, 0x000000ef
	data4	0x000000a0, 0x000000e0, 0x0000003b, 0x0000004d
	data4	0x000000ae, 0x0000002a, 0x000000f5, 0x000000b0
	data4	0x000000c8, 0x000000eb, 0x000000bb, 0x0000003c
	data4	0x00000083, 0x00000053, 0x00000099, 0x00000061
	data4	0x00000017, 0x0000002b, 0x00000004, 0x0000007e
	data4	0x000000ba, 0x00000077, 0x000000d6, 0x00000026
	data4	0x000000e1, 0x00000069, 0x00000014, 0x00000063
	data4	0x00000055, 0x00000021, 0x0000000c, 0x0000007d
.size	AES_Td#,8*256*4	// HP-UX assembler fails to ".-AES_Td#"
