/*****************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * $Id$
 */

/*
 * The purpose of this test is to minimally exercise libcurl's internal
 * curl_m*printf formatting capabilities and handling of some data types.
 */

#include "test.h"

int curl_msprintf(char *buffer, const char *format, ...);


#if (CURL_SIZEOF_CURL_OFF_T > CURL_SIZEOF_LONG)
#  define MPRNT_SUFFIX_CURL_OFF_T  LL
#else
#  define MPRNT_SUFFIX_CURL_OFF_T  L
#endif


#ifdef CURL_ISOCPP
#  define MPRNT_OFF_T_C_HELPER2(Val,Suffix) Val ## Suffix
#else
#  define MPRNT_OFF_T_C_HELPER2(Val,Suffix) Val/**/Suffix
#endif
#define MPRNT_OFF_T_C_HELPER1(Val,Suffix) MPRNT_OFF_T_C_HELPER2(Val,Suffix)
#define MPRNT_OFF_T_C(Val)  MPRNT_OFF_T_C_HELPER1(Val,MPRNT_SUFFIX_CURL_OFF_T)


#define BUFSZ    256
#define ULONG_TESTS_ARRSZ  1 + 100
#define SLONG_TESTS_ARRSZ  1 + 100
#define COFFT_TESTS_ARRSZ  1 + 100


struct unslong_st {
  unsigned long num;    /* unsigned long   */
  const char *expected; /* expected string */
  char result[BUFSZ];   /* result string   */
};


struct siglong_st {
  long num;             /* signed long     */
  const char *expected; /* expected string */
  char result[BUFSZ];   /* result string   */
};


struct curloff_st {
  curl_off_t num;       /* curl_off_t      */
  const char *expected; /* expected string */
  char result[BUFSZ];   /* result string   */
};


static struct unslong_st ul_test[ULONG_TESTS_ARRSZ];
static struct siglong_st sl_test[SLONG_TESTS_ARRSZ];
static struct curloff_st co_test[COFFT_TESTS_ARRSZ];


static int test_unsigned_long_formatting(void)
{
  int i, j;
  int num_ulong_tests;
  int failed = 0;

#if (CURL_SIZEOF_LONG == 2)

  i=1; ul_test[i].num = 0xFFFFUL; ul_test[i].expected = "65535";
  i++; ul_test[i].num = 0xFF00UL; ul_test[i].expected = "65280";
  i++; ul_test[i].num = 0x00FFUL; ul_test[i].expected = "255";

  i++; ul_test[i].num = 0xF000UL; ul_test[i].expected = "61440";
  i++; ul_test[i].num = 0x0F00UL; ul_test[i].expected = "3840";
  i++; ul_test[i].num = 0x00F0UL; ul_test[i].expected = "240";
  i++; ul_test[i].num = 0x000FUL; ul_test[i].expected = "15";

  i++; ul_test[i].num = 0xC000UL; ul_test[i].expected = "49152";
  i++; ul_test[i].num = 0x0C00UL; ul_test[i].expected = "3072";
  i++; ul_test[i].num = 0x00C0UL; ul_test[i].expected = "192";
  i++; ul_test[i].num = 0x000CUL; ul_test[i].expected = "12";

  i++; ul_test[i].num = 0x0001UL; ul_test[i].expected = "1";
  i++; ul_test[i].num = 0x0000UL; ul_test[i].expected = "0";

  num_ulong_tests = i;

#elif (CURL_SIZEOF_LONG == 4)

  i=1; ul_test[i].num = 0xFFFFFFFFUL; ul_test[i].expected = "4294967295";
  i++; ul_test[i].num = 0xFFFF0000UL; ul_test[i].expected = "4294901760";
  i++; ul_test[i].num = 0x0000FFFFUL; ul_test[i].expected = "65535";

  i++; ul_test[i].num = 0xFF000000UL; ul_test[i].expected = "4278190080";
  i++; ul_test[i].num = 0x00FF0000UL; ul_test[i].expected = "16711680";
  i++; ul_test[i].num = 0x0000FF00UL; ul_test[i].expected = "65280";
  i++; ul_test[i].num = 0x000000FFUL; ul_test[i].expected = "255";

  i++; ul_test[i].num = 0xF0000000UL; ul_test[i].expected = "4026531840";
  i++; ul_test[i].num = 0x0F000000UL; ul_test[i].expected = "251658240";
  i++; ul_test[i].num = 0x00F00000UL; ul_test[i].expected = "15728640";
  i++; ul_test[i].num = 0x000F0000UL; ul_test[i].expected = "983040";
  i++; ul_test[i].num = 0x0000F000UL; ul_test[i].expected = "61440";
  i++; ul_test[i].num = 0x00000F00UL; ul_test[i].expected = "3840";
  i++; ul_test[i].num = 0x000000F0UL; ul_test[i].expected = "240";
  i++; ul_test[i].num = 0x0000000FUL; ul_test[i].expected = "15";

  i++; ul_test[i].num = 0xC0000000UL; ul_test[i].expected = "3221225472";
  i++; ul_test[i].num = 0x0C000000UL; ul_test[i].expected = "201326592";
  i++; ul_test[i].num = 0x00C00000UL; ul_test[i].expected = "12582912";
  i++; ul_test[i].num = 0x000C0000UL; ul_test[i].expected = "786432";
  i++; ul_test[i].num = 0x0000C000UL; ul_test[i].expected = "49152";
  i++; ul_test[i].num = 0x00000C00UL; ul_test[i].expected = "3072";
  i++; ul_test[i].num = 0x000000C0UL; ul_test[i].expected = "192";
  i++; ul_test[i].num = 0x0000000CUL; ul_test[i].expected = "12";

  i++; ul_test[i].num = 0x00000001UL; ul_test[i].expected = "1";
  i++; ul_test[i].num = 0x00000000UL; ul_test[i].expected = "0";

  num_ulong_tests = i;

#elif (CURL_SIZEOF_LONG == 8)

  i=1; ul_test[i].num = 0xFFFFFFFFFFFFFFFFUL; ul_test[i].expected = "18446744073709551615";
  i++; ul_test[i].num = 0xFFFFFFFF00000000UL; ul_test[i].expected = "18446744069414584320";
  i++; ul_test[i].num = 0x00000000FFFFFFFFUL; ul_test[i].expected = "4294967295";

  i++; ul_test[i].num = 0xFFFF000000000000UL; ul_test[i].expected = "18446462598732840960";
  i++; ul_test[i].num = 0x0000FFFF00000000UL; ul_test[i].expected = "281470681743360";
  i++; ul_test[i].num = 0x00000000FFFF0000UL; ul_test[i].expected = "4294901760";
  i++; ul_test[i].num = 0x000000000000FFFFUL; ul_test[i].expected = "65535";

  i++; ul_test[i].num = 0xFF00000000000000UL; ul_test[i].expected = "18374686479671623680";
  i++; ul_test[i].num = 0x00FF000000000000UL; ul_test[i].expected = "71776119061217280";
  i++; ul_test[i].num = 0x0000FF0000000000UL; ul_test[i].expected = "280375465082880";
  i++; ul_test[i].num = 0x000000FF00000000UL; ul_test[i].expected = "1095216660480";
  i++; ul_test[i].num = 0x00000000FF000000UL; ul_test[i].expected = "4278190080";
  i++; ul_test[i].num = 0x0000000000FF0000UL; ul_test[i].expected = "16711680";
  i++; ul_test[i].num = 0x000000000000FF00UL; ul_test[i].expected = "65280";
  i++; ul_test[i].num = 0x00000000000000FFUL; ul_test[i].expected = "255";

  i++; ul_test[i].num = 0xF000000000000000UL; ul_test[i].expected = "17293822569102704640";
  i++; ul_test[i].num = 0x0F00000000000000UL; ul_test[i].expected = "1080863910568919040";
  i++; ul_test[i].num = 0x00F0000000000000UL; ul_test[i].expected = "67553994410557440";
  i++; ul_test[i].num = 0x000F000000000000UL; ul_test[i].expected = "4222124650659840";
  i++; ul_test[i].num = 0x0000F00000000000UL; ul_test[i].expected = "263882790666240";
  i++; ul_test[i].num = 0x00000F0000000000UL; ul_test[i].expected = "16492674416640";
  i++; ul_test[i].num = 0x000000F000000000UL; ul_test[i].expected = "1030792151040";
  i++; ul_test[i].num = 0x0000000F00000000UL; ul_test[i].expected = "64424509440";
  i++; ul_test[i].num = 0x00000000F0000000UL; ul_test[i].expected = "4026531840";
  i++; ul_test[i].num = 0x000000000F000000UL; ul_test[i].expected = "251658240";
  i++; ul_test[i].num = 0x0000000000F00000UL; ul_test[i].expected = "15728640";
  i++; ul_test[i].num = 0x00000000000F0000UL; ul_test[i].expected = "983040";
  i++; ul_test[i].num = 0x000000000000F000UL; ul_test[i].expected = "61440";
  i++; ul_test[i].num = 0x0000000000000F00UL; ul_test[i].expected = "3840";
  i++; ul_test[i].num = 0x00000000000000F0UL; ul_test[i].expected = "240";
  i++; ul_test[i].num = 0x000000000000000FUL; ul_test[i].expected = "15";

  i++; ul_test[i].num = 0xC000000000000000UL; ul_test[i].expected = "13835058055282163712";
  i++; ul_test[i].num = 0x0C00000000000000UL; ul_test[i].expected = "864691128455135232";
  i++; ul_test[i].num = 0x00C0000000000000UL; ul_test[i].expected = "54043195528445952";
  i++; ul_test[i].num = 0x000C000000000000UL; ul_test[i].expected = "3377699720527872";
  i++; ul_test[i].num = 0x0000C00000000000UL; ul_test[i].expected = "211106232532992";
  i++; ul_test[i].num = 0x00000C0000000000UL; ul_test[i].expected = "13194139533312";
  i++; ul_test[i].num = 0x000000C000000000UL; ul_test[i].expected = "824633720832";
  i++; ul_test[i].num = 0x0000000C00000000UL; ul_test[i].expected = "51539607552";
  i++; ul_test[i].num = 0x00000000C0000000UL; ul_test[i].expected = "3221225472";
  i++; ul_test[i].num = 0x000000000C000000UL; ul_test[i].expected = "201326592";
  i++; ul_test[i].num = 0x0000000000C00000UL; ul_test[i].expected = "12582912";
  i++; ul_test[i].num = 0x00000000000C0000UL; ul_test[i].expected = "786432";
  i++; ul_test[i].num = 0x000000000000C000UL; ul_test[i].expected = "49152";
  i++; ul_test[i].num = 0x0000000000000C00UL; ul_test[i].expected = "3072";
  i++; ul_test[i].num = 0x00000000000000C0UL; ul_test[i].expected = "192";
  i++; ul_test[i].num = 0x000000000000000CUL; ul_test[i].expected = "12";

  i++; ul_test[i].num = 0x00000001UL; ul_test[i].expected = "1";
  i++; ul_test[i].num = 0x00000000UL; ul_test[i].expected = "0";

  num_ulong_tests = i;

#endif

  for(i=1; i<=num_ulong_tests; i++) {

    for(j=0; j<BUFSZ; j++)
      ul_test[i].result[j] = 'X';
    ul_test[i].result[BUFSZ-1] = '\0';

    (void)curl_msprintf(ul_test[i].result, "%lu", ul_test[i].num);

    if(memcmp(ul_test[i].result,
               ul_test[i].expected,
               strlen(ul_test[i].expected))) {
      printf("unsigned long test #%.2d: Failed (Expected: %s Got: %s)\n",
             i, ul_test[i].expected, ul_test[i].result);
      failed++;
    }

  }

  if(!failed)
    printf("All curl_mprintf() unsigned long tests OK!\n");
  else
    printf("Some curl_mprintf() unsigned long tests Failed!\n");

  return failed;
}


static int test_signed_long_formatting(void)
{
  int i, j;
  int num_slong_tests;
  int failed = 0;

#if (CURL_SIZEOF_LONG == 2)

  i=1; sl_test[i].num = 0x7FFFL; sl_test[i].expected = "32767";
  i++; sl_test[i].num = 0x7FFEL; sl_test[i].expected = "32766";
  i++; sl_test[i].num = 0x7FFDL; sl_test[i].expected = "32765";
  i++; sl_test[i].num = 0x7F00L; sl_test[i].expected = "32512";
  i++; sl_test[i].num = 0x07F0L; sl_test[i].expected = "2032";
  i++; sl_test[i].num = 0x007FL; sl_test[i].expected = "127";

  i++; sl_test[i].num = 0x7000L; sl_test[i].expected = "28672";
  i++; sl_test[i].num = 0x0700L; sl_test[i].expected = "1792";
  i++; sl_test[i].num = 0x0070L; sl_test[i].expected = "112";
  i++; sl_test[i].num = 0x0007L; sl_test[i].expected = "7";

  i++; sl_test[i].num = 0x5000L; sl_test[i].expected = "20480";
  i++; sl_test[i].num = 0x0500L; sl_test[i].expected = "1280";
  i++; sl_test[i].num = 0x0050L; sl_test[i].expected = "80";
  i++; sl_test[i].num = 0x0005L; sl_test[i].expected = "5";

  i++; sl_test[i].num = 0x0001L; sl_test[i].expected = "1";
  i++; sl_test[i].num = 0x0000L; sl_test[i].expected = "0";

  i++; sl_test[i].num = -0x7FFFL -1L; sl_test[i].expected = "-32768";
  i++; sl_test[i].num = -0x7FFEL -1L; sl_test[i].expected = "-32767";
  i++; sl_test[i].num = -0x7FFDL -1L; sl_test[i].expected = "-32766";
  i++; sl_test[i].num = -0x7F00L -1L; sl_test[i].expected = "-32513";
  i++; sl_test[i].num = -0x07F0L -1L; sl_test[i].expected = "-2033";
  i++; sl_test[i].num = -0x007FL -1L; sl_test[i].expected = "-128";

  i++; sl_test[i].num = -0x7000L -1L; sl_test[i].expected = "-28673";
  i++; sl_test[i].num = -0x0700L -1L; sl_test[i].expected = "-1793";
  i++; sl_test[i].num = -0x0070L -1L; sl_test[i].expected = "-113";
  i++; sl_test[i].num = -0x0007L -1L; sl_test[i].expected = "-8";

  i++; sl_test[i].num = -0x5000L -1L; sl_test[i].expected = "-20481";
  i++; sl_test[i].num = -0x0500L -1L; sl_test[i].expected = "-1281";
  i++; sl_test[i].num = -0x0050L -1L; sl_test[i].expected = "-81";
  i++; sl_test[i].num = -0x0005L -1L; sl_test[i].expected = "-6";

  i++; sl_test[i].num =  0x0000L -1L; sl_test[i].expected = "-1";

  num_slong_tests = i;

#elif (CURL_SIZEOF_LONG == 4)

  i=1; sl_test[i].num = 0x7FFFFFFFL; sl_test[i].expected = "2147483647";
  i++; sl_test[i].num = 0x7FFFFFFEL; sl_test[i].expected = "2147483646";
  i++; sl_test[i].num = 0x7FFFFFFDL; sl_test[i].expected = "2147483645";
  i++; sl_test[i].num = 0x7FFF0000L; sl_test[i].expected = "2147418112";
  i++; sl_test[i].num = 0x00007FFFL; sl_test[i].expected = "32767";

  i++; sl_test[i].num = 0x7F000000L; sl_test[i].expected = "2130706432";
  i++; sl_test[i].num = 0x007F0000L; sl_test[i].expected = "8323072";
  i++; sl_test[i].num = 0x00007F00L; sl_test[i].expected = "32512";
  i++; sl_test[i].num = 0x0000007FL; sl_test[i].expected = "127";

  i++; sl_test[i].num = 0x70000000L; sl_test[i].expected = "1879048192";
  i++; sl_test[i].num = 0x07000000L; sl_test[i].expected = "117440512";
  i++; sl_test[i].num = 0x00700000L; sl_test[i].expected = "7340032";
  i++; sl_test[i].num = 0x00070000L; sl_test[i].expected = "458752";
  i++; sl_test[i].num = 0x00007000L; sl_test[i].expected = "28672";
  i++; sl_test[i].num = 0x00000700L; sl_test[i].expected = "1792";
  i++; sl_test[i].num = 0x00000070L; sl_test[i].expected = "112";
  i++; sl_test[i].num = 0x00000007L; sl_test[i].expected = "7";

  i++; sl_test[i].num = 0x50000000L; sl_test[i].expected = "1342177280";
  i++; sl_test[i].num = 0x05000000L; sl_test[i].expected = "83886080";
  i++; sl_test[i].num = 0x00500000L; sl_test[i].expected = "5242880";
  i++; sl_test[i].num = 0x00050000L; sl_test[i].expected = "327680";
  i++; sl_test[i].num = 0x00005000L; sl_test[i].expected = "20480";
  i++; sl_test[i].num = 0x00000500L; sl_test[i].expected = "1280";
  i++; sl_test[i].num = 0x00000050L; sl_test[i].expected = "80";
  i++; sl_test[i].num = 0x00000005L; sl_test[i].expected = "5";

  i++; sl_test[i].num = 0x00000001L; sl_test[i].expected = "1";
  i++; sl_test[i].num = 0x00000000L; sl_test[i].expected = "0";

  i++; sl_test[i].num = -0x7FFFFFFFL -1L; sl_test[i].expected = "-2147483648";
  i++; sl_test[i].num = -0x7FFFFFFEL -1L; sl_test[i].expected = "-2147483647";
  i++; sl_test[i].num = -0x7FFFFFFDL -1L; sl_test[i].expected = "-2147483646";
  i++; sl_test[i].num = -0x7FFF0000L -1L; sl_test[i].expected = "-2147418113";
  i++; sl_test[i].num = -0x00007FFFL -1L; sl_test[i].expected = "-32768";

  i++; sl_test[i].num = -0x7F000000L -1L; sl_test[i].expected = "-2130706433";
  i++; sl_test[i].num = -0x007F0000L -1L; sl_test[i].expected = "-8323073";
  i++; sl_test[i].num = -0x00007F00L -1L; sl_test[i].expected = "-32513";
  i++; sl_test[i].num = -0x0000007FL -1L; sl_test[i].expected = "-128";

  i++; sl_test[i].num = -0x70000000L -1L; sl_test[i].expected = "-1879048193";
  i++; sl_test[i].num = -0x07000000L -1L; sl_test[i].expected = "-117440513";
  i++; sl_test[i].num = -0x00700000L -1L; sl_test[i].expected = "-7340033";
  i++; sl_test[i].num = -0x00070000L -1L; sl_test[i].expected = "-458753";
  i++; sl_test[i].num = -0x00007000L -1L; sl_test[i].expected = "-28673";
  i++; sl_test[i].num = -0x00000700L -1L; sl_test[i].expected = "-1793";
  i++; sl_test[i].num = -0x00000070L -1L; sl_test[i].expected = "-113";
  i++; sl_test[i].num = -0x00000007L -1L; sl_test[i].expected = "-8";

  i++; sl_test[i].num = -0x50000000L -1L; sl_test[i].expected = "-1342177281";
  i++; sl_test[i].num = -0x05000000L -1L; sl_test[i].expected = "-83886081";
  i++; sl_test[i].num = -0x00500000L -1L; sl_test[i].expected = "-5242881";
  i++; sl_test[i].num = -0x00050000L -1L; sl_test[i].expected = "-327681";
  i++; sl_test[i].num = -0x00005000L -1L; sl_test[i].expected = "-20481";
  i++; sl_test[i].num = -0x00000500L -1L; sl_test[i].expected = "-1281";
  i++; sl_test[i].num = -0x00000050L -1L; sl_test[i].expected = "-81";
  i++; sl_test[i].num = -0x00000005L -1L; sl_test[i].expected = "-6";

  i++; sl_test[i].num =  0x00000000L -1L; sl_test[i].expected = "-1";

  num_slong_tests = i;

#elif (CURL_SIZEOF_LONG == 8)

  i=1; sl_test[i].num = 0x7FFFFFFFFFFFFFFFL; sl_test[i].expected = "9223372036854775807";
  i++; sl_test[i].num = 0x7FFFFFFFFFFFFFFEL; sl_test[i].expected = "9223372036854775806";
  i++; sl_test[i].num = 0x7FFFFFFFFFFFFFFDL; sl_test[i].expected = "9223372036854775805";
  i++; sl_test[i].num = 0x7FFFFFFF00000000L; sl_test[i].expected = "9223372032559808512";
  i++; sl_test[i].num = 0x000000007FFFFFFFL; sl_test[i].expected = "2147483647";

  i++; sl_test[i].num = 0x7FFF000000000000L; sl_test[i].expected = "9223090561878065152";
  i++; sl_test[i].num = 0x00007FFF00000000L; sl_test[i].expected = "140733193388032";
  i++; sl_test[i].num = 0x000000007FFF0000L; sl_test[i].expected = "2147418112";
  i++; sl_test[i].num = 0x0000000000007FFFL; sl_test[i].expected = "32767";

  i++; sl_test[i].num = 0x7F00000000000000L; sl_test[i].expected = "9151314442816847872";
  i++; sl_test[i].num = 0x007F000000000000L; sl_test[i].expected = "35747322042253312";
  i++; sl_test[i].num = 0x00007F0000000000L; sl_test[i].expected = "139637976727552";
  i++; sl_test[i].num = 0x0000007F00000000L; sl_test[i].expected = "545460846592";
  i++; sl_test[i].num = 0x000000007F000000L; sl_test[i].expected = "2130706432";
  i++; sl_test[i].num = 0x00000000007F0000L; sl_test[i].expected = "8323072";
  i++; sl_test[i].num = 0x0000000000007F00L; sl_test[i].expected = "32512";
  i++; sl_test[i].num = 0x000000000000007FL; sl_test[i].expected = "127";

  i++; sl_test[i].num = 0x7000000000000000L; sl_test[i].expected = "8070450532247928832";
  i++; sl_test[i].num = 0x0700000000000000L; sl_test[i].expected = "504403158265495552";
  i++; sl_test[i].num = 0x0070000000000000L; sl_test[i].expected = "31525197391593472";
  i++; sl_test[i].num = 0x0007000000000000L; sl_test[i].expected = "1970324836974592";
  i++; sl_test[i].num = 0x0000700000000000L; sl_test[i].expected = "123145302310912";
  i++; sl_test[i].num = 0x0000070000000000L; sl_test[i].expected = "7696581394432";
  i++; sl_test[i].num = 0x0000007000000000L; sl_test[i].expected = "481036337152";
  i++; sl_test[i].num = 0x0000000700000000L; sl_test[i].expected = "30064771072";
  i++; sl_test[i].num = 0x0000000070000000L; sl_test[i].expected = "1879048192";
  i++; sl_test[i].num = 0x0000000007000000L; sl_test[i].expected = "117440512";
  i++; sl_test[i].num = 0x0000000000700000L; sl_test[i].expected = "7340032";
  i++; sl_test[i].num = 0x0000000000070000L; sl_test[i].expected = "458752";
  i++; sl_test[i].num = 0x0000000000007000L; sl_test[i].expected = "28672";
  i++; sl_test[i].num = 0x0000000000000700L; sl_test[i].expected = "1792";
  i++; sl_test[i].num = 0x0000000000000070L; sl_test[i].expected = "112";
  i++; sl_test[i].num = 0x0000000000000007L; sl_test[i].expected = "7";

  i++; sl_test[i].num = 0x0000000000000001L; sl_test[i].expected = "1";
  i++; sl_test[i].num = 0x0000000000000000L; sl_test[i].expected = "0";

  i++; sl_test[i].num = -0x7FFFFFFFFFFFFFFFL -1L; sl_test[i].expected = "-9223372036854775808";
  i++; sl_test[i].num = -0x7FFFFFFFFFFFFFFEL -1L; sl_test[i].expected = "-9223372036854775807";
  i++; sl_test[i].num = -0x7FFFFFFFFFFFFFFDL -1L; sl_test[i].expected = "-9223372036854775806";
  i++; sl_test[i].num = -0x7FFFFFFF00000000L -1L; sl_test[i].expected = "-9223372032559808513";
  i++; sl_test[i].num = -0x000000007FFFFFFFL -1L; sl_test[i].expected = "-2147483648";

  i++; sl_test[i].num = -0x7FFF000000000000L -1L; sl_test[i].expected = "-9223090561878065153";
  i++; sl_test[i].num = -0x00007FFF00000000L -1L; sl_test[i].expected = "-140733193388033";
  i++; sl_test[i].num = -0x000000007FFF0000L -1L; sl_test[i].expected = "-2147418113";
  i++; sl_test[i].num = -0x0000000000007FFFL -1L; sl_test[i].expected = "-32768";

  i++; sl_test[i].num = -0x7F00000000000000L -1L; sl_test[i].expected = "-9151314442816847873";
  i++; sl_test[i].num = -0x007F000000000000L -1L; sl_test[i].expected = "-35747322042253313";
  i++; sl_test[i].num = -0x00007F0000000000L -1L; sl_test[i].expected = "-139637976727553";
  i++; sl_test[i].num = -0x0000007F00000000L -1L; sl_test[i].expected = "-545460846593";
  i++; sl_test[i].num = -0x000000007F000000L -1L; sl_test[i].expected = "-2130706433";
  i++; sl_test[i].num = -0x00000000007F0000L -1L; sl_test[i].expected = "-8323073";
  i++; sl_test[i].num = -0x0000000000007F00L -1L; sl_test[i].expected = "-32513";
  i++; sl_test[i].num = -0x000000000000007FL -1L; sl_test[i].expected = "-128";

  i++; sl_test[i].num = -0x7000000000000000L -1L; sl_test[i].expected = "-8070450532247928833";
  i++; sl_test[i].num = -0x0700000000000000L -1L; sl_test[i].expected = "-504403158265495553";
  i++; sl_test[i].num = -0x0070000000000000L -1L; sl_test[i].expected = "-31525197391593473";
  i++; sl_test[i].num = -0x0007000000000000L -1L; sl_test[i].expected = "-1970324836974593";
  i++; sl_test[i].num = -0x0000700000000000L -1L; sl_test[i].expected = "-123145302310913";
  i++; sl_test[i].num = -0x0000070000000000L -1L; sl_test[i].expected = "-7696581394433";
  i++; sl_test[i].num = -0x0000007000000000L -1L; sl_test[i].expected = "-481036337153";
  i++; sl_test[i].num = -0x0000000700000000L -1L; sl_test[i].expected = "-30064771073";
  i++; sl_test[i].num = -0x0000000070000000L -1L; sl_test[i].expected = "-1879048193";
  i++; sl_test[i].num = -0x0000000007000000L -1L; sl_test[i].expected = "-117440513";
  i++; sl_test[i].num = -0x0000000000700000L -1L; sl_test[i].expected = "-7340033";
  i++; sl_test[i].num = -0x0000000000070000L -1L; sl_test[i].expected = "-458753";
  i++; sl_test[i].num = -0x0000000000007000L -1L; sl_test[i].expected = "-28673";
  i++; sl_test[i].num = -0x0000000000000700L -1L; sl_test[i].expected = "-1793";
  i++; sl_test[i].num = -0x0000000000000070L -1L; sl_test[i].expected = "-113";
  i++; sl_test[i].num = -0x0000000000000007L -1L; sl_test[i].expected = "-8";

  i++; sl_test[i].num =  0x0000000000000000L -1L; sl_test[i].expected = "-1";

  num_slong_tests = i;

#endif

  for(i=1; i<=num_slong_tests; i++) {

    for(j=0; j<BUFSZ; j++)
      sl_test[i].result[j] = 'X';
    sl_test[i].result[BUFSZ-1] = '\0';

    (void)curl_msprintf(sl_test[i].result, "%ld", sl_test[i].num);

    if(memcmp(sl_test[i].result,
              sl_test[i].expected,
              strlen(sl_test[i].expected))) {
      printf("signed long test #%.2d: Failed (Expected: %s Got: %s)\n",
             i, sl_test[i].expected, sl_test[i].result);
      failed++;
    }

  }

  if(!failed)
    printf("All curl_mprintf() signed long tests OK!\n");
  else
    printf("Some curl_mprintf() signed long tests Failed!\n");

  return failed;
}


static int test_curl_off_t_formatting(void)
{
  int i, j;
  int num_cofft_tests;
  int failed = 0;

#if (CURL_SIZEOF_CURL_OFF_T == 2)

  i=1; co_test[i].num = MPRNT_OFF_T_C(0x7FFF); co_test[i].expected = "32767";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFE); co_test[i].expected = "32766";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFD); co_test[i].expected = "32765";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7F00); co_test[i].expected = "32512";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x07F0); co_test[i].expected = "2032";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x007F); co_test[i].expected = "127";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x7000); co_test[i].expected = "28672";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0700); co_test[i].expected = "1792";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0070); co_test[i].expected = "112";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0007); co_test[i].expected = "7";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x5000); co_test[i].expected = "20480";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0500); co_test[i].expected = "1280";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0050); co_test[i].expected = "80";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0005); co_test[i].expected = "5";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x0001); co_test[i].expected = "1";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000); co_test[i].expected = "0";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFF) -MPRNT_OFF_T_C(1); co_test[i].expected = "-32768";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFE) -MPRNT_OFF_T_C(1); co_test[i].expected = "-32767";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFD) -MPRNT_OFF_T_C(1); co_test[i].expected = "-32766";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7F00) -MPRNT_OFF_T_C(1); co_test[i].expected = "-32513";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x07F0) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2033";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x007F) -MPRNT_OFF_T_C(1); co_test[i].expected = "-128";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-28673";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0700) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1793";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0070) -MPRNT_OFF_T_C(1); co_test[i].expected = "-113";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0007) -MPRNT_OFF_T_C(1); co_test[i].expected = "-8";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x5000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-20481";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0500) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1281";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0050) -MPRNT_OFF_T_C(1); co_test[i].expected = "-81";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0005) -MPRNT_OFF_T_C(1); co_test[i].expected = "-6";

  i++; co_test[i].num =  MPRNT_OFF_T_C(0x0000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1";

  num_cofft_tests = i;

#elif (CURL_SIZEOF_CURL_OFF_T == 4)

  i=1; co_test[i].num = MPRNT_OFF_T_C(0x7FFFFFFF); co_test[i].expected = "2147483647";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFFFFFE); co_test[i].expected = "2147483646";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFFFFFD); co_test[i].expected = "2147483645";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFF0000); co_test[i].expected = "2147418112";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00007FFF); co_test[i].expected = "32767";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x7F000000); co_test[i].expected = "2130706432";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x007F0000); co_test[i].expected = "8323072";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00007F00); co_test[i].expected = "32512";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000007F); co_test[i].expected = "127";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x70000000); co_test[i].expected = "1879048192";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x07000000); co_test[i].expected = "117440512";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00700000); co_test[i].expected = "7340032";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00070000); co_test[i].expected = "458752";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00007000); co_test[i].expected = "28672";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000700); co_test[i].expected = "1792";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000070); co_test[i].expected = "112";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000007); co_test[i].expected = "7";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x50000000); co_test[i].expected = "1342177280";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x05000000); co_test[i].expected = "83886080";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00500000); co_test[i].expected = "5242880";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00050000); co_test[i].expected = "327680";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00005000); co_test[i].expected = "20480";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000500); co_test[i].expected = "1280";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000050); co_test[i].expected = "80";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000005); co_test[i].expected = "5";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000001); co_test[i].expected = "1";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000000); co_test[i].expected = "0";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFFFFFF) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2147483648";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFFFFFE) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2147483647";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFFFFFD) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2147483646";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFF0000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2147418113";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00007FFF) -MPRNT_OFF_T_C(1); co_test[i].expected = "-32768";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7F000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2130706433";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x007F0000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-8323073";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00007F00) -MPRNT_OFF_T_C(1); co_test[i].expected = "-32513";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000007F) -MPRNT_OFF_T_C(1); co_test[i].expected = "-128";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x70000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1879048193";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x07000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-117440513";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00700000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-7340033";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00070000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-458753";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00007000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-28673";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00000700) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1793";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00000070) -MPRNT_OFF_T_C(1); co_test[i].expected = "-113";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00000007) -MPRNT_OFF_T_C(1); co_test[i].expected = "-8";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x50000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1342177281";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x05000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-83886081";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00500000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-5242881";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00050000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-327681";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00005000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-20481";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00000500) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1281";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00000050) -MPRNT_OFF_T_C(1); co_test[i].expected = "-81";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00000005) -MPRNT_OFF_T_C(1); co_test[i].expected = "-6";

  i++; co_test[i].num =  MPRNT_OFF_T_C(0x00000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1";

  num_cofft_tests = i;

#elif (CURL_SIZEOF_CURL_OFF_T == 8)

  i=1; co_test[i].num = MPRNT_OFF_T_C(0x7FFFFFFFFFFFFFFF); co_test[i].expected = "9223372036854775807";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFFFFFFFFFFFFFE); co_test[i].expected = "9223372036854775806";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFFFFFFFFFFFFFD); co_test[i].expected = "9223372036854775805";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFFFFFF00000000); co_test[i].expected = "9223372032559808512";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x000000007FFFFFFF); co_test[i].expected = "2147483647";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x7FFF000000000000); co_test[i].expected = "9223090561878065152";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00007FFF00000000); co_test[i].expected = "140733193388032";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x000000007FFF0000); co_test[i].expected = "2147418112";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000007FFF); co_test[i].expected = "32767";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x7F00000000000000); co_test[i].expected = "9151314442816847872";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x007F000000000000); co_test[i].expected = "35747322042253312";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00007F0000000000); co_test[i].expected = "139637976727552";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000007F00000000); co_test[i].expected = "545460846592";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x000000007F000000); co_test[i].expected = "2130706432";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x00000000007F0000); co_test[i].expected = "8323072";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000007F00); co_test[i].expected = "32512";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x000000000000007F); co_test[i].expected = "127";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x7000000000000000); co_test[i].expected = "8070450532247928832";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0700000000000000); co_test[i].expected = "504403158265495552";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0070000000000000); co_test[i].expected = "31525197391593472";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0007000000000000); co_test[i].expected = "1970324836974592";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000700000000000); co_test[i].expected = "123145302310912";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000070000000000); co_test[i].expected = "7696581394432";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000007000000000); co_test[i].expected = "481036337152";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000700000000); co_test[i].expected = "30064771072";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000070000000); co_test[i].expected = "1879048192";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000007000000); co_test[i].expected = "117440512";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000700000); co_test[i].expected = "7340032";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000070000); co_test[i].expected = "458752";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000007000); co_test[i].expected = "28672";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000000700); co_test[i].expected = "1792";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000000070); co_test[i].expected = "112";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000000007); co_test[i].expected = "7";

  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000000001); co_test[i].expected = "1";
  i++; co_test[i].num = MPRNT_OFF_T_C(0x0000000000000000); co_test[i].expected = "0";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFFFFFFFFFFFFFF) -MPRNT_OFF_T_C(1); co_test[i].expected = "-9223372036854775808";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFFFFFFFFFFFFFE) -MPRNT_OFF_T_C(1); co_test[i].expected = "-9223372036854775807";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFFFFFFFFFFFFFD) -MPRNT_OFF_T_C(1); co_test[i].expected = "-9223372036854775806";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFFFFFF00000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-9223372032559808513";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x000000007FFFFFFF) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2147483648";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7FFF000000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-9223090561878065153";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00007FFF00000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-140733193388033";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x000000007FFF0000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2147418113";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000000007FFF) -MPRNT_OFF_T_C(1); co_test[i].expected = "-32768";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7F00000000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-9151314442816847873";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x007F000000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-35747322042253313";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00007F0000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-139637976727553";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000007F00000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-545460846593";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x000000007F000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-2130706433";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x00000000007F0000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-8323073";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000000007F00) -MPRNT_OFF_T_C(1); co_test[i].expected = "-32513";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x000000000000007F) -MPRNT_OFF_T_C(1); co_test[i].expected = "-128";

  i++; co_test[i].num = -MPRNT_OFF_T_C(0x7000000000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-8070450532247928833";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0700000000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-504403158265495553";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0070000000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-31525197391593473";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0007000000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1970324836974593";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000700000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-123145302310913";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000070000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-7696581394433";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000007000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-481036337153";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000700000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-30064771073";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000070000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1879048193";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000007000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-117440513";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000000700000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-7340033";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000000070000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-458753";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000000007000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-28673";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000000000700) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1793";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000000000070) -MPRNT_OFF_T_C(1); co_test[i].expected = "-113";
  i++; co_test[i].num = -MPRNT_OFF_T_C(0x0000000000000007) -MPRNT_OFF_T_C(1); co_test[i].expected = "-8";

  i++; co_test[i].num =  MPRNT_OFF_T_C(0x0000000000000000) -MPRNT_OFF_T_C(1); co_test[i].expected = "-1";

  num_cofft_tests = i;

#endif

  for(i=1; i<=num_cofft_tests; i++) {

    for(j=0; j<BUFSZ; j++)
      co_test[i].result[j] = 'X';
    co_test[i].result[BUFSZ-1] = '\0';

    (void)curl_msprintf(co_test[i].result, "%" FORMAT_OFF_T, co_test[i].num);

    if(memcmp(co_test[i].result,
               co_test[i].expected,
               strlen(co_test[i].expected))) {
      printf("curl_off_t test #%.2d: Failed (Expected: %s Got: %s)\n",
             i, co_test[i].expected, co_test[i].result);
      failed++;
    }

  }

  if(!failed)
    printf("All curl_mprintf() curl_off_t tests OK!\n");
  else
    printf("Some curl_mprintf() curl_off_t tests Failed!\n");

  return failed;
}


int test(char *URL)
{
  int errors = 0;
  (void)URL; /* not used */

  errors += test_unsigned_long_formatting();

  errors += test_signed_long_formatting();

  errors += test_curl_off_t_formatting();

  if(errors)
    return TEST_ERR_MAJOR_BAD;
  else
    return 0;
}
