/*
 * multicontext.h
 *
 *  Created on: 15 Mar 2018
 *      Author: development
 */

#ifndef MODULES_SSL_SSL_MULTICONTEXT_H_
#define MODULES_SSL_SSL_MULTICONTEXT_H_

#include "apr_optional.h"
#include "httpd.h"

#include "ssl_private.h"
#include "mod_ssl.h"
#include "mod_ssl_openssl.h"


#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char CONTEXT_ID;

/*multi-context Error Codes
 */
#include "apr_errno.h"
#define MODSSL_MC_BASE (16)
#define MODSSL_MC_SUCCESS (APR_SUCCESS)
#define MODSSL_MC_NOTMULTICONTEXT (APR_OS_START_USERERR + MODSSL_MC_BASE + 0)
#define MODSSL_MC_NOSUCHCONTEXT   (APR_OS_START_USERERR + MODSSL_MC_BASE + 1)


/*todo - check standard for this*/
#define MAX_CONTEXT_NAME_LENGTH (50)

APR_DECLARE_OPTIONAL_FN(
		int,
		MC_SetActiveContextByName,
		(conn_rec*, const char*, CONTEXT_ID*));

APR_DECLARE_OPTIONAL_FN(
		int,
		MC_SetActiveContextByID,
		(conn_rec*, CONTEXT_ID, CONTEXT_ID*));

#define SET_ACTIVE_CONTEXT_BY_ID(status,rr,newid,oldid) \
	{ 	APR_OPTIONAL_FN_TYPE(MC_SetActiveContextByID) *pfn=NULL; \
		pfn=APR_RETRIEVE_OPTIONAL_FN(MC_SetActiveContextByID); \
		status=0; \
		if(pfn!=NULL) { \
			status=pfn(rr,newid,oldid); \
			if(status==SSL_NOT_MULTICONTEXT) { \
				status=0; \
			}\
		/* else mod_ssl is not loaded so nothing to do*/ \
		} \
	}

#define SET_ACTIVE_CONTEXT_BY_NAME(status,rr,name,oldid) \
	{ 	APR_OPTIONAL_FN_TYPE(MC_SetActiveContextByID) *pfn=NULL; \
		pfn=APR_RETRIEVE_OPTIONAL_FN(MC_SetActiveContextByName); \
		status=0; \
		if(pfn!=NULL) { \
			status=pfn(rr,name,oldid); \
			if(status==MODSSL_MC_NOTMULTICONTEXT) { \
				status=0; \
			} \
		/* else mod_ssl is not loaded so nothing to do*/ \
		} \
	}



#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* MODULES_SSL_SSL_MULTICONTEXT_H_ */
