/*
 * mc_api.c
 *
 *  Created on: 15 Mar 2018
 *      Author: development
 *
 *      This is the implementation of the module API that allows
 *      other modules to call functions that set the active context
 *      that will be used for writing data. This is done using the
 *      Apache Portable Runtime optional functions mechanism as this
 *      module is optional. Therefore, should another module be written
 *      that uses these functions, it will safely handle the case that
 *      they are not loaded.
 *
 */



/*for optional functions, use
	APR_DECLARE_OPTIONAL_FN
	APR_RETRIEVE_OPTIONAL_FN
	APR_REGISTER_OPTIONAL_FN
*/

#include "ssl_multicontext.h"
#include "ssl_mc_private.h"

int
MC_SetActiveContextByName(
		conn_rec *pt_Conn,
		const char *cps_ContextName,
		CONTEXT_ID *puc_PreviousContext)
{
	int status;
	CONTEXT_ID uc_NewContext;

    SSLConnRec *pt_SslConn = myConnConfig(pt_Conn);
    SSL *pt_Ssl=pt_SslConn->ssl;

    if(mctls_IsMultiContext(pt_Ssl)) {
    	status=mctls_GetContextIdByName(pt_Ssl,cps_ContextName,&uc_NewContext);
    	if(status==0) {
    		status=mctls_SetActiveContext(pt_Ssl, uc_NewContext, puc_PreviousContext);
    	}
    } else {
    	status = MODSSL_MC_NOTMULTICONTEXT;
    }
    return status;
}

int
MC_SetActiveContextByID(
		conn_rec *pt_Conn,
		CONTEXT_ID uc_NewContext,
		CONTEXT_ID *puc_PreviousContext)
{
	int status;

    SSLConnRec *pt_SslConn = myConnConfig(pt_Conn);
    SSL *pt_Ssl=pt_SslConn->ssl;

    if(mctls_IsMultiContext(pt_Ssl)) {
   		status=mctls_SetActiveContext(pt_Ssl, uc_NewContext, puc_PreviousContext);
    } else {
    	status = MODSSL_MC_NOTMULTICONTEXT;
    }
    return status;
}
