/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "cs_datapath_filter.h"

#include "../ssl/ssl_multicontext.h"

int
csdatapath_ReceiveStartHeaders(conn_rec *pt_connReq)
{
	CONTEXT_ID oldid;
	int status;

	SET_ACTIVE_CONTEXT_BY_NAME(status,pt_connReq,"header",oldid);
	return status;
}

int
csdatapath_ReceiveStartBody(conn_rec *pt_connReq)
{
	CONTEXT_ID oldid;
	int status;

	SET_ACTIVE_CONTEXT_BY_NAME(status,pt_connReq,"body",oldid);
	return status;
}

int
csdatapath_SendStartHeaders(conn_rec *pt_connReq)
{
	CONTEXT_ID oldid;
	int status;

	SET_ACTIVE_CONTEXT_BY_NAME(status,pt_connReq,"header",oldid);
	return status;
}
int
csdatapath_SendStartBody(conn_rec *pt_connReq)
{
	CONTEXT_ID oldid;
	int status;

	SET_ACTIVE_CONTEXT_BY_NAME(status,pt_connReq,"body",oldid);
	return status;
}

csdatapath_RegisterFilters()
