/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MODULES_CONTEXTSPLIT_CS_CONFIG_H_
#define MODULES_CONTEXTSPLIT_CS_CONFIG_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "cs_datatypes.h"
#include "httpd.h"
#include "http_core.h"

cs_cfg *our_dconfig(const request_rec *cpt_R);
cs_cfg *our_sconfig(const server_rec *cpt_S);
cs_cfg *our_rconfig(const request_rec *cpt_R);
cs_cfg *our_cconfig(const conn_rec *cpt_C);

void *cs_create_dir_config(apr_pool_t *p, char *dirspec);
void *cs_merge_dir_config(apr_pool_t *p, void *pv_ParentConf,
                                      void *pv_NewlocConf);
void *cs_create_server_config(apr_pool_t *p, server_rec *pt_S);
void *cs_merge_server_config(apr_pool_t *p, void *pv_Server1Conf,
                                         void *pv_Server2Conf);


#ifdef __cplusplus
}
#endif

#endif /* MODULES_CONTEXTSPLIT_CS_CONFIG_H_ */
