# NGSI-LD PRIMER

The [ETSI GR CIM 008](https://www.etsi.org/deliver/etsi_gr/CIM/001_099/008/01.02.01_60/gr_cim008v010201p.pdf) (Primer from now on) is a document which provides an introduction, in particular for developers, on how the NGSI-LD API, defined in
[ETSI GS CIM 009](https://www.etsi.org/deliver/etsi_gs/CIM/001_099/009/01.07.01_60/gs_cim009v010701p.pdf), is used. The focus is on typical use and is based on a small NGSI-LD data model example,
where the data model conforms to the NGSI-LD information model. More information about the NGSI-LD information
model can be found in [ETSI GR CIM 006](https://www.etsi.org/deliver/etsi_gs/CIM/001_099/006/01.02.01_60/gs_cim006v010201p.pdf). 

In this folder, the following files are provided:
- **NGSI-LD-Primer_Examples_v.1.2.postman_collection.json**, which is a Postman Collection that contains all the requests used in the examples of the Primer. Developers can import it into Postman and use it to execute the requests while reading the Primer.

- **Environment_Primer.postman_environment.json**, which is the Postman Environment with all the variables expected by the Postman Collection.


## Local Deployment of a Context Broker

To run the examples of the Primer, it is **required** to have access to an NGSI-LD Context Broker. Context Brokers can be run locally following the guides provided by implementations. Usually, said guides can be found in the GitHub repository of the implementation itself in the form of Docker Compose files or set of commands to run in a terminal.

## Access to a Public Context Broker

A Public Context Broker deployment has been provided by a member of the ISG CIM group. Developers can get access to the Public Context Broker and run the examples of the Primer contacting the owners at the following email:

marco.cavalli@sferainnovazione.it

*PS: It is not guaranteed that the Public Context Broker will be available at all times. Also, the data stored in the Public Context Broker might be changed or deleted at any time. Developers should use it to execute simple tests before deciding to run a Context Broker locally.*