# VSCode / VSCodium

## Table of content

- [VSCode / VSCodium](#vscode--vscodium)
  - [Table of content](#table-of-content)
  - [VSCode vs VSCodium](#vscode-vs-vscodium)
  - [Nice to have plugins](#nice-to-have-plugins)
    - [Markdown Language Features (already built in)](#markdown-language-features-already-built-in)
    - [Markdown All in One](#markdown-all-in-one)
    - [Markdownlint](#markdownlint)
    - [Draw.io Integration](#drawio-integration)
    - [Markdown PDF](#markdown-pdf)
    - [PlantUML](#plantuml)
    - [Markdown Preview Github Styling](#markdown-preview-github-styling)
    - [Markdown shortcuts](#markdown-shortcuts)
    - [Markdown Snippets](#markdown-snippets)
    - [Snippets ranger](#snippets-ranger)
    - [Git Graph](#git-graph)
    - [Swagger viewer](#swagger-viewer)

## VSCode vs VSCodium

VSCode is nice, but you can also use it's open source counterpart with the same functionalities and without the tracking and telemetry functionalities.

## Nice to have plugins

### Markdown Language Features (already built in)

VSCode handles Markdown files by default.

### Markdown All in One

Extends the Markdown syntax and functionalities.

- It brings  
  - GitHub Flavored Markdown
  - Table of content (automated)
  - Section numbers management
  - Math
  - Keyboard shortcuts

### Markdownlint

Helps keeping consistancy accross documents.

- Can also be very annoying

### Draw.io Integration

- Allow to edit and render diagram.
- Provide the same functionality as the online or offline version of Diagrams.net.
<img src="images/VSCodeDiagram.io.jpg" alt="Diagram.io" width="1200"/>
- Missing feature: a way to generate automatically a picture of the diagram on file save.

### Markdown PDF

Allow to export Markdown documents in different formats (.pdf, .html, .png, .jpg )

### PlantUML

- Renders .puml files
- Configuration
  - Set Plantuml:ExportFormat to png
  - Set Plantuml:ExportOutDir to .
  - Uncheck Plantuml;ExportSubFolder
  - Set Plantuml:Java to C:\Program Files\Java\jre1.8.0_301\bin\java.exe
  - Set Plantuml:Render to local

<img src="images/VSCodePlantUML.jpg" alt="Diagram.io" width="1200"/>

Missing feature: no automated creation of the .png file. Need to right click on the file and choose "Export Current Diagram".

### Markdown Preview Github Styling

Render the Markdown file as they will look like in Github

### Markdown shortcuts

Create shortcuts for Markdown formatting

### Markdown Snippets

Add new snippets, especially to create tables.

### Snippets ranger

Allow to browse and edit all the default snippets.

Note : Call snippets from intelisense with CTRL + SPACE

### Git Graph
<img src="images/VSCodeGitGraph.jpg" alt="GitGraph" width="1200"/>

### Swagger viewer
Lets you preview and validate OpenAPI files.
<img src="images/VSCodeSwaggerViewer.jpg" alt="GitGraph" width="1200"/>