# Environment

The Authoring Process described here could be built from scratch, but in order to limit the work to be done, we will use the Unity 3D editor as a basis to develop the authoring tool.

Additional features will be provided through scripts.

# Use case model

##  Actors

*Trackable Author*: replicates the real world organization of the Trackables in a 3D representation that will be sent to the World Storage. A CAD model of the place or object to augment can be used in the authoring tool to easy the positioning of the Trackables. The Trackable Author work results in the storage in the World Storage of the Trackables needed to anchor a scene in the real world.

*World Anchor Author*: defines positions in the real world, called World Anchors, to attach AR assets that will augment the end user’s environment. The positions of the World Anchors are defined in relation with the Trackables. As for the Trackable Author a CAD model of the place or object to augment can be used in the authoring tool to easy the positioning of the World Anchors. The World Anchor Author work results in the creation in the World Storage of a World Graph defining the position to anchor AR assets

*AR scene Author*: position the AR assets to enhance a place or an object on top of the World graph defined by the Trackable Author and the World Anchor Author.

*Authentication Service*: ensures the authentication and unique identification of the different Authors to uniquely identify the content created and stored in the World Storage.

*Asset Preparation*: provides 3D models of objects or part of the world and prepared Trackables.

*World Storage*: stores the resulting authored World Graph made of Trackables and World Anchors relative positions.

*Content Hosting*: stores the AR scene graph and formatted AR assets that will be played in the runtime on the end user’s AR device.



World Storage, Asset Preparation and Content Hosting are function identified in the reference architecture.

![UseCaseModelV3.drawio](UseCaseModelV3.drawio.jpg)

# UC Setup Trackables

## Description

The Trackable Author, through the Authoring Process (AP), is going to place Trackables, in a 3D geometric representation of the real world, at the same place they are in the real world. The Trackables’ descriptions will then be stored in the World Storage for further use by the World Anchors Author and the AR Scene Author, or by the World Analysis function that will be requested by AR application to detect the relevant Trackables in the environment of the end user’s AR device.

## Pre-conditions

3D models of the real world places and objects are available in formats accepted by Unity 3D. They are prepared in an Asset Preparation function. In our case they will be prepared manually through a CAD software like Blender for example.

Trackables are provided in an arbitrary binary format. Description data are also provided. A 3D bounding box of the Trackables is provided to be inserted in the 3D representation of the real world in Unity 3D.

## Post-conditions

Trackables bounding boxes are geometrically placed in a 3D scene managed by the AP according to their position in the real world.

Trackables are store in the World Representation.

The unique identifier of each Trackable is created by the World Storage and share with the AP.

## Basic Scenario

1. Trackable Author: logs in
2. *Loop on 3D models*
3. Trackable Author: requests a geometric representation of the places or objects to augment.
4. Asset Preparation: returns the 3D models (in FBX format for example).
5. Trackable Author: loads the 3D models in a 3D scene in the Authoring Tool.
6. *End loop*
7. *Loop on Trackables*
8. Trackable Author: requests Trackables that have been added and can be searched in the real world.
9. Asset Preparation: returns Trackables.
10. Trackable Author: loads the Trackable and places the Trackable’s bounding boxes in the 3D scene in the Authoring Tool.
11. Authoring Tool: displays the 3D scene with the 3D model of the real world and Trackables bounding boxes.
12.  Trackable Author: moves and orients the bounding boxes of the Trackables in the scene to replicate their position and orientation in the real world.
13. Trackable Author: associates specific Key/value tag to the Trackables if needed
14. Authoring Tool: associates automatically specific Key/value tag to the Trackables (Author, organization, place…)
15. *End loop*
16. Loop on 3D models
17. Trackable Author: goes through every 3D model and associates a reference Trackable to it (This give the possibility making 3D CAD models and their pose available to other authors from the World Storage)
18. *End loop*
19. Trackable Author: press the save button of the Authoring interface
20. *Loop on Trackables*
21. Authoring Tool: sends the Trackables placed in the scene to the World Storage
22. World Storage: extract features from the Trackables and sends back the unique identifier of each Trackable,
23. *End loop*
24. Authoring Tool: associates the unique identifiers with the Trackables in the Unity 3D scene graph and saves the AR scene graph for further use.

![SEQ-SetupTrackables](SEQ-SetupTrackables.png)
