
- [Objectives](#objectives)
- [Associated workspaces](#associated-workspaces)
  - [Overview and fast access](#overview-and-fast-access)
  - [ETSI Forge](#etsi-forge)
  - [ETSI Lab](#etsi-lab)
  - [ETSI ISG ARF Sharepoint](#etsi-isg-arf-sharepoint)
- [Selected Tools](#selected-tools)
  - [Editors](#editors)
  - [OpenAPI tools](#openapi-tools)
  - [Development tools](#development-tools)
- [Branching Policy](#branching-policy)

# Objectives

This repository is dedicated to the development of the augmented reality framework (ARF) API (ETSI-ISG) for standardizing the exchanges with a World Storage. service. The API contains all the accees actions (REST) data (elements) needed to implement a World Representation with a World Graph.

# Associated workspaces

## Overview and fast access

Goto | ARF|STF|Other|Description
----------|---------|--|--|--
 [ETSI Portal](https://portal.etsi.org/home.aspx ) | yes | yes |-|Portal
 [Sharepoint Auth.](https://etsihq.sharepoint.com/:f:/s/Whitepapers/EoitUA6NUWtCkUe69C5x7Y4B-ctyOMXB6SX-jrR0oElYkw ) | yes | yes |-|Whitepapers|
 [Sharepoint ~~Auth.~~](https://etsihq.sharepoint.com/:f:/s/Whitepapers/EoitUA6NUWtCkUe69C5x7Y4B15QjoFl-a_wpimo0hs-Jrw  ) | yes | yes |-|Whitepapers|
 [Teams](https://teams.microsoft.com/) |-|yes|-|STF620
 [ETSI Forge](https://forge.etsi.org/rep/arf) | yes | yes |-|Specification
 [ETSI Lab](https://labs.etsi.org/rep/arf) |-| yes |-|Development



## ETSI Forge

Contains the source code and specification related to the World Storage API.

- Type internal (The group and any internal projects can be viewed by any user logged in w. EOL) can be made public when needed

**Maintainer**: Eric Villain

- [Access to the Forge](https://forge.etsi.org/rep/arf)

- [Access to the project: ARF005 – World Storage API](https://forge.etsi.org/rep/arf/arf005)

## ETSI Lab

Contains the source code and documentation related to the wrappers, the Unity plugin and the validation application. We will create an independent project for each item. A project called Management has already been created for administrative purpose.

- Type: Internal (The group and any internal projects can be viewed by any user logged in w. EOL) can be made public when needed

**Maintainer**: Patrick Harms

- [Access to the Lab](https://labs.etsi.org/rep/arf)

- [Access to the subgroup World Storage API Helpers](https://labs.etsi.org/rep/arf/world-storage-api-helpers)

## ETSI ISG ARF Sharepoint

Contains temporary office documents that are edited collaboratively and all other stuff that don’t fit in the Forge or the Lab.

- [Access with authentication](https://etsihq.sharepoint.com/:f:/s/Whitepapers/EoitUA6NUWtCkUe69C5x7Y4B-ctyOMXB6SX-jrR0oElYkw)

- [Access without authentication](https://etsihq.sharepoint.com/:f:/s/Whitepapers/EoitUA6NUWtCkUe69C5x7Y4B15QjoFl-a_wpimo0hs-Jrw)

# Selected Tools

## Editors

- General purpose editor
  - [VSCode](doc/VSCode.md)

- Diagram editor (especially for use case diagrams)
  - [Diagrams.net](http://diagrams.net)
    - GUI based, easy to build diagrams, almost no learning curve, nice PNG export, easy to modify, easy to change objects positions, online and offline version, free of charge, open source. Good documentation. Used by the group in the architecture definition phase.
    - Available plugin for VSCode
    - [Ofline version](https://github.com/jgraph/drawio-desktop/releases/tag/v15.4.0)

- Diagram editor (for sequence diagrams)
  - [PlantUML](https://plantuml.com)
    - Seems powerful (didn’t miss anything until now), small learning curve, modify with copy paste. Nicely rendered. Sometimes “compilation fails” but errors messages are explicit.
    - Available plugin for VSCode

## OpenAPI tools

- Swaggereditor
  - [ETSI REST API tools](https://forge.etsi.org/index.php/tools/rest-apis)
  - [Swagger Editor](https://forge.etsi.org/swagger/editor/)  

- API generation
  - [OpenAPI generator](https://openapi-generator.tech/)

- Codegen
  - [Swagger Codegen](https://swagger.io/tools/swagger-codegen/)
  - [Swagger Codegen documentation](https://swagger.io/docs/open-source-tools/swagger-codegen/)

## Development tools

- Visual Studio
- Visual Studio Code
- Unity 3D (Version 2020.3 LTS)

# Creating Server/Client Code

## Tool: openapi-generator

We recommand the usage of the open source command-line tool **openapi-generator** while it has a good compatibility to API v3.x and produces accurate source code, similar to Swagger.

Find a description here: https://openapi-generator.tech/docs/usage/

Install the tool with "npm", see: https://openapi-generator.tech/docs/installation/

### Help

> npx @openapitools/openapi-generator-cli help

### Validating the api

> npx @openapitools/openapi-generator-cli validate -i API/openapi.yaml

### Example C++ Server (Pistache)

> npx @openapitools/openapi-generator-cli generate -i API/openapi.yaml  -g cpp-pistache-server -o ./CodeGeneration/sever/cpp/pistache

### Example ASP.NET Server (C#)

> npx @openapitools/openapi-generator-cli generate -i API/openapi.yaml -g aspnetcore -o ./CodeGeneration/server/aspnetcore

### Example C# Client

> npx @openapitools/openapi-generator-cli generate -i API/openapi.yaml  -g csharp -o ./CodeGeneration/client/csharp

# Branching Policy
Distributed version control systems like Git offers developers great flexibility to share and manage code. But a branching policy is crucial to collaborate more easily while keeping track of releases with bug fixes.

We consider 5 categories of branches:
- **develop**: collects the different features. While it is recommended that this branch be as stable as possible, each commit is not considered as a release, but much more as a pre-release.
- **feature**: dedicated to the development of features (named ***feature/*** *featureName*). These feature branches allow to share code among developers working on a common feature. When a feature is implemented, it must be tested before merging it to the develop branch with a pull request. When a feature branch is merged into develop, it must be suppress from the reposiory. It is recommended that the develop branch be merged into the feature branches on a regular basis to avoid any drift.
- **master**: corresponds to the last version of stable code. The develop branch is merged in the master branch when a release is ready. Bug fixes from release branches are also merged is the master branch when useful.
- **release**: dedicated to the releases. One branch per minor version release must be created (named ***release/*** *major_minor_patch*), and a tag must be set. When a bug is fixed on a release, it should be merge is the release branch. Then a new tag is created by increasing the patch digit of the release version.
- **bug**: dedicated to the bug fix of releases (named ***bug/*** *bugID*).

<img src="./doc/images/BranchingPolicy.png" alt="Branching strategy" width="1200"/>




