#ifndef  CODEC_INC
#define  CODEC_INC
#include <t3devlib/t3devlib.h>

namespace t3devlib {
namespace gen {

typedef t3devlib::Charstring CallidString;
typedef t3devlib::Charstring ContentCoding;
typedef t3devlib::Charstring	DeltaSec;	// an external operation can handle this field
typedef t3devlib::Charstring LanguageTag;
typedef t3devlib::Charstring OptionTag;
typedef t3devlib::Charstring ServerVal;
typedef t3devlib::Charstring PAssertedServiceValue;
typedef t3devlib::Charstring PrivacyValue;
typedef t3devlib::Charstring EventType;
typedef t3devlib::Charstring SubState;
typedef t3devlib::Charstring PMediaAuthValue; //HEXDIG "0"-"9", "A"-"F"
typedef t3devlib::Charstring Raw;

// ! subtype of structured types !
#define SDP_contact_tel SDP_contact
#define SDP_contact_email SDP_contact
#define PAssertedIDValue Addr_Union
#define PPreferredIDValue Addr_Union

typedef t3devlib::Undef XmlBody;


// enumerated types
class FieldName : public t3devlib::Enum
{
private:
	static const char* msFields[];
public:
	FieldName() : Enum (msFields) {}

	const char* GetModuleName() const { return "LibSip_SIPTypesAndValues"; }
	const char* GetTypeName() const   { return "FieldName"; }

	void Encode (Buffer& buffer) throw (EncodeError);
	void Decode (Buffer& buffer) throw (DecodeError);
};

// enumerated types
class Method : public t3devlib::Enum
{
private:
	static const char* msSipMethods[];
	static const char* msMethodValues[];
public:
	Method() : Enum (msSipMethods) {}

	const char* GetModuleName() const { return "LibSip_SIPTypesAndValues"; }
	const char* GetTypeName() const   { return "Method"; }

	void Encode (Buffer& buffer) throw (EncodeError);
	void Decode (Buffer& buffer) throw (DecodeError);
};

// additional attributes
#define DEFINITIONS_Addr_Union()	int mPosition;

}} //namespaces

#endif   // ----- #ifndef CODEC_INC  -----

