ASN1_SRC   :=  $(wildcard *.asn)

ASN1_PDU := Ieee1609Dot2Data Certificate
#ASN1_KNOWN := DATE

#ASN1CDIR    ?= $(USERPROFILE)/Work/asn1c-fillabs
ifneq (,$(ASN1CDIR))
  ASN1C := $(ASN1CDIR)/asn1c/.libs/asn1c -S $(ASN1CDIR)/skeletons
else
  ASN1C := asn1c
endif

.PHONY: validate doc build

validate: iso build

doc: docs
	python3 asn2md.py -o docs $(ASN1_SRC)

iso docs:
	mkdir -p $@

build: $(ASN1_SRC) $(ASN1_SRC_VALIDATE)
	$(ASN1C) -E -F -fcompound-names $(addprefix -fknown-extern-type=,$(ASN1_KNOWN)) $(addprefix -pdu=,$(ASN1_PDU)) $^ >/dev/null
