# <a name="ITS-Container"></a>ASN.1 module ITS-Container
OID: _{ itu-t (0) identified-organization (4) etsi (0) itsDomain (5) wg1 (1) ts (102894) cdd (2) version (2) }_

## Data Elements:
### <a name="ItsPduHeader"></a>ItsPduHeader
```asn1
ItsPduHeader ::= SEQUENCE {
    protocolVersion INTEGER (0..255),
    messageID INTEGER{ denm(1), cam(2), poi(3), spatem(4), mapem(5), ivim(6), ev-rsr(7), tistpgtransaction(8), srem(9), ssem(10), evcsn(11), saem(12), rtcmem(13) } (0..255),  
    stationID StationID
}
```

### <a name="StationID"></a>StationID
```asn1
StationID ::= INTEGER(0..4294967295)
```

### <a name="ReferencePosition"></a>ReferencePosition
```asn1
ReferencePosition ::= SEQUENCE {
    latitude Latitude,
    longitude Longitude,
    positionConfidenceEllipse PosConfidenceEllipse ,
    altitude Altitude
}
```

### <a name="DeltaReferencePosition"></a>DeltaReferencePosition
```asn1
DeltaReferencePosition ::= SEQUENCE {
    deltaLatitude DeltaLatitude,
    deltaLongitude DeltaLongitude,
    deltaAltitude DeltaAltitude
}
```

### <a name="Longitude"></a>Longitude
```asn1
Longitude ::= INTEGER {oneMicrodegreeEast (10), oneMicrodegreeWest (-10), unavailable(1800000001)} (-1800000000..1800000001)
```

### <a name="Latitude"></a>Latitude
```asn1
Latitude ::= INTEGER {oneMicrodegreeNorth (10), oneMicrodegreeSouth (-10), unavailable(900000001)} (-900000000..900000001)
```

### <a name="Altitude"></a>Altitude
```asn1
Altitude ::= SEQUENCE {
    altitudeValue AltitudeValue,
    altitudeConfidence AltitudeConfidence
}
```

### <a name="AltitudeValue"></a>AltitudeValue
```asn1
AltitudeValue ::= INTEGER {referenceEllipsoidSurface(0), oneCentimeter(1), unavailable(800001)} (-100000..800001)
```

### <a name="AltitudeConfidence"></a>AltitudeConfidence
```asn1
AltitudeConfidence ::= ENUMERATED {
    alt-000-01 (0),
    alt-000-02 (1),
    alt-000-05 (2),
    alt-000-10 (3),
    alt-000-20 (4),
    alt-000-50 (5),
    alt-001-00 (6),
    alt-002-00 (7),
    alt-005-00 (8),
    alt-010-00 (9),
    alt-020-00 (10),
    alt-050-00 (11),
    alt-100-00 (12),
    alt-200-00 (13),
    outOfRange (14),
    unavailable (15)
}
```

### <a name="DeltaLongitude"></a>DeltaLongitude
```asn1
DeltaLongitude ::= INTEGER {oneMicrodegreeEast (10), oneMicrodegreeWest (-10), unavailable(131072)} (-131071..131072)
```

### <a name="DeltaLatitude"></a>DeltaLatitude
```asn1
DeltaLatitude ::= INTEGER {oneMicrodegreeNorth (10), oneMicrodegreeSouth (-10) , unavailable(131072)} (-131071..131072)
```

### <a name="DeltaAltitude"></a>DeltaAltitude
```asn1
DeltaAltitude ::= INTEGER {oneCentimeterUp (1), oneCentimeterDown (-1), unavailable(12800)} (-12700..12800)
```

### <a name="PosConfidenceEllipse"></a>PosConfidenceEllipse
```asn1
PosConfidenceEllipse ::= SEQUENCE {
    semiMajorConfidence SemiAxisLength,
    semiMinorConfidence SemiAxisLength,
    semiMajorOrientation HeadingValue
}
```

### <a name="PathPoint"></a>PathPoint
```asn1
PathPoint ::= SEQUENCE {
    pathPosition DeltaReferencePosition,
    pathDeltaTime PathDeltaTime OPTIONAL
}
```

### <a name="PathDeltaTime"></a>PathDeltaTime
```asn1
PathDeltaTime ::= INTEGER {tenMilliSecondsInPast(1)} (1..65535, ...)
```

### <a name="PtActivation"></a>PtActivation
```asn1
PtActivation ::= SEQUENCE {
    ptActivationType PtActivationType,
    ptActivationData PtActivationData
}
```

### <a name="PtActivationType"></a>PtActivationType
```asn1
PtActivationType ::= INTEGER {undefinedCodingType(0), r09-16CodingType(1), vdv-50149CodingType(2)} (0..255)
```

### <a name="PtActivationData"></a>PtActivationData
```asn1
PtActivationData ::= OCTET STRING (SIZE(1..20))
```

### <a name="AccelerationControl"></a>AccelerationControl
```asn1
AccelerationControl ::= BIT STRING {
    brakePedalEngaged (0),
    gasPedalEngaged (1),
    emergencyBrakeEngaged (2),
    collisionWarningEngaged (3),
    accEngaged (4),
    cruiseControlEngaged (5),
    speedLimiterEngaged (6)
} (SIZE(7))
```

### <a name="SemiAxisLength"></a>SemiAxisLength
```asn1
SemiAxisLength ::= INTEGER{oneCentimeter(1), outOfRange(4094), unavailable(4095)} (0..4095)
```

### <a name="CauseCode"></a>CauseCode
```asn1
CauseCode ::= SEQUENCE {
    causeCode CauseCodeType,
    subCauseCode SubCauseCodeType,
        ...
}
```

### <a name="CauseCodeType"></a>CauseCodeType
```asn1
CauseCodeType ::= INTEGER {
    reserved (0),
    trafficCondition (1),
    accident (2),
    roadworks (3),
        impassability (5),
    adverseWeatherCondition-Adhesion (6),
        aquaplannning (7),
    hazardousLocation-SurfaceCondition (9),
    hazardousLocation-ObstacleOnTheRoad (10),
    hazardousLocation-AnimalOnTheRoad (11),
    humanPresenceOnTheRoad (12),
    wrongWayDriving (14),
    rescueAndRecoveryWorkInProgress (15),
    adverseWeatherCondition-ExtremeWeatherCondition (17),
    adverseWeatherCondition-Visibility (18),
    adverseWeatherCondition-Precipitation (19),
    slowVehicle (26),
    dangerousEndOfQueue (27),
    vehicleBreakdown (91),
    postCrash (92),
    humanProblem (93),
    stationaryVehicle (94),
    emergencyVehicleApproaching (95),
    hazardousLocation-DangerousCurve (96),
    collisionRisk (97),
    signalViolation (98),
    dangerousSituation (99)
} (0..255)
```

### <a name="SubCauseCodeType"></a>SubCauseCodeType
```asn1
SubCauseCodeType ::= INTEGER (0..255)
```

### <a name="TrafficConditionSubCauseCode"></a>TrafficConditionSubCauseCode
```asn1
TrafficConditionSubCauseCode ::= INTEGER {unavailable(0), increasedVolumeOfTraffic(1), trafficJamSlowlyIncreasing(2), trafficJamIncreasing(3), trafficJamStronglyIncreasing(4), trafficStationary(5), trafficJamSlightlyDecreasing(6), trafficJamDecreasing(7), trafficJamStronglyDecreasing(8)} (0..255)
```

### <a name="AccidentSubCauseCode"></a>AccidentSubCauseCode
```asn1
AccidentSubCauseCode ::= INTEGER {unavailable(0), multiVehicleAccident(1), heavyAccident(2), accidentInvolvingLorry(3), accidentInvolvingBus(4), accidentInvolvingHazardousMaterials(5), accidentOnOppositeLane(6), unsecuredAccident(7), assistanceRequested(8)} (0..255)
```

### <a name="RoadworksSubCauseCode"></a>RoadworksSubCauseCode
```asn1
RoadworksSubCauseCode ::= INTEGER {unavailable(0), majorRoadworks(1), roadMarkingWork(2), slowMovingRoadMaintenance(3), shortTermStationaryRoadworks(4), streetCleaning(5), winterService(6)} (0..255)
```

### <a name="HumanPresenceOnTheRoadSubCauseCode"></a>HumanPresenceOnTheRoadSubCauseCode
```asn1
HumanPresenceOnTheRoadSubCauseCode ::= INTEGER {unavailable(0), childrenOnRoadway(1), cyclistOnRoadway(2), motorcyclistOnRoadway(3)} (0..255)
```

### <a name="WrongWayDrivingSubCauseCode"></a>WrongWayDrivingSubCauseCode
```asn1
WrongWayDrivingSubCauseCode ::= INTEGER {unavailable(0), wrongLane(1), wrongDirection(2)} (0..255)
```

### <a name="AdverseWeatherCondition-ExtremeWeatherConditionSubCauseCode"></a>AdverseWeatherCondition-ExtremeWeatherConditionSubCauseCode
```asn1
AdverseWeatherCondition-ExtremeWeatherConditionSubCauseCode ::= INTEGER {unavailable(0), strongWinds(1), damagingHail(2), hurricane(3), thunderstorm(4), tornado(5), blizzard(6)} (0..255)
```

### <a name="AdverseWeatherCondition-AdhesionSubCauseCode"></a>AdverseWeatherCondition-AdhesionSubCauseCode
```asn1
AdverseWeatherCondition-AdhesionSubCauseCode ::= INTEGER {unavailable(0), heavyFrostOnRoad(1), fuelOnRoad(2), mudOnRoad(3), snowOnRoad(4), iceOnRoad(5), blackIceOnRoad(6), oilOnRoad(7), looseChippings(8), instantBlackIce(9), roadsSalted(10)} (0..255)
```

### <a name="AdverseWeatherCondition-VisibilitySubCauseCode"></a>AdverseWeatherCondition-VisibilitySubCauseCode
```asn1
AdverseWeatherCondition-VisibilitySubCauseCode ::= INTEGER {unavailable(0), fog(1), smoke(2), heavySnowfall(3), heavyRain(4), heavyHail(5), lowSunGlare(6), sandstorms(7), swarmsOfInsects(8)} (0..255)
```

### <a name="AdverseWeatherCondition-PrecipitationSubCauseCode"></a>AdverseWeatherCondition-PrecipitationSubCauseCode
```asn1
AdverseWeatherCondition-PrecipitationSubCauseCode ::= INTEGER {unavailable(0), heavyRain(1), heavySnowfall(2), softHail(3)} (0..255)
```

### <a name="SlowVehicleSubCauseCode"></a>SlowVehicleSubCauseCode
```asn1
SlowVehicleSubCauseCode ::= INTEGER {unavailable(0), maintenanceVehicle(1), vehiclesSlowingToLookAtAccident(2), abnormalLoad(3), abnormalWideLoad(4), convoy(5), snowplough(6), deicing(7), saltingVehicles(8)} (0..255)
```

### <a name="StationaryVehicleSubCauseCode"></a>StationaryVehicleSubCauseCode
```asn1
StationaryVehicleSubCauseCode ::= INTEGER {unavailable(0), humanProblem(1), vehicleBreakdown(2), postCrash(3), publicTransportStop(4), carryingDangerousGoods(5)} (0..255)
```

### <a name="HumanProblemSubCauseCode"></a>HumanProblemSubCauseCode
```asn1
HumanProblemSubCauseCode ::= INTEGER {unavailable(0), glycemiaProblem(1), heartProblem(2)} (0..255)
```

### <a name="EmergencyVehicleApproachingSubCauseCode"></a>EmergencyVehicleApproachingSubCauseCode
```asn1
EmergencyVehicleApproachingSubCauseCode ::= INTEGER {unavailable(0), emergencyVehicleApproaching(1), prioritizedVehicleApproaching(2)} (0..255)
```

### <a name="HazardousLocation-DangerousCurveSubCauseCode"></a>HazardousLocation-DangerousCurveSubCauseCode
```asn1
HazardousLocation-DangerousCurveSubCauseCode ::= INTEGER {unavailable(0), dangerousLeftTurnCurve(1), dangerousRightTurnCurve(2), multipleCurvesStartingWithUnknownTurningDirection(3), multipleCurvesStartingWithLeftTurn(4), multipleCurvesStartingWithRightTurn(5)} (0..255)
```

### <a name="HazardousLocation-SurfaceConditionSubCauseCode"></a>HazardousLocation-SurfaceConditionSubCauseCode
```asn1
HazardousLocation-SurfaceConditionSubCauseCode ::= INTEGER {unavailable(0), rockfalls(1), earthquakeDamage(2), sewerCollapse(3), subsidence(4), snowDrifts(5), stormDamage(6), burstPipe(7), volcanoEruption(8), fallingIce(9)} (0..255)
```

### <a name="HazardousLocation-ObstacleOnTheRoadSubCauseCode"></a>HazardousLocation-ObstacleOnTheRoadSubCauseCode
```asn1
HazardousLocation-ObstacleOnTheRoadSubCauseCode ::= INTEGER {unavailable(0), shedLoad(1), partsOfVehicles(2), partsOfTyres(3), bigObjects(4), fallenTrees(5), hubCaps(6), waitingVehicles(7)} (0..255)
```

### <a name="HazardousLocation-AnimalOnTheRoadSubCauseCode"></a>HazardousLocation-AnimalOnTheRoadSubCauseCode
```asn1
HazardousLocation-AnimalOnTheRoadSubCauseCode ::= INTEGER {unavailable(0), wildAnimals(1), herdOfAnimals(2), smallAnimals(3), largeAnimals(4)} (0..255)
```

### <a name="CollisionRiskSubCauseCode"></a>CollisionRiskSubCauseCode
```asn1
CollisionRiskSubCauseCode ::= INTEGER {unavailable(0), longitudinalCollisionRisk(1), crossingCollisionRisk(2), lateralCollisionRisk(3), vulnerableRoadUser(4)} (0..255)
```

### <a name="SignalViolationSubCauseCode"></a>SignalViolationSubCauseCode
```asn1
SignalViolationSubCauseCode ::= INTEGER {unavailable(0), stopSignViolation(1), trafficLightViolation(2), turningRegulationViolation(3)} (0..255)
```

### <a name="RescueAndRecoveryWorkInProgressSubCauseCode"></a>RescueAndRecoveryWorkInProgressSubCauseCode
```asn1
RescueAndRecoveryWorkInProgressSubCauseCode ::= INTEGER {unavailable(0), emergencyVehicles(1), rescueHelicopterLanding(2), policeActivityOngoing(3), medicalEmergencyOngoing(4), childAbductionInProgress(5)} (0..255)
```

### <a name="DangerousEndOfQueueSubCauseCode"></a>DangerousEndOfQueueSubCauseCode
```asn1
DangerousEndOfQueueSubCauseCode ::= INTEGER {unavailable(0), suddenEndOfQueue(1), queueOverHill(2), queueAroundBend(3), queueInTunnel(4)} (0..255)
```

### <a name="DangerousSituationSubCauseCode"></a>DangerousSituationSubCauseCode
```asn1
DangerousSituationSubCauseCode ::= INTEGER {unavailable(0), emergencyElectronicBrakeEngaged(1), preCrashSystemEngaged(2), espEngaged(3), absEngaged(4), aebEngaged(5), brakeWarningEngaged(6), collisionRiskWarningEngaged(7)} (0..255)
```

### <a name="VehicleBreakdownSubCauseCode"></a>VehicleBreakdownSubCauseCode
```asn1
VehicleBreakdownSubCauseCode ::= INTEGER {unavailable(0), lackOfFuel (1), lackOfBatteryPower (2), engineProblem(3), transmissionProblem(4), engineCoolingProblem(5), brakingSystemProblem(6), steeringProblem(7), tyrePuncture(8), tyrePressureProblem(9)} (0..255)
```

### <a name="PostCrashSubCauseCode"></a>PostCrashSubCauseCode
```asn1
PostCrashSubCauseCode ::= INTEGER {unavailable(0), accidentWithoutECallTriggered (1), accidentWithECallManuallyTriggered (2), accidentWithECallAutomaticallyTriggered (3), accidentWithECallTriggeredWithoutAccessToCellularNetwork(4)} (0..255)
```

### <a name="Curvature"></a>Curvature
```asn1
Curvature ::= SEQUENCE {
 curvatureValue CurvatureValue,
 curvatureConfidence CurvatureConfidence
}
```

### <a name="CurvatureValue"></a>CurvatureValue
```asn1
CurvatureValue ::= INTEGER {straight(0), unavailable(1023)} (-1023..1023)
```

### <a name="CurvatureConfidence"></a>CurvatureConfidence
```asn1
CurvatureConfidence ::= ENUMERATED {
    onePerMeter-0-00002 (0),
    onePerMeter-0-0001 (1),
    onePerMeter-0-0005 (2),
    onePerMeter-0-002 (3),
    onePerMeter-0-01 (4),
    onePerMeter-0-1 (5),
    outOfRange (6),
    unavailable (7)
}
```

### <a name="CurvatureCalculationMode"></a>CurvatureCalculationMode
```asn1
CurvatureCalculationMode ::= ENUMERATED {yawRateUsed(0), yawRateNotUsed(1), unavailable(2), ...}
```

### <a name="Heading"></a>Heading
```asn1
Heading ::= SEQUENCE {
    headingValue HeadingValue,
    headingConfidence HeadingConfidence
}
```

### <a name="HeadingValue"></a>HeadingValue
```asn1
HeadingValue ::= INTEGER {wgs84North(0), wgs84East(900), wgs84South(1800), wgs84West(2700), unavailable(3601)} (0..3601)
```

### <a name="HeadingConfidence"></a>HeadingConfidence
```asn1
HeadingConfidence ::= INTEGER {equalOrWithinZeroPointOneDegree (1), equalOrWithinOneDegree (10), outOfRange(126), unavailable(127)} (1..127)
```

### <a name="LanePosition"></a>LanePosition
```asn1
LanePosition ::= INTEGER {offTheRoad(-1), innerHardShoulder(0),
innermostDrivingLane(1), secondLaneFromInside(2), outerHardShoulder(14) } (-1..14)
```

### <a name="ClosedLanes"></a>ClosedLanes
```asn1
ClosedLanes ::= SEQUENCE {
    innerhardShoulderStatus HardShoulderStatus OPTIONAL,
        outerhardShoulderStatus HardShoulderStatus OPTIONAL,
    drivingLaneStatus DrivingLaneStatus OPTIONAL,
    ...
}
```

### <a name="HardShoulderStatus"></a>HardShoulderStatus
```asn1
HardShoulderStatus ::= ENUMERATED {availableForStopping(0), closed(1), availableForDriving(2)}
```

### <a name="DrivingLaneStatus"></a>DrivingLaneStatus
```asn1
DrivingLaneStatus ::= BIT STRING (SIZE (1..13))
```

### <a name="PerformanceClass"></a>PerformanceClass
```asn1
PerformanceClass ::= INTEGER {unavailable(0), performanceClassA(1), performanceClassB(2)} (0..7)
```

### <a name="SpeedValue"></a>SpeedValue
```asn1
SpeedValue ::= INTEGER {standstill(0), oneCentimeterPerSec(1), unavailable(16383)} (0..16383)
```

### <a name="SpeedConfidence"></a>SpeedConfidence
```asn1
SpeedConfidence ::= INTEGER {equalOrWithinOneCentimeterPerSec(1), equalOrWithinOneMeterPerSec(100), outOfRange(126), unavailable(127)} (1..127)
```

### <a name="VehicleMass"></a>VehicleMass
```asn1
VehicleMass ::= INTEGER {hundredKg(1), unavailable(1024)} (1..1024)
```

### <a name="Speed"></a>Speed
```asn1
Speed ::= SEQUENCE {
    speedValue SpeedValue,
    speedConfidence SpeedConfidence
}
```

### <a name="DriveDirection"></a>DriveDirection
```asn1
DriveDirection ::= ENUMERATED {forward (0), backward (1), unavailable (2)}
```

### <a name="EmbarkationStatus"></a>EmbarkationStatus
```asn1
EmbarkationStatus ::= BOOLEAN
```

### <a name="LongitudinalAcceleration"></a>LongitudinalAcceleration
```asn1
LongitudinalAcceleration ::= SEQUENCE {
    longitudinalAccelerationValue LongitudinalAccelerationValue,
    longitudinalAccelerationConfidence AccelerationConfidence
}
```

### <a name="LongitudinalAccelerationValue"></a>LongitudinalAccelerationValue
```asn1
LongitudinalAccelerationValue ::= INTEGER {pointOneMeterPerSecSquaredForward(1), pointOneMeterPerSecSquaredBackward(-1), unavailable(161)} (-160 .. 161)
```

### <a name="AccelerationConfidence"></a>AccelerationConfidence
```asn1
AccelerationConfidence ::= INTEGER {pointOneMeterPerSecSquared(1), outOfRange(101), unavailable(102)} (0 .. 102)
```

### <a name="LateralAcceleration"></a>LateralAcceleration
```asn1
LateralAcceleration ::= SEQUENCE {
    lateralAccelerationValue LateralAccelerationValue,
    lateralAccelerationConfidence AccelerationConfidence
}
```

### <a name="LateralAccelerationValue"></a>LateralAccelerationValue
```asn1
LateralAccelerationValue ::= INTEGER {pointOneMeterPerSecSquaredToRight(-1), pointOneMeterPerSecSquaredToLeft(1), unavailable(161)} (-160 .. 161)
```

### <a name="VerticalAcceleration"></a>VerticalAcceleration
```asn1
VerticalAcceleration ::= SEQUENCE {
    verticalAccelerationValue VerticalAccelerationValue,
    verticalAccelerationConfidence AccelerationConfidence
}
```

### <a name="VerticalAccelerationValue"></a>VerticalAccelerationValue
```asn1
VerticalAccelerationValue ::= INTEGER {pointOneMeterPerSecSquaredUp(1), pointOneMeterPerSecSquaredDown(-1), unavailable(161)} (-160 .. 161)
```

### <a name="StationType"></a>StationType
```asn1
StationType ::= INTEGER {unknown(0), pedestrian(1), cyclist(2), moped(3), motorcycle(4), passengerCar(5), bus(6), 
lightTruck(7), heavyTruck(8), trailer(9), specialVehicles(10), tram(11), roadSideUnit(15)} (0..255)
```

### <a name="ExteriorLights"></a>ExteriorLights
```asn1
ExteriorLights ::= BIT STRING {
    lowBeamHeadlightsOn      (0),
    highBeamHeadlightsOn     (1),
    leftTurnSignalOn         (2),
    rightTurnSignalOn        (3),
    daytimeRunningLightsOn   (4),
    reverseLightOn           (5),
    fogLightOn               (6),
    parkingLightsOn          (7)
} (SIZE(8))
```

### <a name="DangerousGoodsBasic"></a>DangerousGoodsBasic
```asn1
DangerousGoodsBasic::= ENUMERATED {
    explosives1(0),
    explosives2(1),
    explosives3(2),
    explosives4(3),
    explosives5(4),
    explosives6(5),
    flammableGases(6),
    nonFlammableGases(7),
    toxicGases(8),
    flammableLiquids(9),
    flammableSolids(10),
    substancesLiableToSpontaneousCombustion(11),
    substancesEmittingFlammableGasesUponContactWithWater(12),
    oxidizingSubstances(13),
    organicPeroxides(14),
    toxicSubstances(15),
    infectiousSubstances(16),
    radioactiveMaterial(17),
    corrosiveSubstances(18),
    miscellaneousDangerousSubstances(19)
}
```

### <a name="DangerousGoodsExtended"></a>DangerousGoodsExtended
```asn1
DangerousGoodsExtended ::= SEQUENCE {
    dangerousGoodsType DangerousGoodsBasic,
    unNumber INTEGER (0..9999),
    elevatedTemperature BOOLEAN,
    tunnelsRestricted BOOLEAN,
    limitedQuantity BOOLEAN,
    emergencyActionCode IA5String (SIZE (1..24)) OPTIONAL,
    phoneNumber PhoneNumber OPTIONAL,
    companyName UTF8String (SIZE (1..24)) OPTIONAL,
        ...
}
```

### <a name="SpecialTransportType"></a>SpecialTransportType
```asn1
SpecialTransportType ::= BIT STRING {heavyLoad(0), excessWidth(1), excessLength(2), excessHeight(3)} (SIZE(4))
```

### <a name="LightBarSirenInUse"></a>LightBarSirenInUse
```asn1
LightBarSirenInUse ::= BIT STRING {
    lightBarActivated (0),
    sirenActivated (1)
} (SIZE(2))
```

### <a name="HeightLonCarr"></a>HeightLonCarr
```asn1
HeightLonCarr ::= INTEGER {oneCentimeter(1), unavailable(100)} (1..100)
```

### <a name="PosLonCarr"></a>PosLonCarr
```asn1
PosLonCarr ::= INTEGER {oneCentimeter(1), unavailable(127)} (1..127)
```

### <a name="PosPillar"></a>PosPillar
```asn1
PosPillar ::= INTEGER {tenCentimeters(1), unavailable(30)} (1..30)
```

### <a name="PosCentMass"></a>PosCentMass
```asn1
PosCentMass ::= INTEGER {tenCentimeters(1), unavailable(63)} (1..63)
```

### <a name="RequestResponseIndication"></a>RequestResponseIndication
```asn1
RequestResponseIndication ::= ENUMERATED {request(0), response(1)}
```

### <a name="SpeedLimit"></a>SpeedLimit
```asn1
SpeedLimit ::= INTEGER {oneKmPerHour(1)} (1..255)
```

### <a name="StationarySince"></a>StationarySince
```asn1
StationarySince ::= ENUMERATED {lessThan1Minute(0), lessThan2Minutes(1), lessThan15Minutes(2), equalOrGreater15Minutes(3)}
```

### <a name="Temperature"></a>Temperature
```asn1
Temperature ::= INTEGER {equalOrSmallerThanMinus60Deg (-60), oneDegreeCelsius(1), equalOrGreaterThan67Deg(67)} (-60..67)
```

### <a name="TrafficRule"></a>TrafficRule
```asn1
TrafficRule ::= ENUMERATED {noPassing(0), noPassingForTrucks(1), passToRight(2), passToLeft(3), ...
}
```

### <a name="WheelBaseVehicle"></a>WheelBaseVehicle
```asn1
WheelBaseVehicle ::= INTEGER {tenCentimeters(1), unavailable(127)} (1..127)
```

### <a name="TurningRadius"></a>TurningRadius
```asn1
TurningRadius ::= INTEGER {point4Meters(1), unavailable(255)} (1..255)
```

### <a name="PosFrontAx"></a>PosFrontAx
```asn1
PosFrontAx ::= INTEGER {tenCentimeters(1), unavailable(20)} (1..20)
```

### <a name="PositionOfOccupants"></a>PositionOfOccupants
```asn1
PositionOfOccupants ::= BIT STRING {
    row1LeftOccupied (0),
    row1RightOccupied (1),
    row1MidOccupied (2),
    row1NotDetectable (3),
    row1NotPresent (4),
    row2LeftOccupied (5),
    row2RightOccupied (6),
    row2MidOccupied (7),
    row2NotDetectable (8),
    row2NotPresent (9),
    row3LeftOccupied (10),
    row3RightOccupied (11),
    row3MidOccupied (12),
    row3NotDetectable (13),
    row3NotPresent (14),
    row4LeftOccupied (15),
    row4RightOccupied (16),
    row4MidOccupied (17),
    row4NotDetectable (18),
    row4NotPresent (19)} (SIZE(20))
```

### <a name="PositioningSolutionType"></a>PositioningSolutionType
```asn1
PositioningSolutionType ::= ENUMERATED {noPositioningSolution(0), sGNSS(1), dGNSS(2), sGNSSplusDR(3), dGNSSplusDR(4), dR(5), ...}
```

### <a name="VehicleIdentification"></a>VehicleIdentification
```asn1
VehicleIdentification ::= SEQUENCE {
    wMInumber WMInumber OPTIONAL,
    vDS VDS OPTIONAL,
    ...
}
```

### <a name="WMInumber"></a>WMInumber
```asn1
WMInumber ::= IA5String (SIZE(1..3))
```

### <a name="VDS"></a>VDS
```asn1
VDS ::= IA5String (SIZE(6))
```

### <a name="EnergyStorageType"></a>EnergyStorageType
```asn1
EnergyStorageType ::= BIT STRING {hydrogenStorage(0), electricEnergyStorage(1), liquidPropaneGas(2), compressedNaturalGas(3), diesel(4), gasoline(5), ammonia(6)} (SIZE(7))
```

### <a name="VehicleLength"></a>VehicleLength
```asn1
VehicleLength ::= SEQUENCE {
    vehicleLengthValue VehicleLengthValue,
    vehicleLengthConfidenceIndication VehicleLengthConfidenceIndication
}
```

### <a name="VehicleLengthValue"></a>VehicleLengthValue
```asn1
VehicleLengthValue ::= INTEGER {tenCentimeters(1), outOfRange(1022), unavailable(1023)}  (1..1023)
```

### <a name="VehicleLengthConfidenceIndication"></a>VehicleLengthConfidenceIndication
```asn1
VehicleLengthConfidenceIndication ::= ENUMERATED {noTrailerPresent(0), trailerPresentWithKnownLength(1), trailerPresentWithUnknownLength(2), trailerPresenceIsUnknown(3), unavailable(4)}
```

### <a name="VehicleWidth"></a>VehicleWidth
```asn1
VehicleWidth ::= INTEGER {tenCentimeters(1), outOfRange(61), unavailable(62)} (1..62)
```

### <a name="PathHistory"></a>PathHistory
```asn1
PathHistory::= SEQUENCE (SIZE(0..40)) OF PathPoint
```

### <a name="EmergencyPriority"></a>EmergencyPriority
```asn1
EmergencyPriority ::= BIT STRING {requestForRightOfWay(0), requestForFreeCrossingAtATrafficLight(1)} (SIZE(2))
```

### <a name="InformationQuality"></a>InformationQuality
```asn1
InformationQuality ::= INTEGER {unavailable(0), lowest(1), highest(7)} (0..7)
```

### <a name="RoadType"></a>RoadType
```asn1
RoadType ::= ENUMERATED {
    urban-NoStructuralSeparationToOppositeLanes(0),
    urban-WithStructuralSeparationToOppositeLanes(1),
    nonUrban-NoStructuralSeparationToOppositeLanes(2),
    nonUrban-WithStructuralSeparationToOppositeLanes(3)}
```

### <a name="SteeringWheelAngle"></a>SteeringWheelAngle
```asn1
SteeringWheelAngle ::= SEQUENCE {
    steeringWheelAngleValue SteeringWheelAngleValue,
    steeringWheelAngleConfidence SteeringWheelAngleConfidence
}
```

### <a name="SteeringWheelAngleValue"></a>SteeringWheelAngleValue
```asn1
SteeringWheelAngleValue ::= INTEGER {straight(0), onePointFiveDegreesToRight(-1), onePointFiveDegreesToLeft(1), unavailable(512)} (-511..512)
```

### <a name="SteeringWheelAngleConfidence"></a>SteeringWheelAngleConfidence
```asn1
SteeringWheelAngleConfidence ::= INTEGER {equalOrWithinOnePointFiveDegree (1), outOfRange(126), unavailable(127)} (1..127)
```

### <a name="TimestampIts"></a>TimestampIts
```asn1
TimestampIts ::= INTEGER {utcStartOf2004(0), oneMillisecAfterUTCStartOf2004(1)} (0..4398046511103)
```

### <a name="VehicleRole"></a>VehicleRole
```asn1
VehicleRole ::= ENUMERATED {default(0), publicTransport(1), specialTransport(2), dangerousGoods(3), roadWork(4), rescue(5), emergency(6), safetyCar(7), agriculture(8), commercial(9), military(10), roadOperator(11), taxi(12), reserved1(13), reserved2(14), reserved3(15)}
```

### <a name="YawRate"></a>YawRate
```asn1
YawRate::= SEQUENCE {
    yawRateValue YawRateValue,
    yawRateConfidence YawRateConfidence
}
```

### <a name="YawRateValue"></a>YawRateValue
```asn1
YawRateValue ::= INTEGER {straight(0), degSec-000-01ToRight(-1), degSec-000-01ToLeft(1), unavailable(32767)} (-32766..32767)
```

### <a name="YawRateConfidence"></a>YawRateConfidence
```asn1
YawRateConfidence ::= ENUMERATED {
    degSec-000-01 (0),
    degSec-000-05 (1),
    degSec-000-10 (2),
    degSec-001-00 (3),
    degSec-005-00 (4),
    degSec-010-00 (5),
    degSec-100-00 (6),
    outOfRange (7),
    unavailable (8)
}
```

### <a name="ProtectedZoneType"></a>ProtectedZoneType
```asn1
ProtectedZoneType::= ENUMERATED { permanentCenDsrcTolling (0), ..., temporaryCenDsrcTolling (1) }
```

### <a name="RelevanceDistance"></a>RelevanceDistance
```asn1
RelevanceDistance ::= ENUMERATED {lessThan50m(0), lessThan100m(1), lessThan200m(2), lessThan500m(3), lessThan1000m(4), lessThan5km(5), lessThan10km(6), over10km(7)}
```

### <a name="RelevanceTrafficDirection"></a>RelevanceTrafficDirection
```asn1
RelevanceTrafficDirection ::= ENUMERATED {allTrafficDirections(0), upstreamTraffic(1), downstreamTraffic(2), oppositeTraffic(3)}
```

### <a name="TransmissionInterval"></a>TransmissionInterval
```asn1
TransmissionInterval ::= INTEGER {oneMilliSecond(1), tenSeconds(10000)} (1..10000)
```

### <a name="ValidityDuration"></a>ValidityDuration
```asn1
ValidityDuration ::=    INTEGER {timeOfDetection(0), oneSecondAfterDetection(1)} (0..86400)
```

### <a name="ActionID"></a>ActionID
```asn1
ActionID ::= SEQUENCE {
    originatingStationID StationID,
    sequenceNumber SequenceNumber
}
```

### <a name="ItineraryPath"></a>ItineraryPath
```asn1
ItineraryPath ::= SEQUENCE SIZE(1..40) OF ReferencePosition
```

### <a name="ProtectedCommunicationZone"></a>ProtectedCommunicationZone
```asn1
ProtectedCommunicationZone ::= SEQUENCE {
    protectedZoneType       ProtectedZoneType,
    expiryTime TimestampIts OPTIONAL,
    protectedZoneLatitude   Latitude,
    protectedZoneLongitude  Longitude,
    protectedZoneRadius ProtectedZoneRadius OPTIONAL,
    protectedZoneID ProtectedZoneID OPTIONAL,
        ...
}
```

### <a name="Traces"></a>Traces
```asn1
Traces ::= SEQUENCE SIZE(1..7) OF PathHistory
```

### <a name="NumberOfOccupants"></a>NumberOfOccupants
```asn1
NumberOfOccupants ::= INTEGER {oneOccupant (1), unavailable(127)} (0 .. 127)
```

### <a name="SequenceNumber"></a>SequenceNumber
```asn1
SequenceNumber ::=  INTEGER (0..65535)
```

### <a name="PositionOfPillars"></a>PositionOfPillars
```asn1
PositionOfPillars ::= SEQUENCE (SIZE(1..3, ...)) OF PosPillar
```

### <a name="RestrictedTypes"></a>RestrictedTypes
```asn1
RestrictedTypes ::= SEQUENCE (SIZE(1..3, ...)) OF StationType
```

### <a name="EventHistory"></a>EventHistory
```asn1
EventHistory::= SEQUENCE (SIZE(1..23)) OF EventPoint
```

### <a name="EventPoint"></a>EventPoint
```asn1
EventPoint ::= SEQUENCE {
    eventPosition DeltaReferencePosition,
    eventDeltaTime PathDeltaTime OPTIONAL,
    informationQuality InformationQuality
}
```

### <a name="ProtectedCommunicationZonesRSU"></a>ProtectedCommunicationZonesRSU
```asn1
ProtectedCommunicationZonesRSU ::= SEQUENCE (SIZE(1..16)) OF ProtectedCommunicationZone
```

### <a name="CenDsrcTollingZone"></a>CenDsrcTollingZone
```asn1
CenDsrcTollingZone ::= SEQUENCE {
    protectedZoneLatitude Latitude,
    protectedZoneLongitude Longitude,
    cenDsrcTollingZoneID CenDsrcTollingZoneID OPTIONAL,
        ...
}
```

### <a name="ProtectedZoneRadius"></a>ProtectedZoneRadius
```asn1
ProtectedZoneRadius ::= INTEGER {oneMeter(1)} (1..255,...)
```

### <a name="ProtectedZoneID"></a>ProtectedZoneID
```asn1
ProtectedZoneID ::= INTEGER (0.. 134217727)
```

### <a name="CenDsrcTollingZoneID"></a>CenDsrcTollingZoneID
```asn1
CenDsrcTollingZoneID ::= ProtectedZoneID
```

### <a name="DigitalMap"></a>DigitalMap
```asn1
DigitalMap ::= SEQUENCE (SIZE(1..256)) OF ReferencePosition
```

### <a name="OpeningDaysHours"></a>OpeningDaysHours
```asn1
OpeningDaysHours ::= UTF8String
```

### <a name="PhoneNumber"></a>PhoneNumber
```asn1
PhoneNumber ::= NumericString (SIZE(1..16))
```



