/**
 * @author      ETSI / STF462 / Alexandre Berge
 * @version     $$URL$$
 *              $$Id$$
 */
package org.etsi.ttcn.codec.its.v2g;

import org.etsi.ttcn.codec.CodecBuffer;
import org.etsi.ttcn.codec.MainCodec;
import org.etsi.ttcn.codec.generic.Union;
import org.etsi.ttcn.tci.Type;

public class Sdp_Payload extends Union {

    public Sdp_Payload(MainCodec mainCodec) {
        super(mainCodec);
    }

    @Override
    protected void preDecode(CodecBuffer buf, Type decodingHypothesis) {
        
        String variant = "";
        switch(buf.getNbBytes()) {
        case 2:
            variant = "sdpRequest";
            break;
        case 20:
            variant = "sdpResponse";
            break;
        default:
            System.err.println("Unable to decode " + decodingHypothesis.getName());
            return;
        }
        mainCodec.setHint(decodingHypothesis.getName(), variant);
    }    
}
