package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class PolygonalRegion extends WaveElement implements
		de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.PolygonalRegion {

	// ---- fields ----

	@Internal(order = 0)
	private TwoDLocation[] polygonalRegion;

	// ---- constructors ----

	public PolygonalRegion(TwoDLocation[] polygon) {
		setPolygonalRegion(polygon);
	}

	public PolygonalRegion(DataInputStream in) throws IOException {
		polygonalRegion = (TwoDLocation[]) WaveUtils.getArrayFromStream(in, TwoDLocation.class);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public TwoDLocation[] getPolygonalRegion() {
		if (polygonalRegion.length < 3)
			throw new IllegalArgumentException("The number of polygonal points shall not below 3!");
		if (this.polygonalRegion.length > 12)
			throw new IllegalArgumentException("The number of polygonal points shall not exceed 12!");
		return this.polygonalRegion;
	}

	// ---- setter ----

	public void setPolygonalRegion(TwoDLocation[] polygonalRegion) {
		if (polygonalRegion.length < 3)
			throw new IllegalArgumentException("The number of polygonal points shall not below 3!");
		if (polygonalRegion.length > 12)
			throw new IllegalArgumentException("The number of polygonal points shall not exceed 12!");
		this.polygonalRegion = polygonalRegion;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (polygonalRegion == null)
			throw new IllegalArgumentException("The polygonalRegion must not be null!");
		return WaveUtils.writeArrayToStream(out, getPolygonalRegion());
	}
}