package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import org.apache.commons.codec.binary.Hex;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class ItsAidSsp extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private IntX itsAid;

	@Internal(order = 1)
	private Opaque serviceSpecificPermissions;

	// ---- constructors ----

	public ItsAidSsp() {
	}

	public ItsAidSsp(long itsAid, byte[] serviceSpecificPermissions) {
		this.itsAid = new IntX(itsAid);
		this.serviceSpecificPermissions = new Opaque(serviceSpecificPermissions);
	}

	public ItsAidSsp(DataInputStream in) throws IOException {
		itsAid = new IntX(in);
		serviceSpecificPermissions = new Opaque(in);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public IntX getItsAid() {
		return this.itsAid;
	}

	public Opaque getServiceSpecificPermissions() {
		return this.serviceSpecificPermissions;
	}

	// ---- setter ----

	public void setItsAid(IntX itsAid) {
		this.itsAid = itsAid;
	}

	public void setServiceSpecificPermissions(Opaque serviceSpecificPermissions) {
		this.serviceSpecificPermissions = serviceSpecificPermissions;
	}

	@Override
	public String toString() {
		return "ItsAidSsp [itsAid=" + itsAid.getValue() + ", serviceSpecificPermissions="
				+ Hex.encodeHexString(serviceSpecificPermissions.get()) + "]";
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {

		int written = 0;
		written += itsAid.writeData(out);
		written += serviceSpecificPermissions.writeData(out);
		return written;
	}
}