package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.util.Arrays;

import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class PublicKey {

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(publicKey);
		result = prime * result + ((publicKeyAlgorithm == null) ? 0 : publicKeyAlgorithm.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PublicKey other = (PublicKey) obj;
		if (!Arrays.equals(publicKey, other.publicKey))
			return false;
		if (publicKeyAlgorithm == null) {
			if (other.publicKeyAlgorithm != null)
				return false;
		} else if (!publicKeyAlgorithm.equals(other.publicKeyAlgorithm))
			return false;
		return true;
	}

	@Column(name = Constants.PUBLICKEY__COL__ALGORITHM, nullable = false)
	private String publicKeyAlgorithm;

	@Column(name = Constants.PUBLICKEY__COL__KEY, nullable = false, columnDefinition = "blob")
	private byte[] publicKey;

	public PublicKey() {
	}

	public String getPublicKeyAlgorithm() {
		return publicKeyAlgorithm;
	}

	public void setPublicKeyAlgorithm(String publicKeyAlgorithm) {
		this.publicKeyAlgorithm = publicKeyAlgorithm;
	}

	public byte[] getPublicKey() {
		return publicKey;
	}

	public void setPublicKey(byte[] publicKey) {
		this.publicKey = publicKey;
	}

	public void setPublicKey(byte[] eccPubKeyX, byte[] eccPubKeyY, String algorithm) {
		byte[] key = new byte[65];
		key[0] = (byte) 0x04;
		System.arraycopy(eccPubKeyX, 0, key, 1, eccPubKeyX.length);
		System.arraycopy(eccPubKeyY, 0, key, eccPubKeyY.length + 1, eccPubKeyY.length);
		this.publicKey = key;
		this.publicKeyAlgorithm = algorithm;
	}
}
