package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.codec.binary.Hex;

import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.Certificate;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.CreationTime;

@Entity
@Table(name = Constants.CRL_CERTIFICATE__TABLE)
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class CrlCertificate implements CreationTime, Certificate {
	@Override
	public String toString() {
		return "CaCertificate [certId=" + Hex.encodeHexString(certId)
				+ ", certificate=" + Hex.encodeHexString(certificate)
				+ ", creationTime=" + creationTime + ", startTime=" + startTime
				+ ", expirationTime=" + expirationTime + ", subjectName="
				+ subjectName + ", signerCertId="
				+ Hex.encodeHexString(signerCertId) + "]";
	}

	@Id
	@Column(name = Constants.CRL_CERTIFICATE__COL__ID, columnDefinition = "varbinary(10)", nullable = false)
	private byte[] certId;

	@Column(name = Constants.CRL_CERTIFICATE__COL__CERTIFICATE, columnDefinition = "blob", nullable = false)
	private byte[] certificate;

	@Column(name = Constants.CRL_CERTIFICATE__COL__CREATION_TIME, nullable = false)
	private Timestamp creationTime;

	@Column(name = Constants.CRL_CERTIFICATE__COL__START_TIME, nullable = false)
	private Timestamp startTime;

	@Column(name = Constants.CRL_CERTIFICATE__COL__EXPIRATION_TIME, nullable = false)
	private Timestamp expirationTime;

	@Column(name = Constants.CRL_CERTIFICATE__COL__SUBJECT_NAME, nullable = false)
	private String subjectName;

	@Column(name = Constants.CRL_CERTIFICATE__COL__SIGNER_CERT_ID, columnDefinition = "varbinary(8)", nullable = false)
	private byte[] signerCertId;
	
	private String subjectType;

	public CrlCertificate() {
	}

	@Override
	public void setCreationTime(Timestamp creationTime) {
		this.creationTime = creationTime;
	}

	@Override
	public Timestamp getCreationTime() {
		return creationTime;
	}

	public byte[] getCertId() {
		return certId;
	}

	public void setCertId(byte[] certId) {
		this.certId = certId;
	}

	public byte[] getCertificate() {
		return certificate;
	}

	public void setCertificate(byte[] certificate) {
		this.certificate = certificate;
	}

	public Timestamp getStartTime() {
		return startTime;
	}

	public void setStartTime(Timestamp startTime) {
		this.startTime = startTime;
	}

	public Timestamp getExpirationTime() {
		return expirationTime;
	}

	public void setExpirationTime(Timestamp expirationTime) {
		this.expirationTime = expirationTime;
	}

	@Override
	public String getSubjectName() {
		return subjectName;
	}

	@Override
	public byte[] getSignerCertId() {
		return signerCertId;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}

	public void setSignerCertId(byte[] signerCertId) {
		this.signerCertId = signerCertId;
	}

	public String getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(String subjectType) {
		this.subjectType = subjectType;
	}

	@Override
	public String getCertTypeAndVersion() {
		// TODO: get type and version from DB 
		return "";
	}
}
