/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.voip;

import org.jnetpcap.packet.AbstractMessageHeader;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;

@Header
public class Sip
extends AbstractMessageHeader {
    public static int ID = 17;
    private Method method;

    public int contentLength() {
        if (this.hasField(Fields.Content_Length)) {
            return Integer.parseInt(super.fieldValue(String.class, Fields.Content_Length));
        }
        return 0;
    }

    public String contentType() {
        return this.fieldValue(Fields.Content_Type);
    }

    public ContentType contentTypeEnum() {
        return ContentType.parseContentType(this.contentType());
    }

    protected void decodeFirstLine(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 3) {
            return;
        }
        if (stringArray[0].startsWith("SIP")) {
            super.setMessageType(AbstractMessageHeader.MessageType.RESPONSE);
            super.addField(Response.RequestVersion, stringArray[0], string.indexOf(stringArray[0]));
            super.addField(Response.ResponseCode, stringArray[1], string.indexOf(stringArray[1]));
            super.addField(Response.ResponseCodeMsg, stringArray[2], string.indexOf(stringArray[2]));
            this.setMethod(null);
        } else {
            super.setMessageType(AbstractMessageHeader.MessageType.REQUEST);
            super.addField(Request.RequestMethod, stringArray[0], string.indexOf(stringArray[0]));
            super.addField(Request.RequestUrl, stringArray[1], string.indexOf(stringArray[1]));
            super.addField(Request.RequestVersion, stringArray[2], string.indexOf(stringArray[2]));
            Method method = Method.valueOf(stringArray[0]);
            this.setMethod(method);
        }
    }

    protected void decodeHeader() {
        String[] stringArray;
        String string;
        super.decodeHeader();
        if (this.getMessageType() == AbstractMessageHeader.MessageType.RESPONSE && (string = this.fieldValue(Fields.CSeq)) != null && (stringArray = string.trim().split(" ")).length == 2) {
            this.setMethod(Method.valueOf(stringArray[1]));
        }
    }

    private void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean hasMethod(Method method) {
        return this.method == method;
    }

    public String fieldValue(Fields fields) {
        return super.fieldValue(String.class, fields);
    }

    public String fieldValue(Request request) {
        return super.fieldValue(String.class, request);
    }

    public String fieldValue(Response response) {
        return super.fieldValue(String.class, response);
    }

    public boolean hasContent() {
        return this.hasField(Fields.Content_Type) || this.hasField(Fields.Content_Type);
    }

    public boolean hasContentType() {
        return this.hasField(Fields.Content_Type);
    }

    public boolean hasField(Fields fields) {
        return super.hasField(fields);
    }

    public boolean hasField(Request request) {
        return super.hasField(request);
    }

    public boolean hasField(Response response) {
        return super.hasField(response);
    }

    public String header() {
        return this.rawHeader;
    }

    public boolean isResponse() {
        return this.getMessageType() == AbstractMessageHeader.MessageType.RESPONSE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        ACK,
        BYE,
        CANCEL,
        INFO,
        INVITE,
        MESSAGE,
        NOTIFY,
        OPTIONS,
        PRACK,
        PUBLISH,
        REFER,
        REGISTER,
        SUBSCRIBE,
        UPDATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Field
    public static enum Response {
        RequestUrl,
        RequestVersion,
        ResponseCode,
        ResponseCodeMsg;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Field
    public static enum Request {
        RequestMethod,
        RequestUrl,
        RequestVersion,
        User_Agent;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Field
    public static enum Fields {
        Accept,
        Accept_Encoding,
        Accept_Language,
        Alert_Info,
        Allow,
        Authentication_Info,
        Authorization,
        Call_ID,
        Call_Info,
        Contact,
        Content_Disposition,
        Content_Encoding,
        Content_Language,
        Content_Length,
        Content_Type,
        CSeq,
        Date,
        Error_Info,
        Expires,
        From,
        In_Reply_To,
        Max_Forwards,
        MIME_Version,
        Min_Expires,
        Organization,
        Priority,
        Proxy_Authenticate,
        Proxy_Authorization,
        Proxy_Require,
        Record_Route,
        Reply_To,
        Require,
        Retry_After,
        Route,
        Server,
        Subject,
        Supported,
        Timestamp,
        To,
        Unsupported,
        User_Agent,
        Via,
        Warning,
        WWW_Authenticate;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        OTHER(new String[0]),
        PKCS7_MIME("application/pkcs7-mime"),
        PKCS7_SIGNATURE("application/pkcs7-signature"),
        SPD("application/SPD");

        private final String[] magic;

        public static ContentType parseContentType(String string) {
            if (string == null) {
                return OTHER;
            }
            for (ContentType contentType : ContentType.values()) {
                if (contentType.name().equalsIgnoreCase(string)) {
                    return contentType;
                }
                for (String string2 : contentType.magic) {
                    if (!string.startsWith(string2)) continue;
                    return contentType;
                }
            }
            return OTHER;
        }

        private ContentType(String ... stringArray) {
            this.magic = stringArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        Address_Incomplete(484, "Address Incomplete"),
        Alternative_Service(380, "Alternative Service"),
        Ambiguous(485, "Ambiguous"),
        Bad_Extension(420, "Bad Extension"),
        Bad_Gateway(502, "Bad Gateway"),
        Bad_Request(400, "Bad Request"),
        Busy_Everywhere(600, "Busy Everywhere"),
        Busy_Here(486, "Busy Here"),
        Call_Leg_Transaction_Does_Not_Exist(481, "Call Leg/Transaction Does Not Exist"),
        Decline(603, "Decline"),
        Does_not_exist_anywhere(604, "Does not exist anywhere"),
        Extension_Required(421, "Extension Required"),
        Forbidden(403, "Forbidden"),
        Gone(410, "Gone"),
        Internal_Server_Error(500, "Internal Server Error"),
        Interval_Too_Brief(423, "Interval Too Brief"),
        Loop_Detected(482, "Loop Detected"),
        Message_Too_Large(513, "Message Too Large"),
        Method_Not_Allowed(405, "Method Not Allowed"),
        Moved_Permanently(301, "Moved Permanently"),
        Moved_Temporarily(302, "Moved Temporarily"),
        MULTIPLE_CHOICES(300, "Multiple Choices"),
        Not_Acceptable_Here(488, "Not Acceptable Here"),
        Not_Acceptable400(406, "Not Acceptable"),
        Not_Acceptable600(606, "Not Acceptable"),
        Not_Found(404, "Not Found"),
        Not_Implemented(501, "Not Implemented"),
        OK(200, "OK"),
        Payment_Required(402, "Payment Required"),
        Proxy_Authentication_Required(407, "Proxy Authentication Required"),
        Request_Entity_Too_Large(413, "Request Entity Too Large"),
        Request_Pending(491, "Request Pending"),
        Request_Terminated(487, "Request Terminated"),
        Request_Timeout(408, "Request Timeout"),
        Request_URI_Too_Large(414, "Request-URI Too Large"),
        Server_Time_out(504, "Server Time-out"),
        Service_Unavailable(503, "Service Unavailable"),
        SIP_Version_not_supported(505, "SIP Version not supported"),
        Temporarily_not_available(480, "Temporarily not available"),
        Too_Many_Hops(483, "Too Many Hops"),
        Unauthorized(401, "Unauthorized"),
        Undecipherable(493, "Undecipherable"),
        Unsupported_Media_Type(415, "Unsupported Media Type"),
        Unsupported_URI_Scheme(416, "Unsupported URI Scheme"),
        Use_Proxy(305, "Use Proxy");

        private final int code;
        private final String description;

        private Code(int n2, String string2) {
            this.code = n2;
            this.description = string2;
        }

        public final int getCode() {
            return this.code;
        }

        public final String getDescription() {
            return this.description;
        }

        public Code valueOf(int n) {
            for (Code code : Code.values()) {
                if (code.code != n) continue;
                return code;
            }
            return null;
        }

        public Code valueOfUsingCode(String string) {
            return this.valueOf(Integer.parseInt(string));
        }
    }
}

