/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.tcpip;

import java.util.EnumSet;
import java.util.Set;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeaderChecksum;
import org.jnetpcap.packet.JHeaderMap;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.annotate.BindingVariable;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FlowKey;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.util.checksum.Checksum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Header
public class Tcp
extends JHeaderMap<Tcp>
implements JHeaderChecksum {
    private static final int FLAG_ACK = 16;
    private static final int FLAG_CONG = 128;
    private static final int FLAG_CWR = 128;
    private static final int FLAG_ECE = 64;
    private static final int FLAG_ECN = 64;
    private static final int FLAG_FIN = 1;
    private static final int FLAG_PSH = 8;
    private static final int FLAG_RST = 4;
    private static final int FLAG_SYN = 2;
    private static final int FLAG_URG = 32;
    public static final int ID = 4;
    private int biDirectionalHashcode;
    private final Ip4 ip = new Ip4();
    private int uniDirectionalHashcode;

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        int n2 = (jBuffer.getUByte(n + 12) & 0xF0) >> 4;
        return n2 * 4;
    }

    @Field(offset=64, length=16, format="%x")
    public long ack() {
        return this.getUInt(8);
    }

    public void ack(long l) {
        super.setUInt(8, l);
    }

    @Override
    public int calculateChecksum() {
        if (this.getIndex() == -1) {
            throw new IllegalStateException("Oops index not set");
        }
        int n = this.getPreviousHeaderOffset();
        return Checksum.inChecksumShouldBe(this.checksum(), Checksum.pseudoTcp(this.packet, n, this.getOffset()));
    }

    @Override
    @Field(offset=128, length=16, format="%x")
    public int checksum() {
        return this.getUShort(16);
    }

    public void checksum(int n) {
        super.setUShort(16, n);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String checksumDescription() {
        if (this.isFragmented()) {
            return "supressed for fragments";
        }
        if (this.isPayloadTruncated()) {
            return "supressed for truncated packets";
        }
        int n = this.calculateChecksum();
        if (this.checksum() == n) {
            return "correct";
        }
        return "incorrect: 0x" + Integer.toHexString(n).toUpperCase();
    }

    private void clearFlag(int n) {
        super.setUByte(13, this.flags() & ~n);
    }

    @Override
    protected void decodeHeader() {
        if (this.getPacket() != null && this.getPacket().hasHeader(this.ip)) {
            this.biDirectionalHashcode = this.ip.destinationToInt() + this.destination() ^ this.ip.sourceToInt() + this.source();
            this.uniDirectionalHashcode = this.ip.destinationToInt() + this.destination();
        } else {
            this.biDirectionalHashcode = super.hashCode();
        }
        this.optionsBitmap = 0L;
        int n = this.hlen() * 4;
        block4: for (int i = 20; i < n; ++i) {
            int n2 = this.getUByte(i);
            this.optionsOffsets[n2] = i;
            this.optionsBitmap |= (long)(1 << n2);
            TcpOption.OptionCode optionCode = TcpOption.OptionCode.valueOf(n2);
            if (optionCode == null) break;
            switch (optionCode) {
                case NO_OP: {
                    this.optionsLength[n2] = 1;
                    continue block4;
                }
                case END_OF_OPTION_LIST: {
                    this.optionsLength[n2] = n - i;
                    i = n;
                    continue block4;
                }
                default: {
                    int n3 = this.getUByte(i + 1);
                    i += n3 - 1;
                    this.optionsLength[n2] = n3;
                }
            }
        }
    }

    @Field(offset=16, length=16)
    @FlowKey(index=2, reversable=true)
    @BindingVariable
    public int destination() {
        return this.getUShort(2);
    }

    public void destination(int n) {
        super.setUShort(2, n);
    }

    @Field(offset=104, length=8, format="%x")
    public int flags() {
        return this.getUByte(13);
    }

    public void flags(int n) {
        super.setUByte(13, n);
    }

    @Field(parent="flags", offset=4, length=1, format="%b", display="ack", description="acknowledgment")
    public boolean flags_ACK() {
        return (this.flags() & 0x10) != 0;
    }

    public void flags_ACK(boolean bl) {
        this.setFlag(bl, 16);
    }

    @Field(parent="flags", offset=7, length=1, format="%b", display="cwr", description="reduced (cwr)")
    public boolean flags_CWR() {
        return (this.flags() & 0x80) != 0;
    }

    public void flags_CWR(boolean bl) {
        this.setFlag(bl, 128);
    }

    @Field(parent="flags", offset=6, length=1, format="%b", display="ece", description="ECN echo flag")
    public boolean flags_ECE() {
        return (this.flags() & 0x40) != 0;
    }

    public void flags_ECE(boolean bl) {
        this.setFlag(bl, 64);
    }

    @Field(parent="flags", offset=0, length=1, format="%b", display="fin", description="closing down connection")
    public boolean flags_FIN() {
        return (this.flags() & 1) != 0;
    }

    public void flags_FIN(boolean bl) {
        this.setFlag(bl, 1);
    }

    @Field(parent="flags", offset=3, length=1, format="%b", display="ack", description="push current segment of data")
    public boolean flags_PSH() {
        return (this.flags() & 8) != 0;
    }

    public void flags_PSH(boolean bl) {
        this.setFlag(bl, 8);
    }

    @Field(parent="flags", offset=2, length=1, format="%b", display="ack", description="reset connection")
    public boolean flags_RST() {
        return (this.flags() & 4) != 0;
    }

    public void flags_RST(boolean bl) {
        this.setFlag(bl, 4);
    }

    @Field(parent="flags", offset=1, length=1, format="%b", display="ack", description="synchronize connection, startup")
    public boolean flags_SYN() {
        return (this.flags() & 2) != 0;
    }

    public void flags_SYN(boolean bl) {
        this.setFlag(bl, 2);
    }

    @Field(parent="flags", offset=5, length=1, format="%b", display="ack", description="urgent, out-of-band data")
    public boolean flags_URG() {
        return (this.flags() & 0x20) != 0;
    }

    public void flags_URG(boolean bl) {
        this.setFlag(bl, 32);
    }

    public String flagsCompactString() {
        return Flag.toCompactString(this.flags());
    }

    public Set<Flag> flagsEnum() {
        return Flag.asSet(this.flags());
    }

    public int hashCode() {
        return this.biDirectionalHashcode;
    }

    @Field(offset=96, length=4)
    public int hlen() {
        return (this.getUByte(12) & 0xF0) >> 4;
    }

    public void hlen(int n) {
        super.setUByte(12, this.getUByte(12) & 0xF | n << 4);
    }

    @Override
    public boolean isChecksumValid() {
        if (this.isFragmented()) {
            return true;
        }
        if (this.getIndex() == -1) {
            throw new IllegalStateException("Oops index not set");
        }
        int n = this.getPreviousHeaderOffset();
        return Checksum.pseudoTcp(this.packet, n, this.getOffset()) == 0;
    }

    @Field(offset=100, length=4)
    public int reserved() {
        return this.getUByte(12) & 0xF;
    }

    public void reserved(int n) {
        this.setUByte(12, n & 0xF);
    }

    @Field(offset=32, length=16, format="%x")
    public long seq() {
        return this.getUInt(4);
    }

    public void seq(long l) {
        super.setUInt(4, l);
    }

    private void setFlag(boolean bl, int n) {
        if (bl) {
            this.setFlag(n);
        } else {
            this.clearFlag(n);
        }
    }

    private void setFlag(int n) {
        super.setUByte(13, this.flags() | n);
    }

    @Field(offset=0, length=16)
    @FlowKey(index=2, reversable=true)
    @BindingVariable
    public int source() {
        return this.getUShort(0);
    }

    public void source(int n) {
        super.setUShort(0, n);
    }

    public int uniHashCode() {
        return this.uniDirectionalHashcode;
    }

    @Field(offset=144, length=16)
    public int urgent() {
        return this.getUShort(18);
    }

    public void urgent(int n) {
        super.setUShort(18, n);
    }

    @Field(offset=112, length=16)
    public int window() {
        return this.getUShort(14);
    }

    public void window(int n) {
        super.setUShort(14, n);
    }

    public int windowScaled() {
        return this.window() << 6;
    }

    @Header(id=3)
    public static class WindowScale
    extends TcpOption {
        @Field(offset=16, length=8)
        public int scale() {
            return this.getUByte(2);
        }

        public void scale(int n) {
            this.setUByte(2, n);
        }
    }

    @Header(id=8)
    public static class Timestamp
    extends TcpOption {
        @Field(offset=48, length=32)
        public long tsecr() {
            return this.getUInt(6);
        }

        public void tsecr(long l) {
            this.setUInt(6, l);
        }

        @Field(offset=16, length=32)
        public long tsval() {
            return this.getUInt(2);
        }

        public void tsval(long l) {
            this.setUInt(2, l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TcpOption
    extends JSubHeader<Tcp> {
        @Field(offset=0, length=8)
        public int code() {
            return this.getUByte(0);
        }

        public void code(int n) {
            this.setUByte(0, n);
        }

        @Field(offset=8, length=8)
        public int length() {
            return this.lengthCheck(null) ? this.getUByte(1) : 1;
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String lengthDescription() {
            return this.lengthCheck(null) ? null : "implied length from option type";
        }

        public void length(int n) {
            this.setUByte(1, n);
        }

        @Dynamic(field="length", value=Field.Property.CHECK)
        public boolean lengthCheck(String string) {
            return this.code() > 1;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum OptionCode {
            ALTERNATE_CHECKSUM(15),
            ALTERNATE_CHECKSUM_REQUEST(14),
            END_OF_OPTION_LIST(0),
            MAXIMUM_SEGMENT_SIZE(2),
            NO_OP(1),
            SACK(5),
            SACK_PERMITTED(4),
            TIMESTAP(8),
            WINDOW_SCALE(3);

            public final int id;

            public static OptionCode valueOf(int n) {
                for (OptionCode optionCode : OptionCode.values()) {
                    if (optionCode.id != n) continue;
                    return optionCode;
                }
                return null;
            }

            private OptionCode(int n2) {
                this.id = n2;
            }
        }
    }

    @Header(id=4)
    public static class SACK_PERMITTED
    extends TcpOption {
    }

    @Header(id=5)
    public static class SACK
    extends TcpOption {
        public int blockCount() {
            return (this.size() - 2) / 8;
        }

        @Dynamic(value=Field.Property.LENGTH)
        public int blocksLength() {
            return this.blockCount() * 64;
        }

        @Field(offset=16)
        public long[] blocks() {
            return this.blocksToArray(new long[this.blockCount() * 2]);
        }

        public void blocks(long[] lArray) {
            int n = lArray.length / 2;
            for (int i = 0; i < n; ++i) {
                this.setUInt(i * 4 + 2, lArray[i]);
            }
            this.length(lArray.length * 4 + 2);
        }

        public long[] blocksToArray(long[] lArray) {
            int n = lArray.length < this.blockCount() * 2 ? lArray.length : this.blockCount() * 2;
            for (int i = 0; i < n; ++i) {
                lArray[i] = this.getUInt(i * 4 + 2);
            }
            return lArray;
        }
    }

    @Header(id=1)
    public static class NoOp
    extends TcpOption {
    }

    @Header(id=2, description="Maximum Segment Size")
    public static class MSS
    extends TcpOption {
        @Field(offset=16, length=16)
        public int mss() {
            return this.getUShort(2);
        }

        public void mss(int n) {
            this.setUShort(2, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        ACK,
        CWR,
        ECE,
        FIN,
        PSH,
        RST,
        SYN,
        URG;


        public static Set<Flag> asSet(int n) {
            EnumSet<Flag> enumSet = EnumSet.noneOf(Flag.class);
            int n2 = Flag.values().length;
            for (int i = 0; i < n2; ++i) {
                if ((n & 1 << i) <= 0) continue;
                enumSet.add(Flag.values()[i]);
            }
            return enumSet;
        }

        public static String toCompactString(int n) {
            return Flag.toCompactString(Flag.asSet(n));
        }

        public static String toCompactString(Set<Flag> set) {
            StringBuilder stringBuilder = new StringBuilder(Flag.values().length);
            for (Flag flag : set) {
                stringBuilder.append(flag.name().charAt(0));
            }
            return stringBuilder.toString();
        }
    }

    @Header(id=14)
    public static class AlternateChecksumRequest
    extends TcpOption {
        @Field(offset=16, length=8)
        public int algorithm() {
            return this.getUByte(2);
        }

        public Algorithm algorithmEnum() {
            return Algorithm.valueOf(this.algorithm());
        }

        public void algorithm(int n) {
            this.setUByte(2, n);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Algorithm {
            TCP_CHECKSUM(0),
            FLETCHER_8BIT(1),
            FLETCHER_16BIT(2),
            AVOIDANCE(3);

            public final int type;

            private Algorithm(int n2) {
                this.type = n2;
            }

            public static Algorithm valueOf(int n) {
                for (Algorithm algorithm : Algorithm.values()) {
                    if (n != algorithm.type) continue;
                    return algorithm;
                }
                return null;
            }
        }
    }

    @Header(id=15)
    public static class AlternateChecksum
    extends TcpOption {
        @Field(offset=16, format="#hexdump#")
        public byte[] data() {
            return this.getByteArray(2, this.dataLength() / 8);
        }

        public byte[] dataToArray(byte[] byArray) {
            return this.getByteArray(2, byArray);
        }

        @Dynamic(value=Field.Property.LENGTH)
        public int dataLength() {
            return (this.length() - 2) * 8;
        }
    }
}

