/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.lan;

import java.nio.ByteOrder;
import java.util.List;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FlowKey;
import org.jnetpcap.packet.annotate.Format;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.structure.JField;
import org.jnetpcap.util.checksum.Checksum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Header(length=14, dlt={PcapDLT.EN10MB, PcapDLT.FDDI}, osi=Header.Layer.DATALINK, characteristics={Header.Characteristic.CSMA_CD}, nicname="Eth", description="Ethernet", url="http://en.wikipedia.org/wiki/Ethernet")
public class Ethernet
extends JHeader {
    public static final int ADDRESS_IG_BIT = 64;
    public static final int ADDRESS_LG_BIT = 128;
    public static final int ID = 1;
    public static final int LENGTH = 14;
    public static final String ORG_IEEE = "IEEE Ethernet2";

    @Field(offset=0, length=48, format="#mac#", mask=0xFFFF00000000L)
    public byte[] destination() {
        return this.getByteArray(0, 6);
    }

    @Field(parent="destination", offset=40, length=1, display="IG bit")
    @FlowKey(index=0)
    public long destination_IG() {
        return (this.getUByte(0) & 0x40) >> 5;
    }

    @Field(parent="destination", offset=41, length=1, display="LG bit")
    public long destination_LG() {
        return (this.getUByte(0) & 0x80) >> 6;
    }

    public void destination(byte[] byArray) {
        this.setByteArray(0, byArray);
    }

    public byte[] destinationToByteArray(byte[] byArray) {
        return this.getByteArray(0, byArray);
    }

    @Field(offset=48, length=48, format="#mac#", mask=0xFFFF00000000L)
    @FlowKey(index=0)
    public byte[] source() {
        return this.getByteArray(6, 6);
    }

    @Field(parent="source", offset=40, length=1, display="IG bit")
    public long source_IG() {
        return (this.getUByte(0) & 0x40) >> 5;
    }

    @Field(parent="source", offset=41, length=1, display="LG bit")
    public long source_LG() {
        return (this.getUByte(0) & 0x80) >> 6;
    }

    public void source(byte[] byArray) {
        this.setByteArray(6, byArray);
    }

    public byte[] sourceToByteArray(byte[] byArray) {
        return this.getByteArray(6, byArray);
    }

    @Field(offset=96, length=16, format="%x")
    @FlowKey(index=1)
    public int type() {
        return this.getUShort(12);
    }

    public void type(int n) {
        this.setUShort(12, n);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String typeDescription() {
        return EthernetType.toString(this.type());
    }

    @Format
    public void formatHeader(List<JField> list) {
    }

    public EthernetType typeEnum() {
        return EthernetType.valueOf(this.type());
    }

    @Dynamic(field="checksum", value=Field.Property.CHECK)
    public boolean checksumCheck() {
        return this.getPostfixLength() >= 4;
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int checksumOffset() {
        return this.getPostfixOffset() * 8;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String checksumDescription() {
        long l = this.calculateChecksum();
        if (this.checksum() == l) {
            return "correct";
        }
        return "incorrect: 0x" + Long.toHexString(l).toUpperCase();
    }

    @Field(length=32, format="%x", display="FCS")
    public long checksum() {
        JPacket jPacket = this.getPacket();
        jPacket.order(ByteOrder.BIG_ENDIAN);
        return jPacket.getUInt(this.getPostfixOffset());
    }

    public boolean checksum(long l) {
        if (this.getPostfixLength() < 4) {
            return false;
        }
        JPacket jPacket = this.getPacket();
        jPacket.order(ByteOrder.BIG_ENDIAN);
        jPacket.setUInt(jPacket.size() - 4, l);
        return true;
    }

    public long calculateChecksum() {
        JPacket jPacket = this.getPacket();
        return Checksum.crc32IEEE802(jPacket, 0, this.getHeaderLength() + this.getPayloadLength());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EthernetType {
        IEEE_802DOT1Q(33024, "vlan - IEEE 802.1q"),
        IP4(2048, "ip version 4"),
        IP6(34525, "ip version 6");

        private final String description;
        private final int id;

        public static String toString(int n) {
            for (EthernetType ethernetType : EthernetType.values()) {
                if (ethernetType.id != n) continue;
                return ethernetType.description;
            }
            return null;
        }

        public static EthernetType valueOf(int n) {
            for (EthernetType ethernetType : EthernetType.values()) {
                if (ethernetType.id != n) continue;
                return ethernetType;
            }
            return null;
        }

        private EthernetType(int n2) {
            this.id = n2;
            this.description = this.name().toLowerCase();
        }

        private EthernetType(int n2, String string2) {
            this.id = n2;
            this.description = string2;
        }

        public final String getDescription() {
            return this.description;
        }

        public final int getId() {
            return this.id;
        }
    }
}

