/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol;

import org.jnetpcap.Pcap;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.Payload;
import org.jnetpcap.protocol.application.Html;
import org.jnetpcap.protocol.application.WebImage;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.lan.IEEE802dot1q;
import org.jnetpcap.protocol.lan.IEEE802dot2;
import org.jnetpcap.protocol.lan.IEEE802dot3;
import org.jnetpcap.protocol.lan.IEEESnap;
import org.jnetpcap.protocol.lan.SLL;
import org.jnetpcap.protocol.network.Arp;
import org.jnetpcap.protocol.network.Icmp;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.network.Ip6;
import org.jnetpcap.protocol.tcpip.Http;
import org.jnetpcap.protocol.tcpip.Tcp;
import org.jnetpcap.protocol.tcpip.Udp;
import org.jnetpcap.protocol.voip.Rtp;
import org.jnetpcap.protocol.voip.Sdp;
import org.jnetpcap.protocol.voip.Sip;
import org.jnetpcap.protocol.vpn.L2TP;
import org.jnetpcap.protocol.wan.PPP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JProtocol {
    PAYLOAD(Payload.class),
    ETHERNET(Ethernet.class, PcapDLT.EN10MB),
    IP4(Ip4.class),
    IP6(Ip6.class),
    TCP(Tcp.class),
    UDP(Udp.class),
    IEEE_802DOT3(IEEE802dot3.class, PcapDLT.IEEE802),
    IEEE_802DOT2(IEEE802dot2.class),
    IEEE_SNAP(IEEESnap.class),
    IEEE_802DOT1Q(IEEE802dot1q.class),
    L2TP(L2TP.class),
    PPP(PPP.class, PcapDLT.PPP),
    ICMP(Icmp.class),
    HTTP(Http.class),
    HTML(Html.class),
    WEB_IMAGE(WebImage.class),
    ARP(Arp.class),
    SIP(Sip.class),
    SDP(Sdp.class),
    RTP(Rtp.class),
    SLL(SLL.class, PcapDLT.LINUX_SLL);

    private final int ID;
    private Class<? extends JHeader> clazz;
    private final String className;
    private final PcapDLT[] dlt;
    public static final int PAYLOAD_ID = 0;
    public static final int ETHERNET_ID = 1;
    public static final int IP4_ID = 2;
    public static final int IP6_ID = 3;
    public static final int TCP_ID = 4;
    public static final int UDP_ID = 5;
    public static final int IEEE_802DOT3_ID = 6;
    public static final int IEEE_802DOT2_ID = 7;
    public static final int IEEE_SNAP_ID = 8;
    public static final int IEEE_802DOT1Q_ID = 9;
    public static final int L2TP_ID = 10;
    public static final int PPP_ID = 11;
    public static final int ICMP_ID = 12;
    public static final int HTTP_ID = 13;
    public static final int HTML_ID = 14;
    public static final int WEB_IMAGE_ID = 15;
    public static final int ARP_ID = 16;
    public static final int SIP_ID = 17;
    public static final int SDP_ID = 18;
    public static final int RTP_ID = 19;
    public static final int SLL_ID = 20;
    public static final int LAST_ID;

    private JProtocol(String string2) {
        this(string2, new PcapDLT[0]);
    }

    private JProtocol(Class<? extends JHeader> clazz) {
        this(clazz, new PcapDLT[0]);
    }

    private JProtocol(Class<? extends JHeader> clazz, PcapDLT ... pcapDLTArray) {
        this.clazz = clazz;
        this.className = clazz.getCanonicalName();
        this.dlt = pcapDLTArray;
        this.ID = this.ordinal();
    }

    private JProtocol(String string2, PcapDLT ... pcapDLTArray) {
        this.className = string2;
        this.dlt = pcapDLTArray;
        this.ID = this.ordinal();
        if (((Object)((Object)this)).getClass().getResource(string2) == null) {
            throw new IllegalStateException("unable to find class " + string2);
        }
    }

    public Class<? extends JHeader> getHeaderClass() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
        }
        return this.clazz;
    }

    public String getHeaderClassName() {
        return this.className;
    }

    public static boolean isCoreProtocol(int n) {
        return n < JProtocol.values().length;
    }

    public static boolean isCoreProtocol(Class<? extends JHeader> clazz) {
        return JProtocol.valueOf(clazz) != null;
    }

    public static JProtocol valueOf(Class<? extends JHeader> clazz) {
        for (JProtocol jProtocol : JProtocol.values()) {
            if (jProtocol.clazz != clazz) continue;
            return jProtocol;
        }
        return null;
    }

    public static JProtocol valueOf(int n) {
        if (n >= JProtocol.values().length) {
            return null;
        }
        return JProtocol.values()[n];
    }

    public static JProtocol valueOf(Pcap pcap) {
        return JProtocol.valueOf(PcapDLT.valueOf(pcap.datalink()));
    }

    public static JProtocol valueOf(PcapDLT pcapDLT) {
        if (pcapDLT == null) {
            return PAYLOAD;
        }
        for (JProtocol jProtocol : JProtocol.values()) {
            for (PcapDLT pcapDLT2 : jProtocol.dlt) {
                if (pcapDLT != pcapDLT2) continue;
                return jProtocol;
            }
        }
        return PAYLOAD;
    }

    public PcapDLT[] getDlt() {
        return this.dlt;
    }

    public int getId() {
        return this.ID;
    }

    public final Class<? extends JHeader> getClazz() {
        return this.clazz;
    }

    static {
        LAST_ID = JProtocol.values().length;
    }

    public static interface Suite {
        public String name();
    }
}

