/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.nio.ByteBuffer;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.PeeringException;

public class PcapPacket
extends JPacket {
    private static final int STATE_SIZE = PcapHeader.sizeof() + JPacket.State.sizeof(20);
    private final PcapHeader header = new PcapHeader(JMemory.Type.POINTER);

    private static native void initIds();

    public PcapPacket(byte[] byArray) {
        super(JMemory.Type.POINTER);
        this.transferStateAndDataFrom(byArray);
    }

    public PcapPacket(ByteBuffer byteBuffer) {
        super(JMemory.Type.POINTER);
        this.transferStateAndDataFrom(byteBuffer);
    }

    public PcapPacket(int n) {
        super(n, STATE_SIZE);
    }

    public PcapPacket(int n, int n2) {
        super(n, PcapHeader.sizeof() + JPacket.State.sizeof(n2));
    }

    public PcapPacket(JBuffer jBuffer) {
        super(JMemory.Type.POINTER);
        this.transferStateAndDataFrom(jBuffer);
    }

    public PcapPacket(JPacket jPacket) {
        super(JMemory.Type.POINTER);
        if (!(jPacket instanceof PcapPacket)) {
            throw new UnsupportedOperationException("Unsupported packet type for this constructor");
        }
        ((PcapPacket)jPacket).transferStateAndDataTo(this);
    }

    public PcapPacket(PcapHeader pcapHeader, ByteBuffer byteBuffer) {
        super(JMemory.Type.POINTER);
        this.transferHeaderAndDataFrom0(pcapHeader, byteBuffer);
    }

    public PcapPacket(PcapHeader pcapHeader, JBuffer jBuffer) {
        super(JMemory.Type.POINTER);
        this.transferHeaderAndDataFrom0(pcapHeader, jBuffer);
    }

    public PcapPacket(PcapPacket pcapPacket) {
        super(JMemory.Type.POINTER);
        pcapPacket.transferStateAndDataTo(this);
    }

    public PcapPacket(JMemory.Type type) {
        super(type);
    }

    public PcapHeader getCaptureHeader() {
        return this.header;
    }

    public int getTotalSize() {
        return super.size() + this.state.size() + this.header.size();
    }

    public int peerHeaderAndData(JBuffer jBuffer) {
        int n = this.header.peer(jBuffer, 0);
        n += super.peer(jBuffer, n, jBuffer.size() - this.header.size());
        return n;
    }

    public int peer(PcapHeader pcapHeader, JBuffer jBuffer) {
        int n = this.header.peerTo(pcapHeader, 0);
        return n += this.peer(jBuffer);
    }

    public int peerAndScan(int n, PcapHeader pcapHeader, JBuffer jBuffer) {
        int n2 = this.header.peerTo(pcapHeader, 0);
        this.scan(n);
        return n2 += this.peer(jBuffer);
    }

    public int peerHeaderAndData(PcapHeader pcapHeader, ByteBuffer byteBuffer) throws PeeringException {
        int n = this.header.peerTo(pcapHeader, 0);
        return n += super.peer(byteBuffer);
    }

    public int peerHeaderAndData(PcapHeader pcapHeader, JBuffer jBuffer) {
        int n = this.header.peerTo(pcapHeader, 0);
        return n += super.peer(jBuffer);
    }

    public int peerStateAndData(ByteBuffer byteBuffer) throws PeeringException {
        if (!byteBuffer.isDirect()) {
            throw new PeeringException("unable to peer a non-direct ByteBuffer");
        }
        return this.peerStateAndData(this.getMemoryBuffer(byteBuffer), 0);
    }

    public int peerStateAndData(JBuffer jBuffer) {
        return this.peerStateAndData(this.getMemoryBuffer(jBuffer), 0);
    }

    private int peerStateAndData(JBuffer jBuffer, int n) {
        int n2 = this.header.peer(jBuffer, n);
        this.state.peerTo(jBuffer, n + n2, JPacket.State.sizeof(0));
        n2 += this.state.peerTo(jBuffer, n + n2, JPacket.State.sizeof(this.state.getHeaderCount()));
        n2 += super.peer(jBuffer, n + n2, this.header.caplen());
        return n2;
    }

    public int transferHeaderAndDataFrom(PcapHeader pcapHeader, ByteBuffer byteBuffer) {
        return this.transferHeaderAndDataFrom0(pcapHeader, byteBuffer);
    }

    private int transferHeaderAndDataFrom0(PcapHeader pcapHeader, ByteBuffer byteBuffer) {
        return PcapPacket.getMemoryPool().duplicate2((JMemory)pcapHeader, byteBuffer, (JMemory)this.header, (JMemory)this);
    }

    public int transferHeaderAndDataFrom(PcapHeader pcapHeader, JBuffer jBuffer) {
        return this.transferHeaderAndDataFrom0(pcapHeader, jBuffer);
    }

    private int transferHeaderAndDataFrom0(PcapHeader pcapHeader, JBuffer jBuffer) {
        return PcapPacket.getMemoryPool().duplicate2((JMemory)pcapHeader, jBuffer, (JMemory)this.header, (JMemory)this);
    }

    public int transferStateAndDataFrom(byte[] byArray) {
        JBuffer jBuffer = this.getMemoryBuffer(byArray);
        return this.peerStateAndData(jBuffer, 0);
    }

    public int transferStateAndDataFrom(ByteBuffer byteBuffer) {
        int n = byteBuffer.limit() - byteBuffer.position();
        JBuffer jBuffer = this.getMemoryBuffer(n);
        jBuffer.transferFrom(byteBuffer, 0);
        return this.peerStateAndData(jBuffer, 0);
    }

    public int transferStateAndDataFrom(JBuffer jBuffer) {
        int n = jBuffer.size();
        JBuffer jBuffer2 = this.getMemoryBuffer(n);
        jBuffer.transferTo(jBuffer2);
        return this.peerStateAndData(jBuffer2, 0);
    }

    public int transferStateAndDataFrom(PcapPacket pcapPacket) {
        return pcapPacket.transferStateAndDataTo(this);
    }

    public int transferStateAndDataTo(byte[] byArray) {
        int n = this.header.transferTo(byArray, 0);
        n += this.state.transferTo(byArray, n);
        n += super.transferTo(byArray, 0, this.size(), n);
        return n;
    }

    public int transferStateAndDataTo(ByteBuffer byteBuffer) {
        int n = this.header.transferTo(byteBuffer);
        n += this.state.transferTo(byteBuffer);
        return n += super.transferTo(byteBuffer);
    }

    public int transferStateAndDataTo(JBuffer jBuffer) {
        return this.transferStateAndDataTo(jBuffer, 0);
    }

    public int transferStateAndDataTo(JBuffer jBuffer, int n) {
        int n2 = this.header.transferTo(jBuffer, n);
        n2 += this.state.transferTo(jBuffer, 0, this.state.size(), n + n2);
        n2 += super.transferTo(jBuffer, 0, this.size(), n + n2);
        return n2;
    }

    public int transferStateAndDataTo(PcapPacket pcapPacket) {
        JBuffer jBuffer = pcapPacket.getMemoryBuffer(this.getTotalSize());
        int n = this.header.transferTo(jBuffer, 0);
        pcapPacket.header.peerTo(jBuffer, 0);
        pcapPacket.state.peerTo(jBuffer, n, this.state.size());
        pcapPacket.peer(jBuffer, n += this.state.transferTo(pcapPacket.state), this.size());
        n += this.transferTo(jBuffer, 0, this.size(), n);
        return n;
    }

    static {
        try {
            PcapPacket.initIds();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

