/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import java.nio.ByteBuffer;
import java.util.Properties;
import org.jnetpcap.Pcap;
import org.jnetpcap.nio.DisposableGC;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemoryReference;
import org.jnetpcap.packet.PeeringException;
import org.jnetpcap.packet.format.FormatUtils;

public abstract class JMemory {
    private static long directMemory;
    private static long directMemorySoft;
    public static final String JNETPCAP_LIBRARY_NAME = "jnetpcap";
    public static final long MAX_DIRECT_MEMORY_DEFAULT = 0x4000000L;
    public static final Type POINTER;
    private Object keeper = null;
    private boolean owner = false;
    long physical;
    private JMemoryReference ref = null;
    int size;

    private static native long allocate0(int var0);

    public static native long availableDirectMemory();

    private static native void initIDs();

    public static long maxDirectMemory() {
        if (directMemory != 0L) {
            return directMemory;
        }
        Properties properties = System.getProperties();
        String string = properties.getProperty("org.jnetsoft.nio.MaxDirectMemorySize");
        string = string == null ? properties.getProperty("nio.MaxDirectMemorySize") : string;
        string = string == null ? properties.getProperty("org.jnetsoft.nio.mx") : string;
        String string2 = string = string == null ? properties.getProperty("nio.mx") : string;
        if (string != null) {
            directMemory = JMemory.parseSize(string);
        }
        if (directMemory == 0L) {
            directMemory = JMemory.maxDirectoryMemoryDefault();
        }
        return directMemory;
    }

    private static void maxDirectMemoryBreached() {
        DisposableGC.getDefault().invokeSystemGCAndWait();
    }

    private static long maxDirectoryMemoryDefault() {
        long l = Runtime.getRuntime().maxMemory();
        if (l > 0x4000000L) {
            l = 0x4000000L;
        }
        return l;
    }

    static long parseSize(String string) {
        string = string.trim().toLowerCase();
        long l = 1L;
        if (string.endsWith("tb")) {
            l = 0x10000000000L;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("gb")) {
            l = 0x40000000L;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("mb")) {
            l = 0x100000L;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("kb")) {
            l = 1024L;
            string = string.substring(0, string.length() - 2);
        }
        long l2 = Long.parseLong(string) * l;
        return l2;
    }

    public static native long reservedDirectMemory();

    private static native void setMaxDirectMemorySize(long var0);

    private static native void setSoftDirectMemorySize(long var0);

    public static long softDirectMemory() {
        if (directMemorySoft != 0L) {
            return directMemorySoft;
        }
        Properties properties = System.getProperties();
        String string = properties.getProperty("org.jnetsoft.nio.SoftDirectMemorySize");
        string = string == null ? properties.getProperty("nio.SoftDirectMemorySize") : string;
        string = string == null ? properties.getProperty("org.jnetsoft.nio.ms") : string;
        String string2 = string = string == null ? properties.getProperty("nio.ms") : string;
        if (string != null) {
            directMemorySoft = JMemory.parseSize(string);
        }
        if (directMemorySoft == 0L) {
            directMemorySoft = JMemory.maxDirectMemory();
        }
        return directMemorySoft;
    }

    private static void softDirectMemoryBreached() {
        DisposableGC.getDefault().invokeSystemGCWithMarker();
    }

    public static long totalActiveAllocated() {
        return JMemory.totalAllocated() - JMemory.totalDeAllocated();
    }

    public static native long totalAllocateCalls();

    public static native long totalAllocated();

    public static native long totalAllocatedSegments0To255Bytes();

    public static native long totalAllocatedSegments256OrAbove();

    public static native long totalDeAllocateCalls();

    public static native long totalDeAllocated();

    protected static native int transferTo0(long var0, byte[] var2, int var3, int var4, int var5);

    public JMemory(ByteBuffer byteBuffer) {
        this(byteBuffer.limit() - byteBuffer.position());
        this.transferFrom(byteBuffer);
    }

    public JMemory(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("size must be greater than 0");
        }
        this.allocate(n);
    }

    public JMemory(JMemory jMemory) {
        this.allocate(jMemory.size);
        jMemory.transferTo(this);
    }

    public JMemory(Type type) {
        if (type != Type.POINTER) {
            throw new IllegalArgumentException("Only POINTER types are supported");
        }
    }

    private long allocate(int n) {
        this.physical = JMemory.allocate0(n);
        this.size = n;
        this.owner = true;
        this.keeper = this;
        this.ref = this.createReference(this.physical, n);
        return this.physical;
    }

    public void check() throws IllegalStateException {
        if (this.physical == 0L) {
            throw new IllegalStateException("peered object not synchronized with native structure");
        }
    }

    private final int check(int n, int n2, long l) {
        if (l == 0L) {
            throw new NullPointerException();
        }
        if (n < 0 || n + n2 > this.size) {
            throw new IndexOutOfBoundsException(String.format("index=%d, len=%d, size=%d", n, n2, this.size));
        }
        return n;
    }

    protected void cleanup() {
        if (this.ref != null) {
            this.ref.dispose();
            if (this.ref != null) {
                this.ref.remove();
            }
            this.ref = null;
        }
        this.owner = false;
        this.keeper = null;
        this.physical = 0L;
        this.size = 0;
    }

    protected JMemoryReference createReference(long l, long l2) {
        return new JMemoryReference(this, l, l2);
    }

    public boolean isInitialized() {
        return this.physical != 0L;
    }

    public boolean isJMemoryBasedOwner() {
        return this.physical != 0L && (this.owner || this.keeper instanceof JMemory);
    }

    public final boolean isOwner() {
        return this.owner;
    }

    protected native int peer(ByteBuffer var1) throws PeeringException;

    protected int peer(JMemory jMemory) {
        return this.peer(jMemory, 0, jMemory.size);
    }

    protected int peer(JMemory jMemory, int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 < 0 || n + n2 > jMemory.size) {
            throw new IndexOutOfBoundsException("Invalid [" + n + "," + (n + n2) + "," + n2 + ") range.");
        }
        return this.peer0(jMemory.physical + (long)n, n2, jMemory.keeper);
    }

    private int peer0(long l, int n, Object object) throws IndexOutOfBoundsException {
        if (l != this.physical) {
            this.cleanup();
        }
        this.physical = l;
        this.size = n;
        this.keeper = object;
        return this.size;
    }

    public void setSize(int n) {
        if (n > this.size) {
            throw new IllegalArgumentException(String.format("size (%d) parameter must be less then buffer size (%d)", n, this.size));
        }
        if (n < 0) {
            throw new IllegalArgumentException("negative size parameter");
        }
        this.size = n;
    }

    private void setSize0(int n) {
        this.size = n;
    }

    public int size() {
        if (!this.isInitialized()) {
            throw new NullPointerException("jmemory not initialized");
        }
        return this.size;
    }

    public String toDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JMemory: JMemory@").append(Long.toHexString(this.physical)).append(this.getClass().toString()).append(": ");
        stringBuilder.append("size=").append(this.size).append(" bytes");
        if (!this.owner) {
            stringBuilder.append("\n");
            stringBuilder.append("JMemory: owner=").append(this.keeper == null ? "null" : this.keeper.getClass().getName().replaceAll("org.jnetpcap.", ""));
            stringBuilder.append(".class");
            if (this.keeper instanceof JMemory) {
                JMemory jMemory = (JMemory)this.keeper;
                stringBuilder.append("(size=").append(jMemory.size);
                stringBuilder.append("/offset=").append(this.physical - jMemory.physical);
                stringBuilder.append(')');
            }
        } else {
            stringBuilder.append("\n").append("JMemory: isOwner=").append(this.owner);
        }
        return stringBuilder.toString();
    }

    public String toHexdump() {
        JBuffer jBuffer = new JBuffer(Type.POINTER);
        jBuffer.peer(this);
        return FormatUtils.hexdumpCombined(jBuffer.getByteArray(0, this.size), 0, 0, true, true, true);
    }

    public String toHexdump(int n, boolean bl, boolean bl2, boolean bl3) {
        n = n < this.size ? n : this.size;
        JBuffer jBuffer = new JBuffer(Type.POINTER);
        jBuffer.peer(this);
        return FormatUtils.hexdumpCombined(jBuffer.getByteArray(0, n), 0, 0, bl, bl2, bl3);
    }

    protected int transferFrom(byte[] byArray) {
        return this.transferFrom(byArray, 0, byArray.length, 0);
    }

    protected native int transferFrom(byte[] var1, int var2, int var3, int var4);

    protected int transferFrom(ByteBuffer byteBuffer) {
        return this.transferFrom(byteBuffer, 0);
    }

    protected int transferFrom(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.isDirect()) {
            return this.transferFromDirect(byteBuffer, 0);
        }
        return this.transferFrom(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), 0);
    }

    protected native int transferFromDirect(ByteBuffer var1, int var2);

    protected boolean transferOwnership(JMemory jMemory) {
        if (!jMemory.owner || this.physical == 0L || this.physical != jMemory.physical) {
            return false;
        }
        jMemory.owner = false;
        this.owner = true;
        this.keeper = null;
        if (this.ref != null) {
            throw new IllegalStateException("Can not transfer ownership when already own memory");
        }
        this.ref = this.createReference(jMemory.ref.address, jMemory.ref.size);
        jMemory.ref.remove();
        jMemory.ref = null;
        return true;
    }

    protected int transferTo(byte[] byArray) {
        return this.transferTo(byArray, 0, byArray.length, 0);
    }

    protected int transferTo(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n3 < 0 || n3 + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return JMemory.transferTo0(this.physical, byArray, this.check(n, n2, this.physical), n2, n3);
    }

    public int transferTo(ByteBuffer byteBuffer) {
        return this.transferTo(byteBuffer, 0, this.size);
    }

    public int transferTo(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer.isDirect()) {
            return this.transferToDirect(byteBuffer, n, n2);
        }
        int n3 = this.transferTo(byteBuffer.array(), n, n2, byteBuffer.position());
        byteBuffer.position(byteBuffer.position() + n3);
        return n3;
    }

    public int transferTo(JBuffer jBuffer, int n, int n2, int n3) {
        return this.transferTo((JMemory)jBuffer, n, n2, n3);
    }

    protected int transferTo(JMemory jMemory) {
        return this.transferTo(jMemory, 0, this.size, 0);
    }

    protected native int transferTo(JMemory var1, int var2, int var3, int var4);

    private native int transferToDirect(ByteBuffer var1, int var2, int var3);

    static {
        POINTER = Type.POINTER;
        try {
            System.loadLibrary(JNETPCAP_LIBRARY_NAME);
            Pcap.isInjectSupported();
            JMemory.initIDs();
            JMemory.setMaxDirectMemorySize(JMemory.maxDirectMemory());
            JMemory.setSoftDirectMemorySize(JMemory.softDirectMemory());
            Class.forName("org.jnetpcap.nio.JMemoryReference");
        }
        catch (Exception exception) {
            System.err.println(exception.getClass().getName() + ": " + exception.getLocalizedMessage());
            throw new ExceptionInInitializerError(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        POINTER;

    }
}

