/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import java.lang.ref.PhantomReference;
import org.jnetpcap.nio.Disposable;
import org.jnetpcap.nio.DisposableGC;
import org.jnetpcap.nio.Link;
import org.jnetpcap.nio.LinkSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DisposableReference
extends PhantomReference<Object>
implements Disposable,
Link<DisposableReference> {
    private static final DisposableGC gc = DisposableGC.getDefault();
    private Link<DisposableReference> linkNext;
    private Link<DisposableReference> linkPrev;
    private long ts = System.currentTimeMillis();
    private LinkSequence<DisposableReference> linkCollection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisposableReference(Object object) {
        super(object, DisposableReference.gc.refQueue);
        LinkSequence<DisposableReference> linkSequence = DisposableReference.gc.g0;
        synchronized (linkSequence) {
            DisposableReference.gc.g0.add(this);
        }
        if (!gc.isCleanupThreadActive()) {
            gc.drainRefQueueBounded();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public DisposableReference linkElement() {
        return this;
    }

    @Override
    public LinkSequence<DisposableReference> linkCollection() {
        return this.linkCollection;
    }

    @Override
    public void linkCollection(LinkSequence<DisposableReference> linkSequence) {
        this.linkCollection = linkSequence;
    }

    @Override
    public Link<DisposableReference> linkNext() {
        return this.linkNext;
    }

    @Override
    public void linkNext(Link<DisposableReference> link) {
        this.linkNext = link;
    }

    @Override
    public Link<DisposableReference> linkPrev() {
        return this.linkPrev;
    }

    @Override
    public void linkPrev(Link<DisposableReference> link) {
        this.linkPrev = link;
    }

    public String toString() {
        return String.format("prev=%s, next=%s", this.linkPrev, this.linkNext);
    }

    public void remove() {
        this.linkCollection().remove(this);
        super.clear();
    }

    public int size() {
        return 0;
    }

    public long getTs() {
        return this.ts;
    }

    public void setTs(long l) {
        this.ts = l;
    }
}

