/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.nio.ByteBuffer;

public class PcapBpfProgram {
    private volatile long physical = 0L;
    private ByteBuffer buffer;

    private static native void initIDs();

    public PcapBpfProgram() {
        this.initPeer();
        this.buffer = null;
    }

    private native void initPeer();

    public PcapBpfProgram(byte[] byArray) {
        this.buffer = null;
        if (byArray == null) {
            throw new NullPointerException("BPF instruction array is null");
        }
        if (byArray.length % 8 != 0) {
            throw new IllegalArgumentException("Invalid BPF instruction buffer length. Must be a multiple of 8");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("BPF instruction array is empty");
        }
        this.initPeer();
        this.initFromArray(byArray);
    }

    public PcapBpfProgram(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException("BPF instruction buffer is null");
        }
        int n = byteBuffer.limit() - byteBuffer.position();
        if (n % 8 != 0) {
            throw new IllegalArgumentException("Invalid BPF instruction buffer length. Must be a multiple of 8");
        }
        if (n == 0) {
            throw new IllegalArgumentException("BPF instruction array is empty");
        }
        this.initPeer();
        if (!byteBuffer.isDirect()) {
            this.initFromArray(byteBuffer.array());
        } else {
            this.initFromBuffer(byteBuffer);
            this.buffer = byteBuffer;
        }
    }

    protected void finalize() {
        if (this.physical != 0L) {
            this.cleanup();
        }
    }

    private native void cleanup();

    private void initFromArray(byte[] byArray) {
        this.buffer = ByteBuffer.allocateDirect(byArray.length);
        this.buffer.put(byArray);
        this.initFromBuffer(this.buffer);
    }

    private native void initFromBuffer(ByteBuffer var1);

    public native int getInstructionCount();

    public native long getInstruction(int var1);

    public long[] toLongArray() {
        int n = this.getInstructionCount();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.getInstruction(i);
        }
        return lArray;
    }

    static {
        try {
            Class.forName("org.jnetpcap.Pcap");
            PcapBpfProgram.initIDs();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

