/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.nio.ByteBuffer;
import java.util.List;
import org.jnetpcap.ByteBufferHandler;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.PcapBpfProgram;
import org.jnetpcap.PcapClosedException;
import org.jnetpcap.PcapDumper;
import org.jnetpcap.PcapHandler;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapInteger;
import org.jnetpcap.PcapPktBuffer;
import org.jnetpcap.PcapPktHdr;
import org.jnetpcap.PcapStat;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JNumber;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPacketHandler;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pcap {
    public static final int DEFAULT_PROMISC = 1;
    public static final int DEFAULT_SNAPLEN = 65536;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final int DISPATCH_BUFFER_FULL = -1;
    public static final String JNETPCAP_LIBRARY_NAME = "jnetpcap";
    @Deprecated
    public static final int LOOP_INFINATE = -1;
    public static final int LOOP_INFINITE = -1;
    public static final int LOOP_INTERRUPTED = -2;
    public static final int MODE_BLOCKING = 0;
    public static final int MODE_NON_BLOCKING = 1;
    public static final int MODE_NON_PROMISCUOUS = 0;
    public static final int MODE_PROMISCUOUS = 1;
    public static final int NEXT_EX_EOF = -2;
    public static final int NEXT_EX_NOT_OK = -1;
    public static final int NEXT_EX_OK = 1;
    public static final int NEXT_EX_TIMEDOUT = 0;
    public static final int NOT_OK = -1;
    public static final int OK = 0;
    private volatile long physical;

    public static native int compileNoPcap(int var0, int var1, PcapBpfProgram var2, String var3, int var4, int var5);

    public static native int datalinkNameToVal(String var0);

    public static native String datalinkValToDescription(int var0);

    public static native String datalinkValToName(int var0);

    public static native int findAllDevs(List<PcapIf> var0, StringBuilder var1);

    @Deprecated
    public static void freeAllDevs(List<PcapIf> list, byte[] byArray) {
        if (list == null || byArray == null) {
            throw new NullPointerException();
        }
        list.clear();
    }

    public static void freeAllDevs(List<PcapIf> list, StringBuilder stringBuilder) {
        if (list == null || stringBuilder == null) {
            throw new NullPointerException();
        }
        stringBuilder.setLength(0);
        list.clear();
    }

    public static native void freecode(PcapBpfProgram var0);

    private static native void initIDs();

    public static native boolean isInjectSupported();

    public static native boolean isSendPacketSupported();

    public static native String libVersion();

    public static native String lookupDev(StringBuilder var0);

    public static native int lookupNet(String var0, JNumber var1, JNumber var2, StringBuilder var3);

    @Deprecated
    public static native int lookupNet(String var0, PcapInteger var1, PcapInteger var2, StringBuilder var3);

    public static native Pcap openDead(int var0, int var1);

    public static native Pcap openLive(String var0, int var1, int var2, int var3, StringBuilder var4);

    public static native Pcap openOffline(String var0, StringBuilder var1);

    public native void breakloop();

    protected native void checkIsActive() throws PcapClosedException;

    public native void close();

    public native int compile(PcapBpfProgram var1, String var2, int var3, int var4);

    public native int datalink();

    private int datalinkToId() {
        int n = JRegistry.mapDLTToId(this.datalink());
        return n == -1 ? 1 : n;
    }

    public <T> int dispatch(int n, ByteBufferHandler<T> byteBufferHandler, T t) {
        return this.dispatch(n, byteBufferHandler, t, new PcapHeader(JMemory.Type.POINTER));
    }

    private native <T> int dispatch(int var1, ByteBufferHandler<T> var2, T var3, PcapHeader var4);

    public <T> int dispatch(int n, int n2, JPacketHandler<T> jPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, n2, jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    private native <T> int dispatch(int var1, int var2, JPacketHandler<T> var3, T var4, JPacket var5, JPacket.State var6, PcapHeader var7, JScanner var8);

    public <T> int dispatch(int n, int n2, PcapPacketHandler<T> pcapPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, n2, pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    private native <T> int dispatch(int var1, int var2, PcapPacketHandler<T> var3, T var4, JPacket var5, JPacket.State var6, PcapHeader var7, JScanner var8);

    public <T> int dispatch(int n, JBufferHandler<T> jBufferHandler, T t) {
        return this.dispatch(n, jBufferHandler, t, new PcapHeader(JMemory.Type.POINTER), new JBuffer(JMemory.Type.POINTER));
    }

    private native <T> int dispatch(int var1, JBufferHandler<T> var2, T var3, PcapHeader var4, JBuffer var5);

    public <T> int dispatch(int n, JPacketHandler<T> jPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, this.datalinkToId(), jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    public <T> int dispatch(int n, JPacketHandler<T> jPacketHandler, T t, JScanner jScanner) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, this.datalinkToId(), jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), jScanner);
    }

    public native int dispatch(int var1, PcapDumper var2);

    @Deprecated
    public native <T> int dispatch(int var1, PcapHandler<T> var2, T var3);

    @Deprecated
    public <T> int dispatch(int n, PcapPacketHandler<T> pcapPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, this.datalinkToId(), pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    @Deprecated
    public <T> int dispatch(int n, PcapPacketHandler<T> pcapPacketHandler, T t, JScanner jScanner) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, this.datalinkToId(), pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), jScanner);
    }

    public native PcapDumper dumpOpen(String var1);

    protected void finalize() {
        if (this.physical != 0L) {
            this.close();
        }
    }

    public native String getErr();

    public native int getNonBlock(StringBuilder var1);

    public int inject(byte[] byArray) {
        this.checkIsActive();
        int n = byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.put(byArray);
        return this.injectPrivate(byteBuffer, 0, n);
    }

    public int inject(byte[] byArray, int n, int n2) {
        this.checkIsActive();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.put(byArray, n, n2);
        return this.injectPrivate(byteBuffer, 0, n2);
    }

    public int inject(ByteBuffer byteBuffer) {
        this.checkIsActive();
        if (!byteBuffer.isDirect()) {
            int n = byteBuffer.limit() - byteBuffer.position();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
            byteBuffer2.put(byteBuffer);
            return this.injectPrivate(byteBuffer2, 0, n);
        }
        return this.injectPrivate(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    public native int inject(JBuffer var1, int var2, int var3);

    private native int injectPrivate(ByteBuffer var1, int var2, int var3);

    public native int isSwapped();

    public <T> int loop(int n, ByteBufferHandler<T> byteBufferHandler, T t) {
        return this.loop(n, byteBufferHandler, t, new PcapHeader(JMemory.Type.POINTER));
    }

    private native <T> int loop(int var1, ByteBufferHandler<T> var2, T var3, PcapHeader var4);

    public <T> int loop(int n, int n2, JPacketHandler<T> jPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, n2, jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    private native <T> int loop(int var1, int var2, JPacketHandler<T> var3, T var4, JPacket var5, JPacket.State var6, PcapHeader var7, JScanner var8);

    public <T> int loop(int n, int n2, PcapPacketHandler<T> pcapPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, n2, pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    private native <T> int loop(int var1, int var2, PcapPacketHandler<T> var3, T var4, JPacket var5, JPacket.State var6, PcapHeader var7, JScanner var8);

    public <T> int loop(int n, JBufferHandler<T> jBufferHandler, T t) {
        return this.loop(n, jBufferHandler, t, new PcapHeader(JMemory.Type.POINTER), new JBuffer(JMemory.Type.POINTER));
    }

    private native <T> int loop(int var1, JBufferHandler<T> var2, T var3, PcapHeader var4, JBuffer var5);

    public <T> int loop(int n, JPacketHandler<T> jPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, this.datalinkToId(), jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    public <T> int loop(int n, JPacketHandler<T> jPacketHandler, T t, JScanner jScanner) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, this.datalinkToId(), jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), jScanner);
    }

    public native int loop(int var1, PcapDumper var2);

    @Deprecated
    public native <T> int loop(int var1, PcapHandler<T> var2, T var3);

    public <T> int loop(int n, PcapPacketHandler<T> pcapPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, this.datalinkToId(), pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    public <T> int loop(int n, PcapPacketHandler<T> pcapPacketHandler, T t, JScanner jScanner) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, this.datalinkToId(), pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), jScanner);
    }

    public native int majorVersion();

    public native int minorVersion();

    public native JBuffer next(PcapHeader var1, JBuffer var2);

    @Deprecated
    public native ByteBuffer next(PcapPktHdr var1);

    public native int nextEx(PcapHeader var1, JBuffer var2);

    public int nextEx(PcapPacket pcapPacket) {
        int n = this.nextEx(pcapPacket.getCaptureHeader(), pcapPacket);
        pcapPacket.scan(JRegistry.mapDLTToId(this.datalink()));
        return n;
    }

    @Deprecated
    public native int nextEx(PcapPktHdr var1, PcapPktBuffer var2);

    public int sendPacket(byte[] byArray) {
        this.checkIsActive();
        int n = byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.put(byArray);
        return this.sendPacketPrivate(byteBuffer, 0, n);
    }

    public int sendPacket(byte[] byArray, int n, int n2) {
        this.checkIsActive();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.put(byArray, n, n2);
        return this.sendPacketPrivate(byteBuffer, 0, n2);
    }

    public int sendPacket(ByteBuffer byteBuffer) {
        this.checkIsActive();
        if (!byteBuffer.isDirect()) {
            int n = byteBuffer.limit() - byteBuffer.position();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
            byteBuffer2.put(byteBuffer);
            return this.sendPacketPrivate(byteBuffer2, 0, n);
        }
        return this.sendPacketPrivate(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    public native int sendPacket(JBuffer var1);

    private native int sendPacketPrivate(ByteBuffer var1, int var2, int var3);

    public native int setDatalink(int var1);

    public native int setFilter(PcapBpfProgram var1);

    public native int setNonBlock(int var1, StringBuilder var2);

    public native int snapshot();

    public native int stats(PcapStat var1);

    public String toString() {
        this.checkIsActive();
        return Pcap.libVersion();
    }

    static {
        System.loadLibrary(JNETPCAP_LIBRARY_NAME);
        Pcap.initIDs();
        try {
            Class.forName("org.jnetpcap.PcapDumper");
            Class.forName("org.jnetpcap.PcapIf");
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

