package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class ThreeDLocation extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private SInt32 latitude;

	@Internal(order = 1)
	private SInt32 longitude;

	@Internal(order = 2)
	private Opaque elevation;

	// ---- constructors ----

	public ThreeDLocation() {
	}

	public ThreeDLocation(DataInputStream in) throws IOException {
		latitude = new SInt32(in);
		longitude = new SInt32(in);
		elevation = new Opaque(in, 2, true);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public SInt32 getLatitude() {
		return this.latitude;
	}

	public SInt32 getLongitude() {
		return this.longitude;
	}

	public Opaque getElevation() {
		return this.elevation;
	}

	// ---- setter ----

	public void setLatitude(SInt32 latitude) {
		this.latitude = latitude;
	}

	public void setLongitude(SInt32 longitude) {
		this.longitude = longitude;
	}

	public void setElevation(Opaque elevation) {
		this.elevation = elevation;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		int written = WaveUtils.writeWave(out, latitude, longitude);
		if (!elevation.isArray() || elevation.getLength() != 2)
			throw new IllegalArgumentException(
					"elevation must be array of length 2");
		written += WaveUtils.writeWave(out, elevation);
		return written;
	}
	
	public boolean latitudeIsAvailable(){
		if( latitude == null || latitude.get() == 900000001){
			return false;
		} else if(latitude.get() > 900000001 || latitude.get() < -900000000){
			throw new IllegalArgumentException("Invalid latitude value!");
		} else return true;
	}
	
	public boolean longitudeIsAvailable(){
		if( longitude == null || longitude.get() == 1800000001){
			return false;
		} else if(longitude.get() > 1800000001 || longitude.get() < -1800000000){
			throw new IllegalArgumentException("Invalid longitude value!");
		} else return true;
	}

}