package org.etsi.its.tool.elvior;

import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriMessage;


/**
 * 
 * Note that "Enable Internal Codec" field shall be set to true
 *
 */
public class LibItsSremSsem_asn1 extends LibIts_asn1 {
    
    /**
     * Constructor
     */
    public LibItsSremSsem_asn1() {
        _logger.entering("LibItsSremSsem_asn1", "LibItsSremSsem_asn1");
        _encodingName = "SREM_SSEM_ETSI";
    }
    
    @Override
    public Value decode(final TriMessage message, final Type decodingHypothesis) {
        _logger.entering("LibItsSremSsem_asn1", "decode", decodingHypothesis.getName());
        
        if (decodingHypothesis.getName().endsWith("SREM")) {
            Type type = getTypeForName("SREM_PDU_Descriptions.SREM");
            return super.decode(message, type);
        } else {
            Type type = getTypeForName("SSEM_PDU_Descriptions.SSEM");
            return super.decode(message, type);
        }
    }
    
    @Override
    public TriMessage encode(final Value template) {
        _logger.entering("LibItsSremSsem_asn1", "encode", template.getType().getName());
        
        TriMessage result;
        String type = String.format("%s.%s", _encodingName, template.getType().getName());
        if (template.getType().getName().endsWith("SREM")) {
        	_encodingName = "SREM_PDU_Descriptions";
        	result = super.encode(template);
        } else {
        	_encodingName = "SREM_PDU_Descriptions";
        	result = super.encode(template);
        }
        _encodingName = "SREM_SSEM_ETSI";
        
        return result;
    }
    
} // End of class LibItsSremSsem_asn1 
