#ifndef UpperTesterGnCODEC_H
#define UpperTesterGnCODEC_H

#include "Codec.hh"
#include "loggers.hh" // TODO To be removed
#include "Params.hh"

class Base_Type;
class Record_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibItsGeoNetworking__TypesAndValues {
  class UtGnResults;
  class UtGnEventInd;
}

class UpperTesterGnCodec: public Codec <
  Record_Type,
  Record_Type>
{
  const unsigned char c_utGnInitialize = 0x00;
  const unsigned char c_utGnInitializeResult = 0x01;
  const unsigned char c_utGnChangePosition = 0x02;
  const unsigned char c_utGnChangePositionResult = 0x03;
  const unsigned char c_utGnTriggerResult = 0x41;
  const unsigned char c_utGnTrigger_GeoUnicast = 0x50;
  const unsigned char c_utGnTrigger_GeoBroadcast = 0x51;
  const unsigned char c_utGnTrigger_GeoAnycast = 0x52;
  const unsigned char c_utGnTrigger_Shb = 0x53;
  const unsigned char c_utGnTrigger_Tsb = 0x54;

  int encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer);

public:
  UpperTesterGnCodec() : Codec<Record_Type, Record_Type>() { loggers::get_instance().log("UpperTesterGnCodec::UpperTesterGnCodec(D)"); };
  virtual ~UpperTesterGnCodec() { loggers::get_instance().log("UpperTesterGnCodec::~UpperTesterGnCodec"); };

  virtual int encode (const Record_Type&, OCTETSTRING& data);
  virtual int encode (const Base_Type&, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, Record_Type&, Params* params = NULL);
  virtual std::unique_ptr<Base_Type> decode (const OCTETSTRING& data, Params* params = NULL);
  
private:
  int decode (const OCTETSTRING& data, LibItsGeoNetworking__TypesAndValues::UtGnResults& msg, Params* params = NULL);
  int decode (const OCTETSTRING& data, LibItsGeoNetworking__TypesAndValues::UtGnEventInd& msg, Params* params = NULL);
};
#endif
