#ifndef UpperTesterDenmCODEC_H
#define UpperTesterDenmCODEC_H

#include "Codec.hh"
#include "loggers.hh" // TODO To be removed
#include "Params.hh"

class Base_Type;
class Record_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibItsDenm__TypesAndValues {
  class UtDenmResults;
  class UtDenmEventInd;
}

class UpperTesterDenmCodec: public Codec <
  Record_Type,
  Record_Type>
{
  const unsigned char c_utDenmInitialize = 0x00;
  const unsigned char c_utDenmInitializeResult = 0x01;
  const unsigned char c_utDenmChangePosition = 0x02;
  const unsigned char c_utDenmChangePositionResult = 0x03;
  const unsigned char c_utDenmChangePseudonym = 0x04;
  const unsigned char c_utDenmChangePseudonymResult = 0x05;
  const unsigned char c_utDenmTrigger = 0x10;
  const unsigned char c_utDenmTriggerResult = 0x11;
  const unsigned char c_utDenmUpdate = 0x12;
  const unsigned char c_utDenmUpdateResult = 0x13;
  const unsigned char c_utDenmTermination = 0x14;
  const unsigned char c_utDenmTerminationResult = 0x15;
  const unsigned char c_utDenmEventInd = 0x17;

  int encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer);

public:
  UpperTesterDenmCodec() : Codec<Record_Type, Record_Type>() { loggers::get_instance().log("UpperTesterDenmCodec::UpperTesterDenmCodec(D)"); };
  virtual ~UpperTesterDenmCodec() { loggers::get_instance().log("UpperTesterDenmCodec::~UpperTesterDenmCodec"); };

  virtual int encode (const Record_Type&, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, Record_Type&, Params* params = NULL);
  std::unique_ptr<Base_Type> decode (const OCTETSTRING& data, Params* params = NULL);
  
private:
  int decode (const OCTETSTRING& data, LibItsDenm__TypesAndValues::UtDenmResults& msg, Params* params = NULL);
  int decode (const OCTETSTRING& data, LibItsDenm__TypesAndValues::UtDenmEventInd& msg, Params* params = NULL);
};
#endif
