#ifndef UpperTesterCamCODEC_H
#define UpperTesterCamCODEC_H

#include "Codec.hh"
#include "loggers.hh" // TODO To be removed
#include "Params.hh"

class Base_Type;
class Record_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibItsCam__TypesAndValues {
  class UtCamTrigger;
  class UtCamResults;
  class UtCamEventInd;
}

class UpperTesterCamCodec: public Codec <
  Record_Type,
  Record_Type>
{
  const unsigned char c_utCamInitialize = 0x00;
  const unsigned char c_utCamInitializeResult = 0x01;
  const unsigned char c_utCamChangePosition = 0x02;
  const unsigned char c_utCamChangePositionResult = 0x03;
  const unsigned char c_utCamChangeCurvature = 0x30;
  const unsigned char c_utCamChangeSpeed = 0x31;
  const unsigned char c_utCamSetAccelerationStatus = 0x32;
  const unsigned char c_utCamSetExteriorLightsStatus = 0x33;
  const unsigned char c_utCamChangeHeading = 0x34;
  const unsigned char c_utCamSetDriveDirection = 0x35;
  const unsigned char c_utCamChangeYawRate = 0x36;
  const unsigned char c_utCamSetStationType = 0x39;
  const unsigned char c_utCamSetVehicleRole = 0x3a;
  const unsigned char c_utCamSetEmbarkationStatus = 0x3b;
  const unsigned char c_utCamSetPtActivation = 0x3c;
  const unsigned char c_utCamSetDangerousGoods = 0x3d;
  const unsigned char c_utCamSetLightBarSirene = 0x3f;
  const unsigned char c_utCamTriggerResult = 0x21;
  const unsigned char c_utCamEventInd = 0x23;

  int encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer);

public:
  UpperTesterCamCodec() : Codec<Record_Type, Record_Type>() { loggers::get_instance().log("UpperTesterCamCodec::UpperTesterCamCodec(D)"); };
  virtual ~UpperTesterCamCodec() { loggers::get_instance().log("UpperTesterCamCodec::~UpperTesterCamCodec"); };

  virtual int encode (const Record_Type&, OCTETSTRING& data);
  int encode (const LibItsCam__TypesAndValues::UtCamTrigger&, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, Record_Type&, Params* params = NULL);
  std::unique_ptr<Base_Type> decode (const OCTETSTRING& data, Params* params = NULL);
  
private:
  int decode (const OCTETSTRING& data, LibItsCam__TypesAndValues::UtCamResults& msg, Params* params = NULL);
  int decode (const OCTETSTRING& data, LibItsCam__TypesAndValues::UtCamEventInd& msg, Params* params = NULL);
};
#endif
