#ifndef UDP_FINAL_LAYER_H
#define UDP_FINAL_LAYER_H

#include <arpa/inet.h>
#include <linux/ip.h>
#include <linux/udp.h>

#include "Layer.hh"
#include "Params.hh"

class UdpLayer : public Layer {
    Params _params;
    struct iphdr* _iphdr;
    struct udphdr* _udphdr;
    struct sockaddr_in _saddr;
    struct sockaddr_in _daddr;

    unsigned short inetCsum(const void *buf, size_t hdr_len);

  public:
    UdpLayer(const std::string & p_type, const std::string & param);
    virtual ~UdpLayer() {}

    virtual void sendData(OCTETSTRING& data, Params& params);
    virtual void receiveData(OCTETSTRING& data, Params& info);
};

#endif
