#ifndef LOCATION_TABLE_H
#define LOCATION_TABLE_H

#include <map>
#include <memory>

class OCTETSTRING;

namespace LibItsGeoNetworking__TypesAndValues {
  class LongPosVector;
}

struct compare_octetstring : public std::binary_function<OCTETSTRING, OCTETSTRING, bool>
{
  bool operator()(const OCTETSTRING& p_os2, const OCTETSTRING& p_os1) const;
};

class LocationTable {
  std::map<unsigned long, std::shared_ptr<LibItsGeoNetworking__TypesAndValues::LongPosVector> > _entries_by_times;
  std::map<OCTETSTRING, std::shared_ptr<LibItsGeoNetworking__TypesAndValues::LongPosVector>, compare_octetstring> _entries_by_mids;

public:
  LocationTable() : _entries_by_times(), _entries_by_mids() { };
  virtual ~LocationTable() { _entries_by_times.clear(); _entries_by_mids.clear();  }; // std::shared_ptr provides memory free process

  const bool has_entry(const OCTETSTRING& p_mid) const;
  void add_entry(const LibItsGeoNetworking__TypesAndValues::LongPosVector& p_long_pos_vector);
  const LibItsGeoNetworking__TypesAndValues::LongPosVector* get_entry(const OCTETSTRING & p_mid) const;
  
  inline const bool empty() const { return _entries_by_mids.empty(); };
  inline void reset() { _entries_by_mids.clear(); _entries_by_times.clear(); };
};

#endif
