#ifndef GEONETWORKING_LAYER_H
#define GEONETWORKING_LAYER_H

#include <unistd.h>
#include <signal.h>
#include <time.h>

#include <mutex>

#include "Layer.hh"
#include "GeoNetworkingCodec.hh"
#include "LocationTable.hh"

namespace LibItsGeoNetworking__TestSystem {
  class GeoNetworkingPort;
  class GeoNetworkingReq;
  class GeoNetworkingInd;
}

namespace LibItsGeoNetworking__TypesAndValues {
  class GeoNetworkingPdu;
  class BeaconHeader;
  class LongPosVector;
  class GN__Address;
}

class GeoNetworkingLayer : public TLayer<LibItsGeoNetworking__TestSystem::GeoNetworkingPort> {
  Params _params;
  GeoNetworkingCodec _codec;
  LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu* _beacon;
  LocationTable _location_table;
  LocationTable _pass_beacon_table;
  std::mutex _sendData; // FIXME To be removed, useless
  timer_t _timerid;
  struct sigevent _sev;
  struct itimerspec _its;
  long long _freq_nanosecs;
  sigset_t _mask;
  struct sigaction _sa;

  /**
   * @desc Initialize a beacon object for a stand alone beaconing
   *       This object could be replaced in case of start_beaconing call from the Adapter Control Port
   * @param p_latitude
   * @param p_longitude
   * @param p_address
   */ 
  void fill_beacon(INTEGER& p_latitude, INTEGER& p_longitude, OCTETSTRING& p_ll_address);
  static void timer_irq_sigalrm_handler(int p_signal, siginfo_t *p_signal_info, void *p_uc);

  const int _signal_id = SIGTERM;

public:
  GeoNetworkingLayer() : TLayer<LibItsGeoNetworking__TestSystem::GeoNetworkingPort>(), _params(), _codec(), _beacon(NULL), _sendData(), _timerid{0}, _sev{0}, _its{0}, _freq_nanosecs(0), _mask{0}, _sa{0} { };
  GeoNetworkingLayer(const std::string& p_type, const std::string& param);
  virtual ~GeoNetworkingLayer();
  
  void sendMsg(const LibItsGeoNetworking__TestSystem::GeoNetworkingReq&, Params& param);
  
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& params);
  virtual OCTETSTRING trigger_ac_event(OCTETSTRING& data, Params& params);
  
  void start_beaconing();
  void start_beaconing(const LibItsGeoNetworking__TypesAndValues::GeoNetworkingPdu& p_beacon);
  void stop_beaconing();
  void send_beacon();
  void start_pass_beaconing(const LibItsGeoNetworking__TypesAndValues::BeaconHeader& p_beacon);
  void stop_pass_beaconing();
  const LibItsGeoNetworking__TypesAndValues::LongPosVector* get_lpv(const LibItsGeoNetworking__TypesAndValues::GN__Address& p_gn_address);
  
};

#endif
