#ifndef DENM_LAYER_H
#define DENM_LAYER_H

#include "Layer.hh"
#include "DENMCodec.hh"

namespace LibItsDenm__TestSystem {
  class DenmPort;
  class DenmReq;
  class DenmInd;
}

class DENMLayer : public TLayer<LibItsDenm__TestSystem::DenmPort> {
  Params _params;
  DENMCodec _codec;
public:
  DENMLayer() : TLayer<LibItsDenm__TestSystem::DenmPort>(), _params(), _codec() {};
  DENMLayer(const std::string & p_type, const std::string & param);
  virtual ~DENMLayer() {};

  void sendMsg(const LibItsDenm__TestSystem::DenmReq&, Params& params);
    
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
};

#endif
