#include "DENMLayer.hh"
#include "DENMTypes.hh"

#include "loggers.hh"

DENMLayer::DENMLayer(const std::string & p_type, const std::string & param) : TLayer<LibItsDenm__TestSystem::DenmPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> DENMLayer::DENMLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void DENMLayer::sendMsg(const LibItsDenm__TestSystem::DenmReq& p, Params& params){
  loggers::get_instance().log(">>> DENMLayer::sendMsg");

  // Encode DENM PDU
  OCTETSTRING data;
  _codec.encode(p.msgOut(), data);
  // Update parameters
  //  Params par(params); // FIXME Review all const Param& in method declarations
  sendData(data, params);
}

void DENMLayer::sendData(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> DENMLayer::sendData: ", data);
  //params.log();
  sendToAllLayers(data, params);
}

void DENMLayer::receiveData(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> DENMLayer::receiveData: ", data);
  
  // Decode the payload
  LibItsDenm__TestSystem::DenmInd p;
  _codec.decode(data, p.msgIn());
  if (!p.msgIn().is_bound()) {
    // Discard it
    
    return;
  } // else, continue
  
  // Process lower layer data
  // gnNextHeader
  Params::const_iterator it = params.find(Params::gn_next_header);
  if (it != params.cend()) {
    p.gnNextHeader() = std::stoi(it->second);
  } else {
    p.gnNextHeader().set_to_omit();
  }
  // gnHeaderType
  it = params.find(Params::gn_header_type);
  if (it != params.cend()) {
    p.gnHeaderType() = std::stoi(it->second);
  } else {
    p.gnHeaderType().set_to_omit();
  }
  // gnHeaderSubtype
  it = params.find(Params::gn_header_sub_type);
  if (it != params.cend()) {
    p.gnHeaderSubtype() = std::stoi(it->second);
  } else {
    p.gnHeaderSubtype().set_to_omit();
  }
  // gnLifetime
  it = params.find(Params::gn_lifetime);
  if (it != params.cend()) {
    p.gnLifetime() = std::stoi(it->second);
  } else {
    p.gnLifetime().set_to_omit();
  }
  // gnTrafficClass
  it = params.find(Params::gn_traffic_class);
  if (it != params.cend()) {
    p.gnTrafficClass() = std::stoi(it->second);
  } else {
    p.gnTrafficClass().set_to_omit();
  }
  // btpDestinationPort
  it = params.find(Params::btp_destination_port);
  if (it != params.cend()) {
    p.btpDestinationPort() = std::stoi(it->second);
  } else {
    p.btpDestinationPort().set_to_omit();
  }
  // btpInfo
  it = params.find(Params::btp_info);
  if (it != params.cend()) {
    p.btpInfo() = std::stoi(it->second);
  } else {
    p.btpInfo().set_to_omit();
  }
  // ssp
  it = params.find(Params::ssp);
  if (it != params.cend()) {
    OCTETSTRING os(it->second.length(), (const unsigned char *)(it->second.c_str()));
    p.ssp() = oct2bit(os);
  } else {
    p.ssp().set_to_omit();
  }
  // its_aid
  it = params.find(Params::its_aid);
  if (it != params.cend()) {
    p.its__aid() = std::stoi(it->second);
  } else {
    p.its__aid().set_to_omit();
  }
  
  // Pass it to the ports if amy
  toAllUpperPorts(p, params);
}

class DENMFactory : public LayerFactory {
  static DENMFactory _f;
public:
  DENMFactory();
  virtual Layer * createLayer(const std::string &  type, const std::string &  param);
};

DENMFactory::DENMFactory(){
  // Register factory
  loggers::get_instance().log(">>> DENMFactory::DENMFactory");
  LayerStackBuilder::RegisterLayerFactory("DENM", this);
}

Layer * DENMFactory::createLayer(const std::string & p_type, const std::string & param){
  return new DENMLayer(p_type, param);
}

DENMFactory DENMFactory::_f;
