#ifndef DENMCODEC_H
#define DENMCODEC_H

#include "Codec.hh"
#include "loggers.hh" // TODO To be removed
#include "Params.hh"

class BITSTRING;
class OCTETSTRING;
class Base_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace DENM__PDU__Descriptions {
  class DENM;
}

class DENMPDUCodec : public PERCodec <DENM__PDU__Descriptions::DENM>
{
public:
  DENMPDUCodec() { loggers::get_instance().log("DENMPDUCodec::DENMPDUCodec(D)"); };
  virtual int encode (const DENM__PDU__Descriptions::DENM& denm, BITSTRING& data);
  virtual int decode (const BITSTRING& data, DENM__PDU__Descriptions::DENM&);
};

class DENMCodec : public Codec<DENM__PDU__Descriptions::DENM, DENM__PDU__Descriptions::DENM>
{
  DENMPDUCodec asnCodec;

public:
  DENMCodec() : Codec<DENM__PDU__Descriptions::DENM, DENM__PDU__Descriptions::DENM>(), asnCodec() { loggers::get_instance().log("DENMCodec::DENMCodec(D)"); };
  virtual ~DENMCodec() { loggers::get_instance().log("DENMCodec::~DENMCodec"); };

  virtual int encode (const DENM__PDU__Descriptions::DENM& denm, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, DENM__PDU__Descriptions::DENM&, Params* params = NULL);
};

#endif
