#ifndef CAM_LAYER_H
#define CAM_LAYER_H

#include "Layer.hh"
#include "CAMCodec.hh"

namespace LibItsCam__TestSystem {
  class CamPort;
  class CamReq;
  class CamInd;
}

class CAMLayer : public TLayer<LibItsCam__TestSystem::CamPort> {
  Params _params;
  CAMCodec _codec;
public:
  CAMLayer() : TLayer<LibItsCam__TestSystem::CamPort>(), _params(), _codec() {};
  CAMLayer(const std::string & p_type, const std::string & param);
  virtual ~CAMLayer() {};

  void sendMsg(const LibItsCam__TestSystem::CamReq&, Params& params);
    
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
};

#endif
