#include "CAMLayer.hh"
#include "CAMTypes.hh"

#include "loggers.hh"

CAMLayer::CAMLayer(const std::string & p_type, const std::string & param) : TLayer<LibItsCam__TestSystem::CamPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> CAMLayer::CAMLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void CAMLayer::sendMsg(const LibItsCam__TestSystem::CamReq& p, Params& params){
  loggers::get_instance().log(">>> CAMLayer::sendMsg");

  // Encode CAM PDU
  OCTETSTRING data;
  _codec.encode(p.msgOut(), data);
  // Update parameters
  //  Params par(params); // FIXME Review all const Param& in method declarations
  sendData(data, params);
}

void CAMLayer::sendData(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> CAMLayer::sendData: ", data);
  //params.log();
  sendToAllLayers(data, params);
}

void CAMLayer::receiveData(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> CAMLayer::receiveData: ", data);
  // Decode the payload
  LibItsCam__TestSystem::CamInd p;
  _codec.decode(data, p.msgIn());

  // Process lower layer data
  // gnNextHeader
  Params::const_iterator it = params.find(Params::gn_next_header);
  if (it != params.cend()) {
    p.gnNextHeader() = std::stoi(it->second);
  } else {
    p.gnNextHeader().set_to_omit();
  }
  // gnHeaderType
  it = params.find(Params::gn_header_type);
  if (it != params.cend()) {
    p.gnHeaderType() = std::stoi(it->second);
  } else {
    p.gnHeaderType().set_to_omit();
  }
  // gnHeaderSubtype
  it = params.find(Params::gn_header_sub_type);
  if (it != params.cend()) {
    p.gnHeaderSubtype() = std::stoi(it->second);
  } else {
    p.gnHeaderSubtype().set_to_omit();
  }
  // gnLifetime
  it = params.find(Params::gn_lifetime);
  if (it != params.cend()) {
    p.gnLifetime() = std::stoi(it->second);
  } else {
    p.gnLifetime().set_to_omit();
  }
  // gnTrafficClass
  it = params.find(Params::gn_traffic_class);
  if (it != params.cend()) {
    p.gnTrafficClass() = std::stoi(it->second);
  } else {
    p.gnTrafficClass().set_to_omit();
  }
  // btpDestinationPort
  it = params.find(Params::btp_destination_port);
  if (it != params.cend()) {
    p.btpDestinationPort() = std::stoi(it->second);
  } else {
    p.btpDestinationPort().set_to_omit();
  }
  // btpInfo
  it = params.find(Params::btp_info);
  if (it != params.cend()) {
    p.btpInfo() = std::stoi(it->second);
  } else {
    p.btpInfo().set_to_omit();
  }
  // ssp
  it = params.find(Params::ssp);
  if (it != params.cend()) {
    OCTETSTRING os(it->second.length(), (const unsigned char *)(it->second.c_str()));
    p.ssp() = oct2bit(os);
  } else {
    p.ssp().set_to_omit();
  }
  // its_aid
  it = params.find(Params::its_aid);
  if (it != params.cend()) {
    p.its__aid() = std::stoi(it->second);
  } else {
    p.its__aid().set_to_omit();
  }
  
  // Pass it to the ports if amy
  toAllUpperPorts(p, params);
}

class CAMFactory : public LayerFactory {
  static CAMFactory _f;
public:
  CAMFactory();
  virtual Layer * createLayer(const std::string &  type, const std::string &  param);
};

CAMFactory::CAMFactory(){
  // Register factory
  loggers::get_instance().log(">>> CAMFactory::CAMFactory");
  LayerStackBuilder::RegisterLayerFactory("CAM", this);
}

Layer * CAMFactory::createLayer(const std::string & p_type, const std::string & param){
  return new CAMLayer(p_type, param);
}

CAMFactory CAMFactory::_f;
