#ifndef CAMCODEC_H
#define CAMCODEC_H

#include "Codec.hh"
#include "loggers.hh" // TODO To be removed
#include "Params.hh"

#include "LibItsCam_TestSystem.hh"
//class BITSTRING;
//class OCTETSTRING;
//class CAM__PDU__Descriptions::CAM;

class CAMPDUCodec : public PERCodec <CAM__PDU__Descriptions::CAM>
{
public:
  CAMPDUCodec() { loggers::get_instance().log("CAMPDUCodec::CAMPDUCodec(D)"); };
  virtual int encode (const CAM__PDU__Descriptions::CAM& cam, BITSTRING& data);
  virtual int decode (const BITSTRING& data, CAM__PDU__Descriptions::CAM&);
};

class CAMCodec : public Codec<CAM__PDU__Descriptions::CAM, CAM__PDU__Descriptions::CAM>
{
  CAMPDUCodec asnCodec;

public:
  CAMCodec() : Codec<CAM__PDU__Descriptions::CAM, CAM__PDU__Descriptions::CAM>(), asnCodec() { loggers::get_instance().log("CAMCodec::CAMCodec(D)"); };
  virtual ~CAMCodec() { loggers::get_instance().log("CAMCodec::~CAMCodec"); };

  virtual int encode (const CAM__PDU__Descriptions::CAM& cam, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, CAM__PDU__Descriptions::CAM&, Params* params = NULL);
};

#endif
