#include "LibItsCam_TestSystem.hh"

#include "CAMCodec.hh"
#include "asn1/asn_application.h" // from asn1c

#include "loggers.hh"

int CAMCodec::encode (const CAM__PDU__Descriptions::CAM& cam, OCTETSTRING& data)
{
  loggers::get_instance().log(">>> CAMCodec::encode");
  BITSTRING b;
  int rc = asnCodec.encode(cam, b);
  if(rc){
    data = bit2oct(b);
    loggers::get_instance().log_msg("CAMCodec::encode: ", data);
  }
  return rc;
}

int CAMCodec::decode (const OCTETSTRING& data, CAM__PDU__Descriptions::CAM& cam, Params* params)
{
  loggers::get_instance().log_msg(">>> CAMCodec::decode: ", data);
  
  int rc = asnCodec.decode(oct2bit(data), cam);
  loggers::get_instance().log("CAMCodec::decode: ASN.1 codec returned %d", rc);
  if(rc) {
    loggers::get_instance().log_msg("CAMCodec::decode: ", cam);
  }
  return rc;
}

extern "C" {
  extern asn_TYPE_descriptor_t asn_DEF_CAM;
}

int CAMPDUCodec::encode (const CAM__PDU__Descriptions::CAM& p_cam, BITSTRING& p_data)
{
  return _encode(CAM__PDU__Descriptions::CAM_descr_, asn_DEF_CAM, p_cam, p_data);
}

int CAMPDUCodec::decode (const BITSTRING& p_data, CAM__PDU__Descriptions::CAM& p_cam)
{
  return _decode(CAM__PDU__Descriptions::CAM_descr_, asn_DEF_CAM, p_data, p_cam);
}
