#ifndef BTP_LAYER_H
#define BTP_LAYER_H

#include "Layer.hh"
#include "BTPCodec.hh"

namespace LibItsBtp__TestSystem {
  class BtpPort;
  class BtpReq;
  class BtpInd;
}

class BTPLayer : public TLayer<LibItsBtp__TestSystem::BtpPort> {
  Params _params;
  BTPCodec _codec;
public:
  BTPLayer() : TLayer<LibItsBtp__TestSystem::BtpPort>(), _params(), _codec() {};
  BTPLayer(const std::string & p_type, const std::string & param);
  virtual ~BTPLayer() {};

  void sendMsg(const LibItsBtp__TestSystem::BtpReq&, Params& param);
    
  virtual void sendData(OCTETSTRING& data, Params& params);
  virtual void receiveData(OCTETSTRING& data, Params& info);
};

#endif
