#include "BTPLayer.hh"
#include "BTPTypes.hh"

#include "loggers.hh"

BTPLayer::BTPLayer(const std::string & p_type, const std::string & param) : TLayer<LibItsBtp__TestSystem::BtpPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> BTPLayer::BTPLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void BTPLayer::sendMsg(const LibItsBtp__TestSystem::BtpReq& p, Params& params){
  loggers::get_instance().log(">>> BTPLayer::sendMsg");

  // Encode BTP PDU
  OCTETSTRING data;
  _codec.encode(p.msgOut(), data);
  // Update parameters
  //  Params par(params); // FIXME Review all const Param& in method declarations
  sendData(data, params);
}

void BTPLayer::sendData(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> BTPLayer::sendData: ", data);
  //params.log();  
  sendToAllLayers(data, params);
}

void BTPLayer::receiveData(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> BTPLayer::receiveData: ", data);
  params.log();  
  // Decode the payload
  LibItsBtp__TestSystem::BtpInd p;
  Params::const_iterator it = params.find(Params::gn_next_header);
  if (it != params.cend()) {
    _codec.set_btp_type((it->second.compare("02") == 0) ? BTPCodec::btpB : BTPCodec::btpA);
  }
  _codec.decode(data, p.msgIn(), &params);
  
  // Pass the BTP raw payload to the upper layers if any
  it = params.find(Params::btp_payload);
  if (it != params.cend()) {
    loggers::get_instance().log("BTPLayer::receiveData: btp_payload=%s", it->second.c_str());
    OCTETSTRING os(str2oct(CHARSTRING(it->second.c_str())));
    receiveToAllLayers(os, params);
  } else {
    loggers::get_instance().warning("BTPLayer::receiveData: No payload to pass to upper layers");
  }
  // Pass it to the ports if amy
  //params.log();
  toAllUpperPorts(p, params);
}

class BTPFactory : public LayerFactory {
  static BTPFactory _f;
public:
  BTPFactory();
  virtual Layer * createLayer(const std::string &  type, const std::string &  param);
};

BTPFactory::BTPFactory(){
  // Register factory
  loggers::get_instance().log(">>> BTPFactory::BTPFactory");
  LayerStackBuilder::RegisterLayerFactory("BTP", this);
}

Layer * BTPFactory::createLayer(const std::string & p_type, const std::string & param){
  return new BTPLayer(p_type, param);
}

BTPFactory BTPFactory::_f;
