// This Test Port skeleton source file was generated by the
// TTCN-3 Compiler of the TTCN-3 Test Executor version CRL 113 200/5 R3A
// for U-ERICSSON\ethgry (ethgry@HU00078339) on Fri Aug 14 21:19:06 2015

// Copyright Ericsson Telecom AB 2000-2014

// You may modify this file. Complete the body of empty functions and
// add your member functions here.

#include "BtpPort.hh"
#include "BTPLayer.hh"
#include "loggers.hh"

namespace LibItsBtp__TestSystem {

  BtpPort::BtpPort(const char *par_port_name) :
    BtpPort_BASE(par_port_name), _cfg_params(), _layer_params(), _layer(NULL), _time_key("BtpPort::outgoing_send") {

  }

  BtpPort::~BtpPort() {
    if (_layer != NULL) {
      delete _layer;
    }
  }

  void BtpPort::set_parameter(const char * parameter_name, const char * parameter_value) {
    loggers::get_instance().log("BtpPort::set_parameter: %s=%s", parameter_name, parameter_value);
    _cfg_params.insert(std::pair<std::string, std::string>(std::string(parameter_name), std::string(parameter_value)));
  }

  /*void BtpPort::Handle_Fd_Event(int fd, boolean is_readable,
    boolean is_writable, boolean is_error) {}*/

  void BtpPort::Handle_Fd_Event_Error(int /*fd*/) {

  }

  void BtpPort::Handle_Fd_Event_Writable(int /*fd*/) {

  }

  void BtpPort::Handle_Fd_Event_Readable(int /*fd*/) {

  }

  /*void BtpPort::Handle_Timeout(double time_since_last_call) {}*/

  void BtpPort::user_map(const char * system_port) {
    loggers::get_instance().log(">>> BtpPort::user_map: %s", system_port);
    // Build layer stack
    Params::iterator it = _cfg_params.find(std::string("params"));
    if (it != _cfg_params.end()) {
      loggers::get_instance().log("BtpPort::user_map: %s", it->second.c_str());
      _layer = LayerStackBuilder::GetInstance()->createLayerStack(it->second.c_str());
      if (static_cast<BTPLayer *>(_layer) == NULL) {
	loggers::get_instance().error("BtpPort::user_map: Invalid stack configuration: %s", it->second.c_str());
      }
      static_cast<BTPLayer *>(_layer)->addUpperPort(this);
    } else {
      loggers::get_instance().error("BtpPort::user_map: No layers defined in configuration file");
    }
  }

  void BtpPort::user_unmap(const char * system_port) {
    loggers::get_instance().log(">>> BtpPort::user_unmap: %s", system_port);
    if (_layer != NULL) {
      delete _layer;
      _layer = NULL;
    }
  }

  void BtpPort::user_start() {

  }

  void BtpPort::user_stop() {

  }

  void BtpPort::outgoing_send(const BtpReq& send_par) {
    loggers::get_instance().log_msg(">>> BtpPort::outgoing_send: payload=", send_par);
    
    float duration;
    loggers::get_instance().set_start_time(_time_key);
    static_cast<BTPLayer *>(_layer)->sendMsg(send_par, _layer_params);
    loggers::get_instance().set_stop_time(_time_key, duration);
  }

  void BtpPort::receiveMsg(const LibItsBtp__TestSystem::BtpInd& p_ind, const Params& p_params) {
    loggers::get_instance().log_msg(">>> BtpPort::receive_msg: ", p_ind);

    incoming_message(p_ind);
  }

} /* end of namespace */

