#pragma once

#include <vector>
#include <map>

class Params : public std::map<std::string, std::string> {
public:
  static const std::string& mac_src;
  static const std::string& mac_dst;
  static const std::string& mac_bc;
  static const std::string& eth_type;
  static const std::string& beaconing;
  static const std::string& ssp;
  static const std::string& its_aid;
  static const std::string& gn_payload;
  static const std::string& gn_next_header;
  static const std::string& gn_header_type;
  static const std::string& gn_header_sub_type;
  static const std::string& gn_lifetime;
  static const std::string& gn_traffic_class;
  static const std::string& btp_type;
  static const std::string& btp_payload;
  static const std::string& btp_destination_port;
  static const std::string& btp_info;

  static const std::string& nic;
  static const std::string& ll_address;
  static const std::string& latitude;
  static const std::string& longitude;
  static const std::string& expiry;
  
  
  Params() : std::map<std::string, std::string>() {};
  Params(const Params& p_params) : std::map<std::string, std::string>(p_params.begin(), p_params.end()) {};
  
  virtual ~Params() {};
  void log();
  void reset();
  static void convert(Params& p_param, const std::string p_parameters);
};

