#ifndef CODEC_H
#define CODEC_H

#include "loggers.hh" // TODO To be removed
#include "Params.hh"

class OCTETSTRING;
class CHARSTRING;
class BITSTRING;

template<typename TPDUEnc, typename TPDUDec> class Codec
{
protected:
  Params* _params;
  
public:
  Codec() : _params(NULL) { loggers::get_instance().log("Codec::Codec"); };
  virtual ~Codec() { loggers::get_instance().log("Codec::~Codec"); };
  virtual int encode(const TPDUEnc& msg, OCTETSTRING& data) = 0;
  virtual int decode(const OCTETSTRING& data, TPDUDec& msg, Params* params = NULL) = 0;
};

struct asn_TYPE_descriptor_s;
class ASN1Recode
{
protected:
  int ber2per (const asn_TYPE_descriptor_s & td, TTCN_Buffer & buf);
  int per2ber (const asn_TYPE_descriptor_s & td, TTCN_Buffer & buf);
  int recode  (const asn_TYPE_descriptor_s & td, int from, int to, TTCN_Buffer & buf);
};

template<typename TPDU> class PERCodec : public ASN1Recode
{
public:
  virtual int encode(const TPDU& msg, BITSTRING& bits) = 0;
  virtual int decode(const BITSTRING& bits, TPDU& msg) = 0;
  
protected:
  inline int _decode (const TTCN_Typedescriptor_t& ttcn, const asn_TYPE_descriptor_s & td, const BITSTRING& p_data, TPDU& msg) {
    TTCN_Buffer buf(bit2oct(p_data));
    TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_WARNING);
    int rc = per2ber (td, buf);
    if (rc > 0) {
      msg.decode(ttcn, buf, TTCN_EncDec::CT_BER, BER_ACCEPT_ALL);
      rc = buf.get_len();
    }
    return rc;
  }
  inline int _encode (const TTCN_Typedescriptor_t& ttcn, const asn_TYPE_descriptor_s & td, const TPDU& msg, BITSTRING& p_data) {
    int rc = -1;
    TTCN_Buffer buf;
    TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_WARNING);
    msg.encode(ttcn, buf, TTCN_EncDec::CT_BER, BER_ENCODE_DER);
    if (buf.get_len() > 0) {
      rc = ber2per (td, buf);
      if (rc > 0) {
        p_data = oct2bit(OCTETSTRING(buf.get_len(), buf.get_data()));
      }
    }
    return rc;
  }
};

#endif
