/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.stream;

import com.siemens.ct.exi.EXIBodyEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EXIStreamEncoder;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.attributes.AttributeFactory;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.util.SimpleDocTypeParser;
import com.siemens.ct.exi.values.StringValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.SAXException;

public class StAXEncoder {
    protected EXIBodyEncoder encoder;
    protected EXIStreamEncoder exiStream;
    protected StringBuilder sbChars = new StringBuilder();
    protected SimpleDocTypeParser dtdParser;
    protected final boolean preserveDTD;
    protected final boolean preserveComment;
    protected final boolean preservePI;
    protected boolean pendingATs;
    protected AttributeList exiAttributes;

    public StAXEncoder(EXIFactory factory) throws EXIException {
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
        this.exiStream = new EXIStreamEncoder(factory);
        FidelityOptions fo = factory.getFidelityOptions();
        this.preserveDTD = fo.isFidelityEnabled("PRESERVE_DTDS");
        this.preserveComment = fo.isFidelityEnabled("PRESERVE_COMMENTS");
        this.preservePI = fo.isFidelityEnabled("PRESERVE_PIS");
    }

    public void setOutputStream(OutputStream os) throws EXIException, IOException {
        this.encoder = this.exiStream.encodeHeader(os);
    }

    protected void init() {
        this.pendingATs = false;
        this.sbChars.setLength(0);
        this.exiAttributes.clear();
    }

    protected SimpleDocTypeParser getDtdParser() throws SAXException {
        if (this.dtdParser == null) {
            this.dtdParser = new SimpleDocTypeParser();
        }
        return this.dtdParser;
    }

    public void encode(XMLEventReader xmlEvent) throws XMLStreamException, EXIException, IOException {
        block15: while (xmlEvent.hasNext()) {
            XMLEvent event = xmlEvent.nextEvent();
            switch (event.getEventType()) {
                case 7: {
                    this.writeStartDocument();
                    break;
                }
                case 8: {
                    this.writeEndDocument();
                    break;
                }
                case 1: {
                    StartElement se = event.asStartElement();
                    QName qn = se.getName();
                    String pfx = qn.getPrefix();
                    this.writeStartElement(pfx, qn.getLocalPart(), qn.getNamespaceURI());
                    Iterator<Namespace> namespaces = se.getNamespaces();
                    while (namespaces.hasNext()) {
                        Namespace ns = namespaces.next();
                        this.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                    }
                    Iterator<Attribute> attributes = se.getAttributes();
                    while (attributes.hasNext()) {
                        Attribute at = attributes.next();
                        QName qnAt = at.getName();
                        this.writeAttribute(qnAt.getPrefix(), qnAt.getNamespaceURI(), qnAt.getLocalPart(), at.getValue());
                    }
                    continue block15;
                }
                case 2: {
                    this.writeEndElement();
                    break;
                }
                case 13: {
                    Namespace ns = (Namespace)event;
                    this.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                    break;
                }
                case 4: {
                    Characters chars = event.asCharacters();
                    this.writeCharacters(chars.getData());
                    break;
                }
                case 6: {
                    break;
                }
                case 10: {
                    break;
                }
                case 3: {
                    ProcessingInstruction pi = (ProcessingInstruction)event;
                    this.writeProcessingInstruction(pi.getTarget(), pi.getData());
                    break;
                }
                case 5: {
                    Comment cm = (Comment)event;
                    this.writeComment(cm.getText());
                    break;
                }
                case 11: {
                    DTD dtd = (DTD)event;
                    this.writeDTD(dtd.getDocumentTypeDeclaration());
                    break;
                }
                case 15: {
                    break;
                }
                case 9: {
                    EntityReference er = (EntityReference)event;
                    this.writeEntityRef(er.getName());
                    break;
                }
                default: {
                    System.out.println("StAX Event '" + event + "' not supported!");
                }
            }
        }
    }

    public void encode(XMLStreamReader xmlStream) throws XMLStreamException, EXIException, IOException {
        assert (xmlStream.getEventType() == 7);
        this.writeStartDocument();
        block14: while (xmlStream.hasNext()) {
            int event = xmlStream.next();
            switch (event) {
                case 7: {
                    throw new EXIException("Unexpected START_DOCUMENT event");
                }
                case 8: {
                    this.writeEndDocument();
                    break;
                }
                case 1: {
                    QName qn = xmlStream.getName();
                    String pfx = qn.getPrefix();
                    this.writeStartElement(pfx, qn.getLocalPart(), qn.getNamespaceURI());
                    int nsCnt = xmlStream.getNamespaceCount();
                    int i = 0;
                    while (i < nsCnt) {
                        String nsPfx = xmlStream.getNamespacePrefix(i);
                        nsPfx = nsPfx == null ? "" : nsPfx;
                        String nsUri = xmlStream.getNamespaceURI(i);
                        this.writeNamespace(nsPfx, nsUri);
                        ++i;
                    }
                    int atCnt = xmlStream.getAttributeCount();
                    int i2 = 0;
                    while (i2 < atCnt) {
                        QName atQname = xmlStream.getAttributeName(i2);
                        this.writeAttribute(atQname.getPrefix(), atQname.getNamespaceURI(), atQname.getLocalPart(), xmlStream.getAttributeValue(i2));
                        ++i2;
                    }
                    continue block14;
                }
                case 2: {
                    this.writeEndElement();
                    break;
                }
                case 13: {
                    break;
                }
                case 4: {
                    this.writeCharacters(xmlStream.getTextCharacters(), xmlStream.getTextStart(), xmlStream.getTextLength());
                    break;
                }
                case 6: {
                    String ignorableSpace = xmlStream.getText();
                    this.writeCharacters(ignorableSpace);
                    break;
                }
                case 10: {
                    break;
                }
                case 3: {
                    this.writeProcessingInstruction(xmlStream.getPITarget(), xmlStream.getPIData());
                    break;
                }
                case 5: {
                    this.writeCharacters(xmlStream.getTextCharacters(), xmlStream.getTextStart(), xmlStream.getTextLength());
                    break;
                }
                case 11: {
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    System.out.println("Event '" + event + "' not supported!");
                }
            }
        }
    }

    protected void appendChars(String text) {
        this.sbChars.append(text);
    }

    protected void appendChars(char[] text, int start, int len) {
        this.sbChars.append(text, start, len);
    }

    protected void checkPendingEvents() throws EXIException, IOException {
        if (this.pendingATs) {
            this.encoder.encodeAttributeList(this.exiAttributes);
            this.exiAttributes.clear();
            this.pendingATs = false;
        }
        if (this.sbChars.length() > 0) {
            this.encoder.encodeCharacters(new StringValue(this.sbChars.toString()));
            this.sbChars.setLength(0);
        }
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            this.exiAttributes.addAttribute(namespaceURI, localName, prefix, value);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCData(String data) throws XMLStreamException {
        try {
            this.checkPendingEvents();
            this.writeCharacters(data);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.appendChars(text);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.appendChars(text, start, len);
    }

    public void writeComment(String data) throws XMLStreamException {
        if (this.preserveComment) {
            try {
                this.checkPendingEvents();
                char[] chars = data.toCharArray();
                this.encoder.encodeComment(chars, 0, chars.length);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        if (this.preserveDTD) {
            try {
                this.checkPendingEvents();
                SimpleDocTypeParser dtdParser = this.getDtdParser();
                dtdParser.parse(dtd);
                this.encoder.encodeDocType(dtdParser.name, dtdParser.publicID, dtdParser.systemID, dtdParser.text);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        try {
            this.checkPendingEvents();
            this.encoder.encodeEndDocument();
            this.encoder.flush();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEndElement() throws XMLStreamException {
        try {
            this.checkPendingEvents();
            this.encoder.encodeEndElement();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        if (this.preserveDTD) {
            try {
                this.checkPendingEvents();
                this.encoder.encodeEntityReference(name);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        try {
            this.exiAttributes.addNamespaceDeclaration(namespaceURI, prefix);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, "");
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        if (this.preservePI) {
            try {
                this.checkPendingEvents();
                this.encoder.encodeProcessingInstruction(target, data);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        try {
            this.encoder.encodeStartDocument();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        try {
            assert (namespaceURI != null);
            assert (localName != null);
            this.checkPendingEvents();
            this.encoder.encodeStartElement(namespaceURI, localName, prefix);
            this.pendingATs = true;
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }
}

