/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jnetpcap.util.JLogger;
import org.jnetpcap.util.config.ConfigString;
import org.jnetpcap.util.config.SearchpathString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JConfig {
    private static final String BOOTSTRAP_SEARCH_PATH = "config.bootstrap.search.path";
    private static final Properties builtinDefaults;
    public static final String CACHE_DIR_PROPERTY = "jnetpcap.resolver.dir";
    public static final String CACHE_FILE_SUFFIX = ".resolver";
    public static final String CACHE_FILE_SUFFIX_PROPERTY = "jnetpcap.resolver.suffix";
    public static final String CACHE_SUB_DIR = ".jnp";
    public static final String CACHE_SUB_DIR_PROPERTY = "jnetpcap.resolver.subdir";
    private static final String CONFIG_PROPERTY = "config.name";
    private static Map<String, String> globalVariables;
    private static final PropertyChangeSupport listeners;
    private static Logger logger;
    private static final String LOGGER_NAME = "logger.name";
    private static final String LOGGER_SEARCH_PATH = "logger.search.path";
    private static final CompositeProperties loggingProperties;
    public static final String RESOURCE_SEARCH_PATH_PROPERTY = "search.path";
    private static final CompositeProperties topReadOnlyProperties;
    public static final String USER_HOME_PROPERTY = "user.home";
    private static final Properties userProperties;

    public static void addListener(PropertyChangeListener propertyChangeListener, String string) {
        listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public static void addListener(PropertyChangeListener propertyChangeListener, String string, boolean bl) {
        JConfig.addListener(propertyChangeListener, string, Boolean.toString(bl));
    }

    public static void addListener(PropertyChangeListener propertyChangeListener, String string, int n) {
        JConfig.addListener(propertyChangeListener, string, Integer.toString(n));
    }

    public static void addListener(PropertyChangeListener propertyChangeListener, String string, long l) {
        JConfig.addListener(propertyChangeListener, string, Long.toString(l));
    }

    public static void addListener(PropertyChangeListener propertyChangeListener, String string, String string2) {
        listeners.addPropertyChangeListener(string, propertyChangeListener);
        String string3 = JConfig.getProperty(string);
        if (string3 == null) {
            if (string2 != null) {
                JConfig.setProperty(string, string2);
            }
        } else {
            propertyChangeListener.propertyChange(new PropertyChangeEvent(topReadOnlyProperties, string, null, string3));
        }
    }

    public static SearchPath[] createSearchPath(String string) {
        String string2 = topReadOnlyProperties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        SearchpathString searchpathString = new SearchpathString(string2, globalVariables, topReadOnlyProperties);
        SearchPath[] searchPathArray = searchpathString.toArray();
        return searchPathArray;
    }

    private static void exportPropertiesToVariables(Properties properties) {
        for (Object object : topReadOnlyProperties.keySet()) {
            String string = (String)object;
            if (!string.startsWith("var.")) continue;
            String string2 = topReadOnlyProperties.getProperty(string);
            globalVariables.put(string.substring(4), string2);
        }
    }

    public static File getFile(String string, SearchPath[] searchPathArray) throws IOException {
        SearchPath searchPath;
        if (searchPathArray == null) {
            return null;
        }
        File file = null;
        logger.log(Level.FINEST, "searching file for " + string);
        SearchPath[] searchPathArray2 = searchPathArray;
        int n = searchPathArray2.length;
        for (int i = 0; i < n && (file = (searchPath = searchPathArray2[i]).getFile(string)) == null; ++i) {
        }
        return file;
    }

    public static File getFile(String string, String string2) throws IOException {
        if (!topReadOnlyProperties.containsKey(string2)) {
            return null;
        }
        return JConfig.getFile(string, JConfig.createSearchPath(string2));
    }

    public static InputStream getInputStream(String string, SearchPath[] searchPathArray) throws IOException {
        SearchPath searchPath;
        if (searchPathArray == null) {
            return null;
        }
        InputStream inputStream = null;
        logger.log(Level.FINEST, "searching InputStream for " + string);
        SearchPath[] searchPathArray2 = searchPathArray;
        int n = searchPathArray2.length;
        for (int i = 0; i < n && (inputStream = (searchPath = searchPathArray2[i]).getInputStream(string)) == null; ++i) {
        }
        return inputStream;
    }

    public static InputStream getInputStream(String string, String string2) throws IOException {
        if (!topReadOnlyProperties.containsKey(string2)) {
            return null;
        }
        SearchPath[] searchPathArray = JConfig.createSearchPath(string2);
        return JConfig.getInputStream(string, searchPathArray);
    }

    public static String getProperty(String string) {
        return topReadOnlyProperties.getProperty(string);
    }

    public static String getExpandedProperty(String string) {
        ConfigString configString = new ConfigString(JConfig.getProperty(string), globalVariables, topReadOnlyProperties);
        if (configString.expand("")) {
            return configString.toString();
        }
        return null;
    }

    public static String getExpandedProperty(String string, String string2) {
        if (!topReadOnlyProperties.containsKey(string)) {
            return string2;
        }
        ConfigString configString = new ConfigString(JConfig.getProperty(string), globalVariables, topReadOnlyProperties);
        if (configString.expand("")) {
            return configString.toString();
        }
        return string2;
    }

    public static String getProperty(String string, String string2) {
        return topReadOnlyProperties.getProperty(string, string2);
    }

    public static InputStream getResourceInputStream(String string) throws IOException {
        return JConfig.getInputStream(string, RESOURCE_SEARCH_PATH_PROPERTY);
    }

    public static URL getResourceURL(String string) throws IOException {
        return JConfig.getURL(string, RESOURCE_SEARCH_PATH_PROPERTY);
    }

    private static URL getURL(String string, SearchPath[] searchPathArray) throws IOException {
        SearchPath searchPath;
        URL uRL = null;
        if (searchPathArray == null) {
            return null;
        }
        logger.log(Level.FINEST, "searching URL for " + string);
        SearchPath[] searchPathArray2 = searchPathArray;
        int n = searchPathArray2.length;
        for (int i = 0; i < n && (uRL = (searchPath = searchPathArray2[i]).getURL(string)) == null; ++i) {
        }
        return uRL;
    }

    public static URL getURL(String string, String string2) throws IOException {
        if (!topReadOnlyProperties.containsKey(string2)) {
            return null;
        }
        return JConfig.getURL(string, JConfig.createSearchPath(string2));
    }

    public static void init() {
    }

    public static void removeListener(PropertyChangeListener propertyChangeListener) {
        listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public static void removeListener(PropertyChangeListener propertyChangeListener, String string) {
        listeners.removePropertyChangeListener(string, propertyChangeListener);
    }

    public static String setProperty(String string, String string2) {
        String string3 = (String)userProperties.setProperty(string, string2);
        listeners.firePropertyChange(string, string3, string2);
        return string3;
    }

    public static File getDir(SearchPath[] searchPathArray) {
        SearchPath searchPath;
        File file = null;
        if (searchPathArray == null) {
            logger.warning("null search path for directory ");
            return null;
        }
        logger.log(Level.FINEST, "searching file for directory");
        SearchPath[] searchPathArray2 = searchPathArray;
        int n = searchPathArray2.length;
        for (int i = 0; i < n && (file = (searchPath = searchPathArray2[i]).getDir("")) == null; ++i) {
        }
        return file;
    }

    public static File getDir(String string) {
        SearchPath[] searchPathArray = JConfig.createSearchPath(string);
        return JConfig.getDir(searchPathArray);
    }

    public static File createDir(String string, String string2) {
        File file;
        ConfigString configString;
        String string3 = topReadOnlyProperties.getProperty(string);
        if (string3 == null) {
            logger.finer("create directory property not found " + string);
            logger.finer("create directory using defaults " + string2);
            string3 = string2;
        }
        if (!(configString = new ConfigString(string3, globalVariables, topReadOnlyProperties)).expand("")) {
            logger.finer("create directory property expansion failed " + configString.toString());
            configString.setTemplate(string2);
            if (!configString.expand("")) {
                logger.finer("create directory defaults expansion failed " + configString.toString());
                return null;
            }
        }
        if (!(file = new File(configString.toString())).mkdir()) {
            logger.fine("failed to created dir " + file.toString());
            return null;
        }
        logger.fine("created dir " + file.toString());
        return file;
    }

    public static ConfigString createConfigString(String string) {
        return new ConfigString(string, globalVariables, topReadOnlyProperties);
    }

    public static SearchpathString createSearchString(String string) {
        return new SearchpathString(string, globalVariables, topReadOnlyProperties);
    }

    public static Properties getTopProperties() {
        return topReadOnlyProperties;
    }

    public static Properties getUserProperties() {
        return userProperties;
    }

    public static Map<String, String> getGlobalVariables() {
        return globalVariables;
    }

    static {
        URL uRL;
        globalVariables = new HashMap<String, String>();
        logger = JLogger.getLogger(JConfig.class);
        logger = JLogger.getLogger(JConfig.class);
        globalVariables.put("jnp", "org.jnetpcap");
        builtinDefaults = new Properties();
        try {
            uRL = JConfig.class.getClassLoader().getResource("resources/builtin-config.properties");
            if (uRL == null) {
                logger.severe("JConfig.static<>: unable to find builtin-config.properites. Is resources directory in JAR file?");
            } else {
                builtinDefaults.load(new PreprocessStream(uRL.openStream()));
                logger.fine("loaded " + uRL.toString());
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "builtin config intialization", exception);
        }
        userProperties = new Properties();
        topReadOnlyProperties = new CompositeProperties(System.getProperties(), userProperties, builtinDefaults);
        topReadOnlyProperties.setSaveProperties(userProperties);
        JConfig.exportPropertiesToVariables(topReadOnlyProperties);
        String string = JConfig.getProperty(CONFIG_PROPERTY);
        try {
            uRL = JConfig.getURL(string, BOOTSTRAP_SEARCH_PATH);
            if (uRL != null) {
                userProperties.load(uRL.openStream());
                JConfig.exportPropertiesToVariables(userProperties);
                logger.fine("loaded " + uRL.toString());
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "user config intialization", iOException);
        }
        loggingProperties = new CompositeProperties(new Properties[0]);
        Properties properties = new Properties();
        try {
            uRL = JConfig.getURL("builtin-logger.properties", LOGGER_SEARCH_PATH);
            if (uRL == null) {
                logger.severe("JConfig.static<>3: unable to find builtin-logger.properties. Is resources directory in JAR file?");
            } else {
                properties.load(uRL.openStream());
                logger.fine("loaded " + uRL.toString());
                Properties properties2 = new Properties();
                uRL = JConfig.getURL(JConfig.getProperty(LOGGER_NAME), LOGGER_SEARCH_PATH);
                if (uRL != null) {
                    properties2.load(uRL.openStream());
                    loggingProperties.addProperties(userProperties, properties);
                    Level level = logger.getLevel();
                    JLogger.readConfiguration(loggingProperties);
                    logger.setLevel(level);
                    logger.fine("loaded " + uRL.toString());
                    logger.fine("logger config reinitialized from user settings");
                    logger.fine("restoring logging to Level." + level);
                } else {
                    loggingProperties.addProperties(properties);
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "logger config intialization error", exception);
        }
        listeners = new PropertyChangeSupport(topReadOnlyProperties);
    }

    protected static class URLSearch
    implements SearchPath {
        private final ConfigString url;

        public URLSearch(ConfigString configString) {
            this.url = configString;
        }

        public File getFile(String string) throws IOException {
            return null;
        }

        public InputStream getInputStream(String string) throws IOException {
            this.url.reset();
            if (this.url.expand(string, globalVariables, topReadOnlyProperties)) {
                String string2 = this.url.toString();
                URL uRL = null;
                try {
                    uRL = new URL(string2);
                }
                catch (IOException iOException) {
                    this.url.reset().expand(string, globalVariables);
                    logger.log(Level.WARNING, "URL: invalid URL format after expansion '" + string2 + "' property='" + this.url.toString() + "'");
                    return null;
                }
                InputStream inputStream = uRL.openStream();
                if (inputStream != null) {
                    logger.log(Level.FINER, "URL: opened " + string2);
                    return inputStream;
                }
                logger.log(Level.FINEST, "URL: not found " + string2);
            } else {
                logger.log(Level.FINEST, "URL: failed to expand " + this.url.toString());
            }
            return null;
        }

        public URL getURL(String string) throws IOException {
            this.url.reset();
            if (this.url.expand(string, globalVariables, topReadOnlyProperties)) {
                String string2 = this.url.toString();
                URL uRL = null;
                try {
                    uRL = new URL(string2);
                }
                catch (IOException iOException) {
                    this.url.reset().expand(string, globalVariables);
                    logger.log(Level.WARNING, "URL: invalid URL format after expansion '" + string2 + "' property='" + this.url.toString() + "'");
                    return null;
                }
                InputStream inputStream = uRL.openStream();
                if (inputStream != null) {
                    inputStream.close();
                    logger.log(Level.FINER, "URL: opened " + string2);
                    return uRL;
                }
                logger.log(Level.FINEST, "URL: not found " + string2);
            } else {
                logger.log(Level.FINEST, "URL: failed to expand " + this.url.toString());
            }
            return null;
        }

        public String toString() {
            return "URL(" + this.url.getTemplate() + ")";
        }

        public File getDir(String string) {
            return null;
        }
    }

    public static interface SearchPath {
        public File getFile(String var1) throws IOException;

        public InputStream getInputStream(String var1) throws IOException;

        public URL getURL(String var1) throws IOException;

        public File getDir(String var1);
    }

    private static class PreprocessStream
    extends InputStream {
        private static final byte[] str = new byte[]{92, 13, 10};
        private final BufferedInputStream in;

        public PreprocessStream(InputStream inputStream) {
            this.in = new BufferedInputStream(inputStream, 3);
        }

        private boolean matchReaminingChars() throws IOException {
            this.in.mark(2);
            if (this.in.read() != str[1]) {
                this.in.reset();
                return false;
            }
            if (this.in.read() != str[2]) {
                this.in.reset();
                return false;
            }
            return true;
        }

        public synchronized int read() throws IOException {
            int n = this.in.read();
            if (n == str[0] && this.matchReaminingChars()) {
                n = this.in.read();
            }
            return n;
        }
    }

    protected static class FilesystemSearch
    implements SearchPath {
        private final ConfigString filename;

        public FilesystemSearch(ConfigString configString) {
            this.filename = configString;
        }

        public File getFile(String string) throws IOException {
            this.filename.reset();
            if (this.filename.expand(string, globalVariables, topReadOnlyProperties)) {
                String string2 = this.filename.toString();
                File file = new File(string2);
                if (file.isFile()) {
                    logger.log(Level.FINER, "FILE: found " + string2);
                    return file;
                }
                logger.log(Level.FINEST, "FILE: not found " + string2);
            } else {
                logger.log(Level.FINEST, "FILE: failed to expand " + this.filename.toString());
            }
            return null;
        }

        public InputStream getInputStream(String string) throws IOException {
            File file = this.getFile(string);
            if (file != null) {
                return new FileInputStream(file);
            }
            return null;
        }

        public URL getURL(String string) throws IOException {
            File file = this.getFile(string);
            if (file != null) {
                return file.toURI().toURL();
            }
            return null;
        }

        public String toString() {
            return "File(" + this.filename.getTemplate() + ")";
        }

        public File getDir(String string) {
            this.filename.reset();
            if (this.filename.expand(string, globalVariables, topReadOnlyProperties)) {
                String string2 = this.filename.toString();
                File file = new File(string2);
                if (file.isDirectory()) {
                    logger.log(Level.FINER, "FILE: found " + string2);
                    return file;
                }
                logger.log(Level.FINEST, "FILE: not found " + string2);
            } else {
                logger.log(Level.FINEST, "FILE: failed to expand " + this.filename.toString());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeProperties
    extends Properties {
        private static final long serialVersionUID = 98826036967593082L;
        private Properties[] properties;
        private Properties save = null;

        public CompositeProperties(Properties ... propertiesArray) {
            this.properties = propertiesArray;
        }

        public void addProperties(Properties ... propertiesArray) {
            this.properties = propertiesArray;
        }

        @Override
        public synchronized boolean contains(Object object) {
            for (Properties properties : this.properties) {
                if (!properties.contains(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean containsKey(Object object) {
            for (Properties properties : this.properties) {
                if (!properties.containsKey(object)) continue;
                return true;
            }
            return false;
        }

        private Properties flatten() {
            Properties properties = new Properties();
            for (int i = this.properties.length - 1; i >= 0; --i) {
                Properties properties2 = this.properties[i];
                properties.putAll((Map<?, ?>)properties2);
            }
            return properties;
        }

        @Override
        public String getProperty(String string) {
            return this.getProperty(string, null);
        }

        @Override
        public String getProperty(String string, String string2) {
            for (Properties properties : this.properties) {
                if (!properties.containsKey(string)) continue;
                return properties.getProperty(string);
            }
            if (string2 == null) {
                return null;
            }
            return string2;
        }

        @Override
        public Set<Object> keySet() {
            return this.flatten().keySet();
        }

        @Override
        public void list(PrintStream printStream) {
            this.flatten().list(printStream);
        }

        @Override
        public void list(PrintWriter printWriter) {
            this.flatten().list(printWriter);
        }

        @Override
        public synchronized void load(InputStream inputStream) throws IOException {
            throw new UnsupportedOperationException("invalid operation in composite");
        }

        @Override
        public synchronized void loadFromXML(InputStream inputStream) throws IOException, InvalidPropertiesFormatException {
            throw new UnsupportedOperationException("invalid operation in composite");
        }

        @Override
        public Enumeration<?> propertyNames() {
            return this.flatten().propertyNames();
        }

        @Override
        public synchronized Object setProperty(String string, String string2) {
            if (this.save != null) {
                return this.save.setProperty(string, string2);
            }
            return null;
        }

        public void setSaveProperties(Properties properties) {
            this.save = properties;
        }

        @Override
        public synchronized void store(OutputStream outputStream, String string) throws IOException {
            for (Properties properties : this.properties) {
                properties.store(outputStream, string);
                outputStream.flush();
            }
        }

        @Override
        public synchronized void storeToXML(OutputStream outputStream, String string) throws IOException {
            this.flatten().storeToXML(outputStream, string);
            outputStream.flush();
        }

        @Override
        public synchronized void storeToXML(OutputStream outputStream, String string, String string2) throws IOException {
            this.flatten().storeToXML(outputStream, string, string2);
            outputStream.flush();
        }
    }

    protected static class ClasspathSearch
    implements SearchPath {
        private final ConfigString resource;

        public ClasspathSearch(ConfigString configString) {
            this.resource = configString;
        }

        public File getFile(String string) throws IOException {
            return null;
        }

        public InputStream getInputStream(String string) throws IOException {
            URL uRL = this.getURL(string);
            return uRL == null ? null : uRL.openStream();
        }

        public URL getURL(String string) throws IOException {
            this.resource.reset();
            if (this.resource.expand(string, globalVariables, topReadOnlyProperties)) {
                String string2 = this.resource.toString();
                URL uRL = JConfig.class.getClassLoader().getResource(string2);
                if (uRL != null) {
                    logger.log(Level.FINER, "CLASSPATH: found " + string2);
                } else {
                    logger.log(Level.FINEST, "CLASSPATH: not found " + string2);
                }
                return uRL;
            }
            logger.log(Level.FINEST, "CLASSPATH: failed to expand " + this.resource.toString());
            return null;
        }

        public String toString() {
            return "Classpath(" + this.resource.getTemplate() + ")";
        }

        public File getDir(String string) {
            return null;
        }
    }
}

